<?php

namespace App\Http\Controllers\Backend\System;

use App\Constants\DepartmentConstant;
use App\Constants\StatusCode;
use App\Constants\UseConstant;
use App\Helpers\Functions;
use App\Http\Requests\UserRequest;
use App\Models\ExportImport;
use App\Models\HistoryLogin;
use App\Models\HistoryPassword;
use App\Models\TeamMember;
use App\Services\UserService;
use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public $user;
    public $role;
    public $title;

    public function __construct(UserService $user)
    {
        $this->user = $user;
        $role = [
            DepartmentConstant::ADMIN => 'Unit Admin',
            DepartmentConstant:: CEO => 'CEO',
            DepartmentConstant::SALE => 'Sale',
            DepartmentConstant::MARKETING => 'Marketing',
            DepartmentConstant::ACCOUNTING => 'Kế Toán',
            DepartmentConstant::WAREHOUSE => 'Kho',
            DepartmentConstant::CSKH => 'CSKH',
        ];
        $isLeader = [
            UseConstant::LEADER => 'Trưởng nhóm',
            UseConstant::MEMBER => 'Thành viên',
        ];
        $this->title = [
            DepartmentConstant::ADMIN => 'Admin',
            DepartmentConstant:: CEO => 'Ceo',
            DepartmentConstant::SALE => 'Sale',
            DepartmentConstant::MARKETING => 'Mkt',
            DepartmentConstant::ACCOUNTING => 'Kt',
            DepartmentConstant::WAREHOUSE => 'Kho',
            DepartmentConstant::CSKH => 'Cskh',
        ];
        view()->share([
            'role' => $role,
            'isLeader' => $isLeader,
        ]);
    }

    /**
     * Hien thi users
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $docs = User::search($request->all())->paginate(StatusCode::PAGINATE_20);
        if ($request->ajax()) {
            return view('backend.system.users.ajax', compact('docs'));
        }
        return view('backend.system.users.index', compact('docs'));
    }

    /**
     * Create data
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request)
    {
        $input = $request->all();

        $duplicate = !empty($request->phone) ? $this->user->findWhere('phone', $request->phone) : [];
        if (count($duplicate)) {
            return back()->with('error', 'Số điện thoại đã tồn tại !!!');
        }

        $password_default = Functions::getPasswordDefault();
        $input['password'] = bcrypt($password_default);
        $input['username'] = 'Santa.' . $this->title[$request->department_id];
        $this->user->create($input);
        return back()->with('success', 'Thao tác thành công');
    }

    /**
     * Update data
     *
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\RedirectResponse|int
     */
    public function update(Request $request, $id)
    {
        $input = $request->except('confirm_password');
        $this->user->update($id, $input);
        if ($request->ajax()) return 1;
        return back();
    }

    /**
     * get list user role sale
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAllUserDepartment(Request $request)
    {
        $search['searchDepartment'] = $request->department;
        $user = $this->user->getAll($search)->get();
        return response()->json([
            'user' => $user
        ]);
    }

    /**
     * get list user role sale
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAllUserDepartmentNotTeam(Request $request)
    {
        $team_member = TeamMember::all()->pluck('user_id')->toArray();
        $search['searchDepartment'] = $request->department;
        $user = $this->user->getAll($search)->whereNotIn('id', $team_member)->get();
        return response()->json([
            'user' => $user
        ]);
    }


    /**
     * get danh sách user trong team chọn và user chưa có trong team nào.
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAllUserDepartmentTeam(Request $request)
    {
        $user_team_member_id = TeamMember::where('team_id', $request->team_id)->pluck('user_id')->toArray();
        $user_team = User::whereIn('id', $user_team_member_id)->get();
        $team_member = TeamMember::all()->pluck('user_id')->toArray();
        $search['searchDepartment'] = $request->department;
        $user = User::search($search)->whereNotIn('id', $team_member)->get();
        $user = $user->merge($user_team);
        return response()->json([
            'user' => $user
        ]);
    }

    public function historyLogin(Request $request)
    {
        $paginate = $request->customPage ?: StatusCode::PAGINATE_20;
        $histories = HistoryLogin::when(isset($request->start_date) && isset($request->end_date), function ($q) use ($request) {
            $q->whereBetween('created_at', [
                Functions::yearMonthDayTime($request->start_date),
                Functions::yearMonthDayTime($request->end_date),
            ]);
        })->when(isset($request->search), function ($q) use ($request) {
            $q->whereHas('user', function ($qw) use ($request) {
                $qw->where('username', $request->search)->orWhere('name', 'like', '%' . $request->search . '%');
            });
        })->when(isset($request->department_id), function ($q) use ($request) {
            $q->whereHas('user', function ($qw) use ($request) {
                $qw->where('department_id', $request->department_id);
            });
        })->with('user')->OrderByDesc('id')->take(1000)->paginate($paginate);
        if ($request->ajax()) {
            return view('backend.system.history_login.ajax', compact('histories', 'paginate'));
        }
        return view('backend.system.history_login.index', compact('histories'));
    }

    public function historyExport(Request $request)
    {
        $paginate = $request->customPage ?: StatusCode::PAGINATE_20;
        $histories = ExportImport::when(isset($request->start_date) && isset($request->end_date), function ($q) use ($request) {
            $q->whereBetween('created_at', [
                Functions::yearMonthDayTime($request->start_date),
                Functions::yearMonthDayTime($request->end_date),
            ]);
        })->when(isset($request->type), function ($q) use ($request) {
            $q->where('type', $request->type);
        })->when(isset($request->data), function ($q) use ($request) {
            $q->where('data', $request->data);
        })->orderByDesc('id')->paginate($paginate);
        if ($request->ajax()) {
            return view('backend.system.history_export.ajax', compact('histories', 'paginate'));
        }
        return view('backend.system.history_export.index', compact('histories'));
    }

    public function settingPassword(Request $request)
    {

        $password = Functions::getPasswordDefault();

        if ($request->ajax()) {
            $user = User::select('id', 'password')->get();
            $arr_user = [];
            foreach ($user as $item) {
                if (Hash::check($request->password, $item->password)) {
                    $arr_user[] = $item->id;
                }
            }
            return view('backend.system.users.setting_password_ajax', compact('arr_user'));
        }
        return view('backend.system.users.setting_password', compact('password'));
    }

    public function updatePasswordDefault(Request $request)
    {
        $user = Auth::user();
        $password_old = Functions::getPasswordDefault();
        if ($request->arr_user_update && $request->password_new) {
            $arr_user = json_decode($request->arr_user_update);
            $password = bcrypt($request->password_new);
            User::whereIn('id', $arr_user)->update(['password' => $password]);
            HistoryPassword::create(['user_id' => $user->id, 'list_user' => $request->arr_user_update, 'password_old' => $password_old, 'password_new' => $request->password_new]);
            return 1;
        }
        return 0;
    }

    public function ajaxCreateHistory(Request $request)
    {
        Functions::createHistory($request->type,$request->data);
        return 1;
    }

    public function resetLogin(Request $request)
    {
        $user = User::find($request->id);
        if($request->type == 2){
            $pc_name = 0;
        } else {
            $pc_name = NULL;
        }
        $user->update(['pc_name'=>$pc_name]);
        return 1;
    }
}
