<?php

namespace App\Http\Controllers\Backend\System;

use App\Constants\DepartmentConstant;
use App\Constants\StatusCode;
use App\Models\Team;
use App\Models\TeamMember;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\View;

class TeamController extends Controller
{


    public function __construct()
    {
        $userDepot = User::select('id', 'name')->where('department_id', DepartmentConstant::WAREHOUSE)->pluck('name', 'id')->toArray();
        View::share([
            'userDepot' => $userDepot
        ]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $userCSKH = User::select('id', 'name')->where('department_id', DepartmentConstant::CSKH)->pluck('name', 'id')->toArray();
        $data = Team::when(isset($request->name), function ($q) use ($request) {
            return $q->where('name','like','%'. $request->name.'%');
        })->orderBy('id', 'desc')->paginate(StatusCode::PAGINATE_20);
        if($request->ajax()){
            return view('backend.system.team.ajax', compact('data','userCSKH'));
        }
        return view('backend.system.team.index', compact('data','userCSKH'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->except('user_id');
        $team = Team::create($data);
        // insert team member
        if (isset($request->user_id) && count($request->user_id)) {
            foreach ($request->user_id as $item) {
                TeamMember::create([
                    'department_id' => $team->department_id,
                    'user_id' => $item,
                    'team_id' => $team->id
                ]);
            }
        }
        return back()->with('success', 'Thêm nhóm thành công');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $team = Team::find($id);

        TeamMember::where('team_id', $team->id)->delete();

        if (isset($request->user_id) && count($request->user_id)) {
            foreach ($request->user_id as $item) {
                TeamMember::create([
                    'department_id' => $team->department_id,
                    'user_id' => $item,
                    'team_id' => $team->id
                ]);
            }
        }
        $team->update($request->except('user_id'));


        return back()->with('success', 'Cập nhật nhóm thành công');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $team = Team::find($id);
        TeamMember::where('team_id', $team->id)->delete();
        $team->delete();
        return 1;
    }
}
