<?php

namespace App\Http\Controllers\Backend\System;

use App\Constants\StatusCode;
use App\Models\Automation;
use App\Models\CustomerAction;
use App\Models\CustomerStatus;
use App\Models\OrderStatus;
use App\Models\TimeAuto;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SettingOperationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $settings = Automation::orderByDesc('id')->paginate(StatusCode::PAGINATE_20);
        $customerAction = OrderStatus::pluck('name','id')->toArray();
//        $customerAction = [];
        $customerStatus = CustomerStatus::pluck('name','id')->toArray();
//        dd($customerStatus);
        $timeAuto = TimeAuto::pluck('name','id')->toArray();
        return view('backend.system.setting_operation.index',compact('settings','customerAction','customerStatus','timeAuto'));
    }

    /**
 * Show the form for creating a new resource.
 *
 * @return \Illuminate\Http\Response
 */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Automation::create();
        return 1;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return int
     */
    public function update(Request $request, $id)
    {
        $time = Automation::find($id);
        $time->update($request->all());
        return 1;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Automation::find($id)->delete();
        return 1;
    }



}
