<?php

namespace App\Http\Controllers\Backend\System;

use App\Constants\OrderConstant;
use App\Models\Customer;
use App\Models\CustomerStatus;
use App\Models\OrderStatus;
use App\Models\TimeAuto;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class OperationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $status = CustomerStatus::orderBy('position','asc')->get()->map(function ($m){
            $type_ngay = 1;
            $type_gio = 2;
            $type_phut = 3;

            if($m->expired_time >= 1440){
                $m->expired_time = $m->expired_time/1440;
                $m->type_expired_time = $type_ngay;
            } else if($m->expired_time >= 60){
                $m->expired_time = $m->expired_time/60;
                $m->type_expired_time = $type_gio;
            } else {
                $m->type_expired_time = $type_phut;
            }

            if($m->time_move >= 1440){
                $m->time_move = $m->time_move/1440;
                $m->type_time_move = $type_ngay;
            } else if($m->time_move >= 60){
                $m->time_move = $m->time_move/60;
                $m->type_time_move = $type_gio;
            } else {
                $m->type_time_move = $type_phut;
            }

            if($m->time_move_cskh >= 1440){
                $m->time_move_cskh = $m->time_move_cskh/1440;
                $m->type_time_move_cskh = $type_ngay;
            } else if($m->time_move_cskh >= 60){
                $m->time_move_cskh = $m->time_move_cskh/60;
                $m->type_time_move_cskh = $type_gio;
            } else {
                $m->type_time_move_cskh = $type_phut;
            }

            $m->customer_child = $m->customer_child ? json_decode($m->customer_child) : [];
            return $m;
        });


        $action = OrderStatus::orderBy('position','asc')->get();
//        $timeAuto = TimeAuto::all();
        return view('backend.system.operation.index',compact('status','action'));
    }

    /**
     * @return int
     */
    public function createCustomerStatus(Request $request)
    {
        $position_last = CustomerStatus::latest()->first();
        $position_last ? $position = $position_last->position + 1 :  $position = 0;
        CustomerStatus::create(['position' => $position]);
        return 1;
    }

    /**
     * @param Request $request
     * @param $id
     * @return int
     */
    public function updateCustomerStatus(Request $request,$id)
    {
        $type_ngay = 1;
        $type_gio = 2;

        $status = CustomerStatus::find($id);
        $data = $request->except('type_expired_time','type_time_move','type_move_cskh');
        $data['expired_time'] = $request->expired_time;
        if($request->type_expired_time == $type_ngay){
            $data['expired_time'] = $request->expired_time*1440;
        } else if($request->type_expired_time == $type_gio){
            $data['expired_time'] = $request->expired_time*60;
        }

        $data['time_move'] = $request->time_move;
        if($request->type_time_move == $type_ngay){
            $data['time_move'] = $request->time_move*1440;
        } else if($request->type_time_move == $type_gio){
            $data['time_move'] = $request->time_move*60;
        }

//        $data['time_move_cskh'] = $request->time_move_cskh;
//        if($request->type_move_cskh == $type_ngay){
//            $data['time_move_cskh'] = $request->time_move_cskh*1440;
//        } else if($request->type_move_cskh == $type_gio){
//            $data['time_move_cskh'] = $request->time_move_cskh*60;
//        }

        $status->update($data);
        return 1;
    }
    public function deleteCustomerStatus($id)
    {
        $customer_status = Customer::where('status',$id)->first();
        if(!empty($customer_status)){
            $data['success'] = false;
            $data['message'] = 'Đã sử dụng không được xóa !';
            return $data;
        }
        CustomerStatus::find($id)->delete();
        return 1;
    }

    public function createOrderStatus()
    {
        OrderStatus::create();
        return 1;
    }
    public function updateCustomerAction(Request $request,$id)
    {
        $action = OrderStatus::find($id)->update($request->all());
//        $data = $request->all();
//        if($request->close_order == "true"){
//            CustomerAction::where('close_order',1)->update(['close_order'=>CustomerConstant::NOT_START]);
//            $data['close_order'] = 1;
//        } else {
//            $data['close_order'] = 0;
//        }
//
//        $action->update($data);
        return 1;
    }
    public function deleteOrderStatus($id)
    {
        if($id == OrderConstant::STATUS_CHOT_DON || $id == OrderConstant::STATUS_HOAN_HUY){
            return response()->json([
                'success' => false,
                'message' => 'không được xóa!'
            ]);
        }
        OrderStatus::find($id)->delete();
        return 1;

//        $action = CustomerAction::find($id)->with('automation')->first();
//        if($action->automation){
//            return response()->json([
//                'success' => false,
//                'message' => 'Luồng tác nghiệp đang sử dụng không được xóa !'
//            ]);
//        } else {
//            $action->delete();
//            return 1;
//        }
    }


    public function createCustomerTime()
    {
        TimeAuto::create();
        return 1;
    }
    public function updateCustomerTime(Request $request,$id)
    {
        $time = TimeAuto::find($id);
        $time->update($request->all());
        return 1;
    }
    public function deleteCustomerTime($id)
    {
        $time = TimeAuto::find($id)->with('automation')->first();
        if($time->automation){
            return response()->json([
                'success' => false,
                'message' => 'Luồng tác nghiệp đang sử dụng không được xóa !'
            ]);
        } else {
            $time->delete();
            return 1;
        }
    }

    public function updateOrderPosition(Request $request){
        if($request->has('data') && count($request->data)){
            foreach ($request->data as $item){
                OrderStatus::find($item['id'])->update(['position'=>$item['position']]);
            }
        }
        return 1;
    }

    public function updateCustomerPosition(Request $request){
        if($request->has('data') && count($request->data)){
            foreach ($request->data as $item){
                CustomerStatus::find($item['id'])->update(['position'=>$item['position']]);
            }
        }
        return 1;
    }

    public function updateColorCustomerStatus(Request $request){
        $customer_status = CustomerStatus::find($request->id)->update(['color'=>$request->color]);
        if($customer_status) return 1;
        return 0;
    }
}
