<?php

namespace App\Http\Controllers\Backend\Statistical;

use App\Constants\DepartmentConstant;
use App\Constants\OrderConstant;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\Customer;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\Team;
use App\Models\TeamMember;
use App\Models\Source;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class StatisticalController extends Controller
{
    public function phongThan(Request $request)
    {

        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }
        $search = $request->all();
        $teams = Team::select('id', 'name')->where('department_id', DepartmentConstant::SALE)->with('teamMembers')->get()->map(function ($m
        ) use ($search) {
            $m->arr_sale_id = self::getSaleId($m->teamMembers);
            $search['all_sale_id'] = $m->arr_sale_id;
            $all_order_done = Order::search($search)->select('total', 'advance_price')->whereNotIn('status', OrderConstant::STATUS_DON_HOAN_HUY);
            $all_customer_team = Customer::search($search)->whereIn('user_id', $m->arr_sale_id);
            $m->all_customer_team = $all_customer_team->count();
            $m->sum_all_price_done = $all_order_done->sum('total') + $all_order_done->sum('advance_price');
            $m->sum_all_order_done = $all_order_done->count();
            return $m;
        })->sortByDesc("sum_all_price_done")->toArray();
        $teams = array_values($teams);
        $search_sale['department_id'] = DepartmentConstant::SALE;

        $sales = User::search($search_sale)->select('id', 'name', 'avatar')->get()->map(function ($m) use ($search) {
            $search['sale_id'] = $m->id;
            $all_customer = Customer::search($search);
            $orders = Order::search($search)->select('total', 'advance_price')->whereNotIn('status', OrderConstant::STATUS_DON_HOAN_HUY);
            $m->all_customer = $all_customer->count();
            $m->sum_price_done = $orders->sum('total') + $orders->sum('advance_price');
            $m->sum_order_done = $orders->count();
            return $m;
        })->sortByDesc("sum_price_done")->toArray();
        $sales = array_values($sales);

        $search_mkt['department_id'] = DepartmentConstant::MARKETING;
        $marketings = User::search($search_mkt)->select('id', 'name', 'avatar')->get()->map(function ($m) use ($search) {
            $search['marketing'] = $m->id;

            $search['not_in_status'] = [OrderConstant::STATUS_DON_LUU];
            $search['gioi_thieu'] = StatusCode::INACTIVE;
            $all_customer = Customer::search1($search);
            $orders = Order::search($search)->select('total', 'advance_price');
            $m->all_customer = $all_customer->count();
            $m->sum_price_done = $orders->sum('total') + $orders->sum('advance_price');
            $m->sum_order_done = $orders->count();
            return $m;
        })->sortByDesc("sum_price_done")->toArray();

        $marketings = array_values($marketings);


        if ($request->ajax()) {
            return view('backend.statistical.phong_than.ajax', compact('teams', 'sales', 'marketings'));
        }
        return view('backend.statistical.phong_than.index', compact('teams', 'sales', 'marketings'));
    }

    public function getSaleId($teamMember)
    {
        $arr_id = [];
        if ($teamMember && count($teamMember)) {
            foreach ($teamMember as $item) {
                $arr_id[] = $item->user_id;
            }
        }
        return $arr_id;
    }

    public function sumTotal($order)
    {
        $total = [];
        if ($order && count($order)) {
            foreach ($order as $item) {
                $total[] = $item->total;
            }
        }
        return $total;
    }

    public function baoCaoDoanhThu(Request $request)
    {
        $type_search_kho = 1;
        $type_search_san_pham = 2;
        $type_search_khach_cu_moi = 3;
        $products = Product::all();
        $search = $request->all();
        if (empty($request->start_date) && empty($request->end_date)) {
            $search['start_date'] = Carbon::now()->subDays(7)->format('d/m/Y H:i');
            $search['end_date'] = Carbon::now()->format('d/m/Y H:i');
        }

        if (!$request->all() || $request->type_search == $type_search_kho) {
            $search['not_in_status'] = OrderConstant::STATUS_DON_HOAN_HUY;
            $data_depot = Order::search($search)->select('depot_id', 'total', 'discount', 'advance_price',
                DB::raw('sum(total) as total_price'), DB::raw('count(*) as total_order'),
                DB::raw('sum(advance_price) as total_advance_price'),
                DB::raw('sum(ship_price) as total_ship_price'),
                DB::raw('sum(discount) as sum_discount'))->groupBy('depot_id')->get();
            $data_depot = self::orderDiscount($data_depot, $search, 'depot_id');

            if ($request->ajax()) {
                return view('backend.statistical.bao_cao_doanh_thu.ajax', compact('data_depot'));
            }
            return view('backend.statistical.bao_cao_doanh_thu.index', compact('products', 'data_depot'));
        }


        if ($request->type_search == $type_search_san_pham) {
            $search['not_in_status'] = OrderConstant::STATUS_DON_HOAN_HUY;
            $order = Order::search($search)->pluck('id')->toArray();

            $order_details = OrderDetail::whereIn('order_id', $order);
            $order_details1 = clone $order_details;
            $order_details2 = clone $order_details;
            $total_products = $order_details1->select('id', 'total_price', DB::raw('sum(total_price) as total_price'),
                DB::raw('count(id) as total_order'))->get();

            $products = $order_details2->select('id', 'total_price', 'product_id',
                DB::raw('sum(total_price) as total_price'),
                DB::raw('count(id) as total_order'))->groupBy('product_id')->get();
            return view('backend.statistical.bao_cao_doanh_thu.ajax', compact('total_products', 'products'));
        }


        if ($request->type_search == $type_search_khach_cu_moi) {
            $search['orderDepot'] = true;
            $orders = Order::search($search);
            $orders1 = clone $orders;
            $orders2 = clone $orders;
            $orders_all = $orders1->select('id', 'total', 'discount', DB::raw('sum(total) as all_total_price'),
                DB::raw('count(customer_id) as all_total_order'),
                DB::raw('sum(discount) as all_discount'))->get()->map(function ($m) use ($orders1) {
                $m->count_order_discount = $orders1->where('discount', '>', 0)->count();
                return $m;
            });
            $orders_customer = $orders2->select('id', 'total', 'customer_id', 'discount',
                DB::raw('sum(total) as total_price'), DB::raw('count(customer_id) as total_order'),
                DB::raw('sum(discount) as total_discount'))->groupBy('customer_id')->get();
            $orders_customer = self::orderDiscount($orders_customer, $search, 'customer_id');
            return view('backend.statistical.bao_cao_doanh_thu.ajax', compact('orders_all', 'orders_customer'));
        }
    }

    public function orderDiscount($order, $search, $where)
    {
        $order->map(function ($m) use ($where, $search) {
            $m->count_order_discount = Order::search($search)->select('id')->where($where, $m->$where)->where('discount', '>',
                0)->count();
            return $m;
        });
        return $order;
    }


    public function depot(Request $request)
    {
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }
        $search = $request->all();
        $search['not_in_status'] = [OrderConstant::STATUS_DON_LUU,OrderConstant::STATUS_CHOT_DON];
        $orders = Order::search($search, 'id', 'ngay_chot_don')
            ->select('total', 'discount', 'advance_price', 'status', 'depot_id', 'warehouse_id', 'updated_at');

        $users = User::where('department_id', DepartmentConstant::WAREHOUSE)->get()->map(function ($user) use ($orders) {

            $order_user = clone $orders;
            $order_user = $order_user->where('warehouse_id', $user->id);

            $orders1 = clone $order_user;
            $cho_xac_nhan = $orders1->where('status', OrderConstant::STATUS_CHO_XAC_NHAN)->get();
            $user['cho_xac_nhan'] = $cho_xac_nhan->sum('total') + $cho_xac_nhan->sum('advance_price');
            $user['cho_xac_nhan_count'] = count($cho_xac_nhan);

            $orders2 = clone $order_user;
            $dang_hoan = $orders2->where('status', OrderConstant::STATUS_DANG_HOAN)->get();
            $user['dang_hoan'] = $dang_hoan->sum('total') + $dang_hoan->sum('advance_price');
            $user['dang_hoan_count'] = count($dang_hoan);

            $orders3 = clone $order_user;
            $da_hoan = $orders3->where('status', OrderConstant::STATUS_HOAN_HUY)->get();
            $user['da_hoan'] = $da_hoan->sum('total') + $da_hoan->sum('advance_price');
            $user['da_hoan_count'] = count($da_hoan);

            $orders4 = clone $order_user;
            $dang_giao_hang = $orders4->where('status', OrderConstant::STATUS_DANG_GIAO_HANG)->get();
            $user['dang_giao_hang'] = $dang_giao_hang->sum('total') + $dang_giao_hang->sum('advance_price');
            $user['dang_giao_hang_count'] = count($dang_giao_hang);

            $orders5 = clone $order_user;
            $da_nhan_hang = $orders5->where('status', OrderConstant::STATUS_DA_GIAO_HANG)->get();
            $user['da_nhan_hang'] = $da_nhan_hang->sum('total') + $da_nhan_hang->sum('advance_price');
            $user['da_nhan_hang_count'] = count($da_nhan_hang);

            $orders6 = clone $order_user;
            $da_thanh_toan = $orders6->where('status', OrderConstant::STATUS_DA_THANH_TOAN)->get();
            $user['da_thanh_toan'] = $da_thanh_toan->sum('total') + $da_thanh_toan->sum('advance_price');
            $user['da_thanh_toan_count'] = count($da_thanh_toan);

            $orders7 = clone $order_user;
            $order_total = $orders7->where('warehouse_id', $user->id)->get();
//            $user['total'] = $order_total->sum('total') + $order_total->sum('advance_price');
            $user['total_count'] = count($order_total);

            $orders8 = clone $order_user;
            $huy_don = $orders8->where('status', OrderConstant::STATUS_HUY_DON)->get();
            $user['huy_don'] = $huy_don->sum('total') + $huy_don->sum('advance_price');
            $user['huy_don_count'] = count($huy_don);

            $orders9 = clone $order_user;
            $cho_gui = $orders9->where('status', OrderConstant::STATUS_CHO_GUI)->get();
            $user['cho_gui'] = $cho_gui->sum('total') + $cho_gui->sum('advance_price');
            $user['cho_gui_count'] = count($cho_gui);

            $orders10 = clone $order_user;
            $da_dang = $orders10->where('status', OrderConstant::STATUS_DA_DANG)->get();
            $user['da_dang'] = $da_dang->sum('total') + $da_dang->sum('advance_price');
            $user['da_dang_count'] = count($da_dang);

            return $user;
        });

        if ($request->ajax()) {
            return view('backend.statistical.depot.ajax', compact('users'));
        }

        return view('backend.statistical.depot.index', compact('users'));
    }

    /**
     * Phân bổ data theo sale
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function saleCustomerProduct(Request $request)
    {
        if (empty($request->start_date) && empty($request->end_date)) {
            $search['start_date'] = Carbon::now()->subDays(7)->format('d/m/Y H:i');
            $search['end_date'] = Carbon::now()->format('d/m/Y H:i');
        } else {
            $search['start_date'] = $request->start_date;
            $search['end_date'] = $request->end_date;
        }
        if ($request->categories) {
            $categories = ProductCategory::whereIn('id', $request->categories)->select('id', 'name')->get();
        } else {
            $categories = ProductCategory::select('id', 'name')->get();
        }
        $teams = Team::where('department_id', DepartmentConstant::SALE)->select('id', 'name')->get();
        if ($request->team_id) {
            $search['arr_sale_id'] = TeamMember::where('team_id', $request->team_id)->pluck('user_id')->toArray();
        }

        if ($request->categories) {
            $product = Product::select('id', 'category_id')->whereIn('category_id', $request->categories)->get();
        } else {
            $product = Product::select('id', 'category_id')->get();
        }
        $cate = [];
        foreach ($product as $item) {
            $cate[$item->category_id][] = $item->id;
        }

        $customers = [];
        foreach ($cate as $key => $it2) {
            $arr_source = [];
            foreach ($it2 as $item) {
                $source = Source::select('id')->where('product_id', 'like', '%"' . $item . '"%')->pluck('id')->toArray();
                $arr_source[] = $source;
            }
            $arr_source_new = self::flatten($arr_source);
            $arr_source_new = array_unique($arr_source_new);
            $customer = Customer::search($search, 'created_at')->select('user_id', \DB::raw('count(id) as count'))->groupBy('user_id')->whereIn('source_id', $arr_source_new)
                ->get()->map(function ($qrr) use ($key) {
                    $qrr->category_id = $key;
                    return $qrr;
                });
            $customers[] = $customer;
        }
        $sales = [];
        foreach ($customers as $key => $customer) {
            foreach ($customer as $key => $item) {
                $sales[$item->sale->name][$item->category_id] = $item->count;
            }
        }
//        dd($sales);
        if ($request->ajax()) {
            return view('backend.statistical.sale_thong_ke_customer_theo_sp.ajax', compact('categories', 'customers', 'teams','sales'));
        }
        return view('backend.statistical.sale_thong_ke_customer_theo_sp.index', compact('categories', 'customers', 'teams','sales'));
    }

    public static function flatten(array $array)
    {
        $arr = [];
        foreach ($array as $items) {
            if (count($items)) {
                foreach ($items as $item) {
                    array_push($arr, $item);
                }
            }
        }
        return $arr;
    }
}
