<?php

namespace App\Http\Controllers\Backend\Statistical;

use App\Constants\DepartmentConstant;
use App\Constants\OrderConstant;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\Order;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\Team;
use App\Models\TeamMember;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\View\View;

class SaleController extends Controller
{

    public function __construct()
    {
        $products = ProductCategory::pluck('name', 'id')->toArray();
        $team = Team::where('department_id', DepartmentConstant::SALE)->with('user')->get()->map(function ($item) {
            $item->displayName = $item->name . ' - ' . @$item->user->name . ' (' . @$item->user->username . ')';
            return $item->only('id', 'displayName');
        })->pluck('displayName', 'id')->toArray();

        view()->share([
            'products' => $products,
            'team' => $team
        ]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }
        $input = $request->all();

        if (isset($request->category)) {
            $arr_product_id = Product::select('id')->where('category_id', $request->category)->pluck('id');
            $input['arr_product_id'] = $arr_product_id;
        }

        if (!empty($input['team'])) {
            $input['all_sale_id'] = TeamMember::select('user_id')->where('team_id', $input['team'])->pluck('user_id')->toArray();
        }
        $search['not_in_status'] = [
            OrderConstant::STATUS_DON_LUU,
            OrderConstant::STATUS_HUY_DON,
            OrderConstant::STATUS_HOAN_HUY,
            OrderConstant::STATUS_DANG_HOAN,
        ];
//        if ($request->type_search == 1) {
//            $search['not_in_status'] = [
//                OrderConstant::STATUS_CHOT_DON,
//                OrderConstant::STATUS_DON_LUU,
//                OrderConstant::STATUS_HUY_DON,
//                OrderConstant::STATUS_HOAN_HUY,
//                OrderConstant::STATUS_DANG_HOAN,
//            ];
//        }

        $orders = Order::search($input)->select('total', 'advance_price');

        $user = User::select('id', 'name')->where('department_id', DepartmentConstant::SALE)->where('status', StatusCode::ACTIVE)->get()
            ->map(function ($item) use ($orders, $search) {
                $ordersAll = clone $orders;
                $ordersAll = $ordersAll->where('sale_id', $item->id);
                $ordersAllOrder = clone $ordersAll;
                $huy = clone  $ordersAll;
                $hoan = clone  $ordersAll;

                $item->countAll = $ordersAllOrder->whereNotIn('status', [OrderConstant::STATUS_DON_LUU,OrderConstant::STATUS_CHOT_DON])->count();
                $all = $ordersAll->whereNotIn('status', $search['not_in_status']);
                $item->all = $all->sum('total') + $all->sum('advance_price');

                $cho_xac_nhan = clone  $all;
                $received = clone  $all;
                $done = clone  $all;

                $doanh_thu_tt = $received->where('status', '<>', OrderConstant::STATUS_CHOT_DON);
                $item->doanh_thu = $doanh_thu_tt->sum('total') + $doanh_thu_tt->sum('advance_price');

                $dang_giao_hang = $doanh_thu_tt->where('status', OrderConstant::STATUS_DANG_GIAO_HANG);

                $cho_xac_nhan = $cho_xac_nhan->where('status', OrderConstant::STATUS_CHO_XAC_NHAN);

                $done = $done->whereIn('status', [OrderConstant::STATUS_DA_GIAO_HANG, OrderConstant::STATUS_DA_THANH_TOAN]);

                $done_goidau = clone $done;

                $item->done = $done->sum('total') + $done->sum('advance_price');
                $done_upsale = $done->where('is_upsale', StatusCode::ACTIVE);
                $item->done_upsale = $done_upsale->sum('total') + $done_upsale->sum('advance_price');

                $huy = $huy->where('status', OrderConstant::STATUS_HUY_DON);
                $hoan = $hoan->whereIn('status', Order::$statusHoan);

                $item->dang_giao_hang = $dang_giao_hang->sum('total') + $dang_giao_hang->sum('advance_price');
                $item->cho_xac_nhan = $cho_xac_nhan->sum('total') + $cho_xac_nhan->sum('advance_price');
                $item->huy = $huy->count();
                $item->hoan = $hoan->count();

            //Doanh thu gối đầu
                $done_goidau = $done_goidau->where('goi_dau', StatusCode::ACTIVE);
                $item->done_goidau = $done_goidau->sum('total') + $done_goidau->sum('advance_price');
                $hoan_goidau = $hoan->where('goi_dau', StatusCode::ACTIVE);
                $item->hoan_goidau = $hoan_goidau->sum('total') + $hoan_goidau->sum('advance_price');

                return $item;
            })->sortByDesc('doanh_thu');
        if ($request->ajax()) {
            return view('backend.statistical.sale.ajax', compact('user'));
        }

        return view('backend.statistical.sale.index', compact('user'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
