<?php

namespace App\Http\Controllers\Backend\Statistical;

use App\Constants\DepartmentConstant;
use App\Constants\OrderConstant;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\Order;
use App\Models\Product;
use App\Models\Team;
use App\Models\TeamMember;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\View\View;

class MarketingController extends Controller
{

    public function __construct()
    {
        $products = Product::pluck('name', 'id')->toArray();
        $team = Team::where('department_id', DepartmentConstant::MARKETING)->with('user')->get()->map(function ($item) {
            $item->displayName = $item->name . ' - ' . @$item->user->name . ' (' . @$item->user->username . ')';
            return $item->only('id', 'displayName');
        })->pluck('displayName', 'id')->toArray();

        view()->share([
            'products' => $products,
            'team' => $team,
        ]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }
        $input = $request->all();
        if (!empty($input['team'])) {
            $input['mkt_arr'] = TeamMember::select('user_id')->where('team_id', $input['team'])->pluck('user_id')->toArray();
        }
        $input['gioi_thieu'] = StatusCode::INACTIVE;
        $orders = Order::revenueWithStatus($input, 'mkt_id')->where('mkt_id', '<>', 0);

        $all = clone $orders;
        $all = Order::searchStatus(Order::$statusAll, $all)->get();

        $sum['sum'] = $all->sum('sum') + $all->sum('sum_advance_price') + $all->sum('sum_ship_price');
        $sum['count'] = $all->sum('count');
        $delivery = clone $orders;
        $delivery = Order::searchStatus(Order::$statusDelivery, $delivery)->get();
        $sum['delivery_sum'] = $delivery->sum('sum') + $delivery->sum('sum_advance_price') + $delivery->sum('sum_ship_price');
        $sum['delivery_count'] = $delivery->sum('count');
        $delivery = $delivery->toArray();

        $cancel = clone $orders;
        $cancel = Order::searchStatus([OrderConstant::STATUS_HUY_DON], $cancel)->get();
        $sum['cancel_sum'] = $cancel->sum('sum') + $cancel->sum('sum_advance_price') + $cancel->sum('sum_ship_price');
        $sum['cancel_count'] = $cancel->sum('count');
        $cancel = $cancel->toArray();

        $payment = clone $orders;
        $payment = Order::searchStatus([OrderConstant::STATUS_DA_THANH_TOAN], $payment)->get();
        $sum['thanh_toan_sum'] = $payment->sum('sum') + $payment->sum('sum_advance_price') + $payment->sum('sum_ship_price');
        $sum['thanh_toan_count'] = $payment->sum('count');
        $payment = $payment->toArray();

        $daHoan = clone $orders;
        $daHoan = Order::searchStatus([OrderConstant::STATUS_HOAN_HUY], $daHoan)->get();
        $sum['hoan_huy_sum'] = $daHoan->sum('sum') + $daHoan->sum('sum_ship_price');
        $sum['hoan_huy_count'] = $daHoan->sum('count');
        $daHoan = $daHoan->toArray();

        $hoan = clone $orders;
        $hoan = Order::searchStatus(Order::$statusHoan, $hoan)->get();
        $sum['hoan_sum'] = $hoan->sum('sum') + $hoan->sum('sum_ship_price');
        $sum['hoan_count'] = $hoan->sum('count');
        $hoan = $hoan->toArray();

        $done = clone $orders;
        $done = Order::searchStatus([OrderConstant::STATUS_DA_GIAO_HANG], $done)->get();
        $sum['giao_hang_sum'] = $done->sum('sum') + $done->sum('sum_advance_price')+ $done->sum('sum_ship_price');
        $sum['giao_hang_count'] = $done->sum('count');
        $done = $done->toArray();

        if ($request->ajax()) {
            return view('backend.statistical.marketing.ajax', compact('sum', 'all', 'cancel', 'payment', 'hoan', 'done', 'delivery', 'daHoan'));
        }

        return view('backend.statistical.marketing.index', compact('sum', 'all', 'cancel', 'payment', 'hoan', 'done', 'delivery', 'daHoan'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
