<?php

namespace App\Http\Controllers\Backend\Sale;

use App\Constants\CustomerConstant;
use App\Constants\OrderConstant;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\Customer;
use App\Models\CustomerStatus;
use App\Models\Depot;
use App\Models\HistoryChangeStatus;
use App\Models\JobSchedule;
use App\Models\Order;
use App\Models\OrderStatus;
use App\Models\Product;
use App\Models\Team;
use App\Models\TeamMember;
use App\Services\Marketing\SourceService;
use Illuminate\Http\Request;
use App\Constants\DepartmentConstant;
use App\User;
use Carbon\Carbon;
use App\Services\LocationService;
use App\Services\CustomerService;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;

class SaleController extends Controller
{

    private $location;
    private $customer;
    private $source;

    /**
     * SaleController constructor.
     *
     * @param LocationService $location
     * @param CustomerService $customer
     * @param SourceService $source
     */
    public function __construct(LocationService $location, CustomerService $customer, SourceService $source)
    {

        $this->location = $location;
        $this->customer = $customer;
        $this->source = $source;

        $sale = User::where('department_id', DepartmentConstant::SALE)->pluck('name', 'id')->toArray();
        $products = Product::select('id', 'name', 'price')->orderByDesc('id')->get();
        $product_pluck = $products->pluck('name', 'id')->toArray();
        $location_default = $this->location->searchAllLocation();
        $depot = Depot::get();
        $customer_status = CustomerStatus::orderBy('position')->get();
        view()->share([
            'sale' => $sale,
            'products' => $product_pluck,
            'products_full' => $products,
            'location_default' => $location_default,
            'depot' => $depot,
            'customer_status' => $customer_status,
        ]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = Auth::user();
        if ($user->department_id == DepartmentConstant::CSKH) {
            $request->merge(['is_cskh' => true]);
            $sale = User::whereIn('department_id', [DepartmentConstant::CSKH, DepartmentConstant::SALE])->get();

        } else {
            $sale = User::where('department_id', DepartmentConstant::SALE)->get();
        }

        if (!in_array($user->department_id, [DepartmentConstant::CEO, DepartmentConstant::ADMIN])) {

            if (($user->department_id == DepartmentConstant::SALE && $user->is_leader != DepartmentConstant::IS_LEADER)
                || ($user->department_id == DepartmentConstant::CSKH && $user->is_leader != DepartmentConstant::IS_LEADER)) {

                if ((isset($user->teams) && count($user->teams)) ||($user->department_id == DepartmentConstant::CSKH)) {
                    $cskh_team = Team::where('cskh_id',Auth::user()->id)->first();
                    if ($cskh_team){
                        $input['teamMember'] =$cskh_team->id;
                    }else{
                        $input['teamMember'] = $user->teams[0]->id;
                    }
                    $member = TeamMember::search($input)->pluck('user_id')->toArray();
                    $request->merge(['arr_sale_id' => $member]);
                    $search_user['team_member'] = $member;
                    $search_user['user_active'] = DepartmentConstant::USER_ACTIVE;

                    $sale = User::search($search_user)->get();
                } else {
                    $request->merge(['sale_id' => $user->id]);
                    $sale = [];
                }
            }
        }
        $teams = [];
        $team_mkt = Team::where('department_id', DepartmentConstant::MARKETING)->get();

        if ($user->department_id == DepartmentConstant::CEO || $user->department_id == DepartmentConstant::ADMIN || $user->is_leader == DepartmentConstant::IS_LEADER) {
            $teams = Team::where('department_id', DepartmentConstant::SALE)->get();
        }

        if ($request->team_id) {
            $member = TeamMember::where('team_id', $request->team_id)->pluck('user_id')->toArray();
            $request->except('arr_sale_id');
            $request->merge(['arr_sale_id' => $member]);
        }

        if ($request->team_mkt_id) {
            $member1 = TeamMember::where('team_id', $request->team_mkt_id)->pluck('user_id')->toArray();
            $request->merge(['arr_mkt_id' => $member1]);
        }

        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }


        $request->merge(['expired_time_boolean' => $request->expired_time_boolean != null ? [$request->expired_time_boolean] : null]);
        $search = $request->all();
        $search2 = $request->except('status', 'customer_status');

        $search['customer_not_position'] = true;
        $paginate = $request->customPage ?: StatusCode::PAGINATE_20;

        $regex_phone = '/^[0-9]{10,11}\z/';

        if ($request->search) {
            if (preg_match($regex_phone, $request->search)) {
                $search['search'] = $request->search;
            } else {
                $search['search'] = null;
                $search['code'] = $request->search;
            }
            unset($search['start_date'], $search['end_date'], $search['status_operation']);
        }

        if ($request->customer_id) {
            $search['customer_id'] = $request->customer_id;
            unset($search['start_date'], $search['end_date']);
        }

        $docs = $this->customer->index($search)->paginate($paginate);

        $customer_group = $this->customer->index($search2)->select('id', 'status',
            DB::raw('count(*) as total'))->groupBy('status')->get()->pluck('total', 'status');
        $search2['expired_time_boolean'] = [CustomerConstant::QUA_HAN];

        $customer_expired = $this->customer->index($search2)->select('id', 'status',
            DB::raw('count(*) as total'))->groupBy('status')->get()->pluck('total', 'status');
        $order_status = OrderStatus::all();
        $customer_status_active = $request->customer_status ?: 0;
        if ($request->ajax()) {
            return view('backend.sale.operation.ajax',
                compact('docs', 'customer_group', 'customer_expired', 'paginate', 'customer_status_active'));
        }

        return view('backend.sale.operation.index',
            compact('docs', 'order_status', 'customer_group', 'sale', 'customer_expired', 'customer_status_active', 'teams', 'team_mkt'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

    }

    /**
     * Hiển thị báo cáo sale
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function report(Request $request)
    {
        $input = [];
        if (empty($request->start_date) && empty($request->end_date)) {
            $input = [
                'start_date' => Carbon::now()->subDays(7)->format('d/m/Y H:i'),
                'end_date' => Carbon::now()->format('d/m/Y H:i'),
            ];
        }
        $params['department_id'] = DepartmentConstant::SALE;
        $docs = User::search($params)->get()->map(function ($item) use ($input) {
            $input['sale_id'] = $item->id;
            $input['not_in_status'] = [
                OrderConstant::STATUS_DON_LUU,
                OrderConstant::STATUS_HOAN_HUY,
                OrderConstant::STATUS_HUY_DON,
            ];
            $customers = Customer::search($input, 'date_sale_nhan_data')->select('id', 'duplicate');
            $orders = Order::search($input)->select('total', 'advance_price');
            $item->all_customers = $customers->count();
            $item->avaiable_customer = $customers->where('duplicate', 1)->count();
            $item->count_order = $orders->count();
            $item->total = $orders->sum('total') + $orders->sum('advance_price');
            return $item->only('name', 'phone', 'status', 'username', 'all_customers', 'avaiable_customer', 'total',
                'count_order');
        });
        if ($request->ajax()) {
            return view('backend.sale.report.ajax', compact('docs'));
        }
        return view('backend.sale.report.index', compact('docs'));
    }

    /**
     * Tối ưu sale
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function optimal()
    {
        return view('backend.sale.optimal.index');
    }

    public function getOrderDetail(Request $request)
    {
        $order = Order::where('customer_id', $request->id)->with('orderDetails',
            'orderDetails.product')->orderByDesc('id')->get();
        $order = $order->map(function ($m) {
            $m->productDepot = $m->productDepot();
            $m->location = $m->get_district_ward();
            return $m;
        });
        if (!count($order)) {
            $search['searchId'] = $request->source_id;
            $product_source = $this->source->index($search);
        }
        return response()->json([
            'order' => $order,
            'source' => isset($product_source) ? $product_source : [],
        ]);
    }


    /**
     * Thống kê tỉ lệ chốt đơn
     *
     * @param Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function statisticalCloseOrder(Request $request)
    {
        $search = [];
        $search['start_date'] = $request->start_date;
        $search['end_date'] = $request->end_date;
        if (empty($request->start_date) && empty($request->end_date)) {
            $search = [
                'start_date' => Carbon::now()->subDays(7)->format('d/m/Y H:i'),
                'end_date' => Carbon::now()->format('d/m/Y H:i'),
            ];
        }
        $searchSale['department_id'] = DepartmentConstant::SALE;
        $user = Auth::user();
        $arr_sale_id = null;

        if ($user->department_id == DepartmentConstant::ADMIN || $user->department_id == DepartmentConstant::CEO) {
            $teams = Team::where('department_id', DepartmentConstant::SALE)->get();
            $team_id = $request->leader_id;
            if ($team_id) {
                $team = Team::where('id', $team_id)->with('teamMembers')->first();
                $arr_sale_id = self::getSaleId($team->teamMembers);
            } else {
                $arr_sale_id = [];
            }
        } else {
            if ($user->is_leader == 1) { //trưởng phòng
                $team_id = $request->leader_id;
                $user_department_id = User::where('department_id', $user->department_id)->pluck('id')->toArray();
                $teams = Team::whereIn('leader_id', $user_department_id)->with('user')->get();

                if ($team_id) {
                    $team = Team::where('id', $team_id)->with('teamMembers')->first();
                    $arr_sale_id = self::getSaleId($team->teamMembers);
                } else {
                    $arr_sale_id = [];
                }
            } else { //leader
                $teams = Team::where('leader_id', $user->id)->with('teamMembers', 'user')->first();
                if ($teams) {
                    $arr_sale_id = self::getSaleId($teams->teamMembers);
                } else {
                    $arr_sale_id = [];
                }
            }
        }

        if (count($arr_sale_id)) {

            $sales = User::whereIn('id', $arr_sale_id)->get()->map(function ($m) use ($search) {
                $dataStatus = [];
                $search['sale_id'] = $m->id;
                $all_order = Order::search($search)->count();
                $dataStatus['all_contact'] = Customer::search($search)->count();

                $tac_nghiep = HistoryChangeStatus::where('user_id', $m->id)->where('type', 0)->whereBetween('updated_at', [
                    Functions::yearMonthDayTime($search['start_date']),
                    Functions::yearMonthDayTime($search['end_date']),
                ])->get()->count();

                $done = Order::select('customer_id', \DB::raw('count(customer_id) as count_order'))
                    ->whereBetween('updated_at', [
                        Functions::yearMonthDayTime($search['start_date']),
                        Functions::yearMonthDayTime($search['end_date']),
                    ])
                    ->where('sale_id', $search['sale_id'])->whereNotIn('status', [
                        OrderConstant::CHUA_DOI_SOAT,
                        OrderConstant::STATUS_HUY_DON,
                    ])->groupBy('customer_id')->has('customer')
                    ->with('customer')->get();
                $dataStatus['all_order_done'] = count($done);
                if (count($done)) {
                    foreach ($done as $item) {
                        if (!empty($dataStatus[$item->customer->status]['order_done']) && $dataStatus[$item->customer->status]['order_done'] > 0) {
                            $dataStatus[$item->customer->status] = [
                                'all_order' => $all_order,
                                'order_done' => $dataStatus[$item->customer->status]['order_done'] + $item->count_order,
                            ];
                        } else {
                            $dataStatus[$item->customer->status] = [
                                'all_order' => $all_order,
                                'order_done' => $item->count_order,
                            ];
                        }
                    }
                }
                $m->statuses = $dataStatus;
                $m->tac_nghiep = $tac_nghiep;
                return $m;
            });
        } else {
            $sales = [];
        }


        if ($request->ajax()) {
            if ($request->has('operation')) {
                $customer_status = CustomerStatus::whereIn('id', $request->operation)->get();
            } else {
                $customer_status = CustomerStatus::all();
            }

            return view('backend.sale.statistical.ajax', compact('customer_status', 'sales', 'teams'));
        }
        $customer_status = CustomerStatus::all();
        return view('backend.sale.statistical.close_order', compact('customer_status', 'sales', 'teams'));
    }


    public function statisticalTeamSale(Request $request)
    {
        $input_new = [
            'start_date' => $request->start_date,
            'end_date' => $request->end_date,
        ];
        if (empty($request->start_date) && empty($request->end_date)) {
            $input_new = [
                'start_date' => Carbon::now()->subDays(7)->format('d/m/Y H:i'),
                'end_date' => Carbon::now()->format('d/m/Y H:i'),
            ];
        }
        $search = [
            'start_date' => $input_new['start_date'],
            'end_date' => $input_new['end_date'],
        ];
        $user = Auth::user();
        $arr_sale_id = null;

        if ($user->department_id == DepartmentConstant::ADMIN || $user->department_id == DepartmentConstant::CEO) {
            $teams = Team::where('department_id', DepartmentConstant::SALE)->get();
            $team_id = $request->leader_id;
            if ($team_id) {
                $team = Team::where('id', $team_id)->with('teamMembers')->first();
                $arr_sale_id = self::getSaleId($team->teamMembers);
            } else {
                $arr_sale_id = [];
            }
        } else {
            if ($user->is_leader == 1) { //trưởng phòng
                $team_id = $request->leader_id;
                $user_department_id = User::where('department_id', $user->department_id)->pluck('id')->toArray();
                $teams = Team::whereIn('leader_id', $user_department_id)->with('user')->get();

                if ($team_id) {
                    $team = Team::where('id', $team_id)->with('teamMembers')->first();
                    $arr_sale_id = self::getSaleId($team->teamMembers);
                } else {
                    $arr_sale_id = [];
                }
            } else { //leader
                $teams = Team::where('leader_id', $user->id)->with('teamMembers', 'user')->first();
                if ($teams) {
                    $arr_sale_id = self::getSaleId($teams->teamMembers);
                } else {
                    $arr_sale_id = [];
                }
            }
        }
        $filter = isset($request->type_filter) ? (int)$request->type_filter : 0;

        if (count($arr_sale_id)) {

            if ($filter == StatusCode::ACTIVE) {
                $search['not_in_status'] = [
                    OrderConstant::STATUS_CHOT_DON,
                    OrderConstant::STATUS_DON_LUU,
                    OrderConstant::STATUS_HUY_DON,
                    OrderConstant::STATUS_HOAN_HUY,
                    OrderConstant::STATUS_DANG_HOAN,
                ];
            } else {
                $search['not_in_status'] = [
                    OrderConstant::STATUS_DON_LUU,
                    OrderConstant::STATUS_HUY_DON,
                    OrderConstant::STATUS_HOAN_HUY,
                    OrderConstant::STATUS_DANG_HOAN,
                ];
            }

            $sales = User::select('id', 'name')->where('status',StatusCode::ACTIVE)->whereIn('id', $arr_sale_id)->get()->map(function ($m) use ($search, $input_new) {

                $search['sale_id'] = $m->id;
                $input_new['sale_id'] = $m->id;
                $input_new['gioi_thieu'] = 0;
                $input_new['customer_old'] = 0;
                $searchAll = [
                    'start_date' => $input_new['start_date'],
                    'end_date' => $input_new['end_date'],
                    'sale_id' => $m->id,
                    'not_in_status' => $search['not_in_status'],
                ];
                $orginal_orders = Order::search($search)->select('total', 'advance_price');
//                Khách hàng mới
                $customer_created = Customer::search($input_new, 'created_at')
                    ->where('status', '<>', CustomerConstant::CUSTOMER_BO_QUA)->select('id');

                $input_new['type'] = 0;
                $m->history = HistoryChangeStatus::search($input_new)->select('id')->count();
                $m->contact = $customer_created->count();

//                Đơn hàng mới
                $search['customer_id'] = $customer_created->pluck('id')->toArray();
                $ordersNew = clone $orginal_orders;
                $ordersNew = $ordersNew->whereIn('customer_id', $search['customer_id'])->where('is_upsale', StatusCode::INACTIVE);
                $m->totalOnTime = count($search['customer_id']) ? $ordersNew->sum('total') + $ordersNew->sum('advance_price') : 0;
                $m->orders_new = count($search['customer_id']) ? $ordersNew->count() : 0;

//                Đơn cũ
                $orders = clone $orginal_orders;
                $orders = $orders->where('is_upsale', StatusCode::ACTIVE)->whereHas('customer', function ($qw) {
                    $qw->where('gioi_thieu', StatusCode::INACTIVE);
                });

                $m->total = $orders->sum('total') + $orders->sum('advance_price');

//                Đơn giới thiệu
                $orders_gioithieu = clone $orginal_orders;
                $orders_gioithieu = $orders_gioithieu->whereHas('customer', function ($qw) {
                    $qw->where('gioi_thieu', StatusCode::ACTIVE);
                });

                $m->total_gioithieu = $orders_gioithieu->sum('total') + $orders_gioithieu->sum('advance_price');

                //Tất cả đơn hàng
                $ordersAll = Order::search($searchAll)->select('total', 'advance_price');
                $m->totalAll = $ordersAll->sum('total') + $ordersAll->sum('advance_price') ?: 0;
                $m->countTotal = $ordersAll->count();
//                $m->orders_New_All = count($search['customer_id']) ? $ordersAll->count() - $m->orders_gioithieu - $m->orders : 0;
                return $m;
            });
        } else {
            $sales = [];
        }
        if ($request->ajax()) {
            return view('backend.sale.statistical.ajax_team', compact('sales', 'teams', 'filter'));
        }
        return view('backend.sale.statistical.team', compact('sales', 'teams', 'filter'));
    }

    public function getSaleId($teamMember)
    {
        $arr_id = [];
        if (count($teamMember)) {
            foreach ($teamMember as $item) {
                $arr_id[] = $item->user_id;
            }
        }
        return $arr_id;
    }

    /**
     * flat_map mảng chapter
     *
     * @param array $array
     *
     * @return array
     */
    public static function flatten(array $array)
    {
        $arr = [];
        foreach ($array as $items) {
            if (count($items)) {
                foreach ($items as $item) {
                    array_push($arr, $item);
                }
            }
        }
        return $arr;
    }

    /**
     * phân bổ data
     *
     * @param Request $request
     *
     * @return int
     */
    public function phanBoData(Request $request)
    {
        $current_user = Auth::user();
        $user_new = User::find($request->user_id);
        $data = $request->except('khach_hang_id');
        $date = date('Y-m-d H:i:s');
        $khach_hang_id = $request->khach_hang_id;
        if (!empty($request->status)) {
            foreach ($khach_hang_id as $item) {
                if (is_numeric($item)) {
                    $customer = Customer::find($item);
                    $current_sale = User::find($customer->user_id);
                    $data_insert['status_old'] = $customer->status;
                    $data_insert['status_new'] = $request->status;
                    $data_insert['note'] = (isset($current_sale) ? $current_sale->username : 'tha_noi') . ' -> ' . $user_new->username;
                    $data_insert['customer_id'] = $item;
                    $data_insert['user_id'] = $current_user->id;
                    $data_insert['type'] = 1;
                    HistoryChangeStatus::create($data_insert);
                }
            }

            $customer_stauts = CustomerStatus::find($request->status);

            if (isset($customer_stauts) && $customer_stauts && empty($customer_stauts->time_move)) {
                $data['time_move_sale'] = null;
            } else {
                $data['expired_time'] = date('Y-m-d H:i:s',
                    strtotime('+' . $customer_stauts->expired_time . 'minute', strtotime($date)));
                $data['time_move_sale'] = date('Y-m-d H:i:s',
                    strtotime('+' . $customer_stauts->time_move . 'minute', strtotime($data['expired_time'])));
            }

            $data['expired_time_boolean'] = CustomerConstant::QUA_HAN;
            $data['date_sale_nhan_data'] = date('Y-m-d H:i:s');
            Customer::whereIn('id', $khach_hang_id)->update($data);


        } else {
            foreach ($khach_hang_id as $item) {
                if (is_numeric($item)) {
                    $customer = Customer::find($item);
                    $current_sale = User::find($customer->user_id);

                    $data_insert['status_old'] = $customer->status;
                    $data_insert['status_new'] = $customer->status;
                    $data_insert['note'] = (isset($current_sale) ? $current_sale->username : 'tha_noi') . ' -> ' . $user_new->username;
                    $data_insert['customer_id'] = $item;
                    $data_insert['user_id'] = $current_user->id;
                    $data_insert['type'] = 1;
                    HistoryChangeStatus::create($data_insert);

                    $status = CustomerStatus::find($customer->status);
                    if (!empty($status) && !empty($status->time_move)) {
                        $expired_time = $status->expired_time;
                        $time_move = $status->time_move;
                        $data['expired_time'] = date('Y-m-d H:i:s',
                            strtotime('+' . $expired_time . 'minute', strtotime($date)));
                        $data['time_move_sale'] = date('Y-m-d H:i:s',
                            strtotime('+' . $time_move . 'minute', strtotime($data['expired_time'])));
                    } else {
                        $data['time_move_sale'] = null;
                    }

                    $data['expired_time_boolean'] = CustomerConstant::QUA_HAN;

                    $data['status'] = $customer->status;
                    $data['date_sale_nhan_data'] = date('Y-m-d H:i:s');
                    $customer->update($data);
                }
            }
        }

        return 1;
    }

    /**
     * tạo lịch hẹn
     *
     * @param Request $request
     *
     * @return int
     */
    public function saveJobSchedule(Request $request)
    {
        $data['user_id'] = Auth::user()->id;
        $data['time_operation'] = Carbon::createFromFormat('d/m/Y H:i', $request->time)->format('Y-m-d H:i');
        $data['customer_id'] = $request->customer_id;

        $job = JobSchedule::where('customer_id', $data['customer_id'])->where('user_id', Auth::user()->id)->first();

        if (!empty($job)) {
            $job->update(['time_operation' => $data['time_operation']]);
        } else {
            JobSchedule::create($data);
        }
        return 1;
    }


    public function getJobSchedule(Request $request)
    {
        $user = Auth::user();
        $team = Team::where('leader_id', $user->id)->first();
        if ($team) {
            $team_member = TeamMember::where('team_id', $team->id)->pluck('user_id')->toArray();
            $jobs = JobSchedule::whereIn('user_id', $team_member)->where('status', '>', 0)->with('customer', 'user')
                ->orderBy('status', 'asc')->orderBy('time_operation', 'asc')->get();
        } else {
            $jobs = JobSchedule::where('user_id', $user->id)->where('status', '>', 0)->with('customer', 'user')
                ->orderBy('status', 'asc')->orderBy('time_operation', 'asc')->get();
        }
        return response()->json([
            'job_schedules' => $jobs,
        ]);
    }

    public function totalJobScheduleNew(Request $request)
    {
        $user = Auth::user();
        $team = Team::where('leader_id', $user->id)->first();
        if ($team) {
            $team_member = TeamMember::where('team_id', $team->id)->pluck('user_id')->toArray();
            $total = JobSchedule::whereIn('user_id', $team_member)->where('status', 1)->get()->count();
            return $total;
        }
        $total = JobSchedule::where('user_id', $user->id)->where('status', 1)->get()->count();
        return $total;
    }

    public function updateJobSchedule(Request $request)
    {
        $user = Auth::user();
        $job = JobSchedule::find($request->id);
        if ($user->id == $job->user_id) {
            $job->update(['status' => $request->status]);
        }
        return 1;
    }

    public function statisticalListTeamSale(Request $request)
    {
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }
        $search = $request->all();
        $type_search = isset($request->type_search) && $request->type_search ? $request->type_search : 0;
        $search['not_in_status'] = [
            OrderConstant::STATUS_DON_LUU,
            OrderConstant::STATUS_HUY_DON,
            OrderConstant::STATUS_HOAN_HUY,
            OrderConstant::STATUS_DANG_HOAN,
        ];
        if ($request->type_search) {
            if ($type_search == 1) {
                $search['not_in_status'] = [
                    OrderConstant::STATUS_CHOT_DON,
                    OrderConstant::STATUS_DON_LUU,
                    OrderConstant::STATUS_HUY_DON,
                    OrderConstant::STATUS_HOAN_HUY,
                    OrderConstant::STATUS_DANG_HOAN,
                ];
            }
        }
        $orders = Order::search($search)->select('total', 'advance_price');

        //Khách hàng mới
        $customers = Customer::search($search, 'created_at')->select('id')
            ->where('status', '<>', CustomerConstant::CUSTOMER_BO_QUA)->where('gioi_thieu', StatusCode::INACTIVE)->select('id');

        $teams = Team::where('department_id', DepartmentConstant::SALE)->with('teamMembers')->get()->map(function ($team) use ($orders, $customers) {
            $team_member = $team->teamMembers->pluck('user_id')->toArray();
            $orders1 = clone $orders;
            $orders1 = $orders1->whereIn('sale_id', $team_member);//order tổng

            $orders_new = clone  $orders1;
            $ordersNew = $orders_new->where('is_upsale', StatusCode::INACTIVE)
                ->whereHas('customer', function ($qr) {
                    $qr->where('gioi_thieu', StatusCode::INACTIVE);
                });//đơn mua lần 1
            $team['don_mua_l1'] = $ordersNew->count();

            $totalNew = $ordersNew->sum('total') + $ordersNew->sum('advance_price');//DS Khách mua lần 1

            $ordersNew = $orders_new->whereIn('customer_id', $customers->pluck('id')->toArray())->count();


            $data_ve_ht = clone $customers;
            $data_ve_ht = $data_ve_ht->whereIn('user_id', $team_member);

            $team['contact'] = $data_ve_ht->count(); //SĐT mới

            $team['order_new'] = $ordersNew;//Số đơn mới

            $team['total_new'] = $totalNew;// đơn mua lần 1


            $team['order_total_count'] = $orders1->count();
            $team['order_total'] = $orders1->sum('total') + $orders1->sum('advance_price'); // tông mới + cũ + giới thiệu

            return $team;
        });

        if ($request->ajax()) {
            return view('backend.sale.leader.team_sale_ajax', compact('teams', 'type_search'));
        }

        return view('backend.sale.leader.team_sale', compact('teams', 'type_search'));
    }

    public function searchPhoneCustomer(Request $request)
    {
        $phone = $request->phone;
        $customer = Customer::where('phone', $phone)->orderByDesc('id')->with('source')->first();
        return $customer;
    }
}
