<?php

namespace App\Http\Controllers\Backend\Sale;

use App\Helpers\Functions;
use App\Models\Order;
use App\Constants\OrderConstant;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;

class RankingController extends Controller
{
    /**
     * Bảng xếp hạng sale
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function sale(Request $request)
    {
//        $user = User::whereNotNull('pc_name')->where('pc_name','<>','0')->update(['pc_name'=>null]);
        $params = $request->all();
        if (empty($request->start_date) && empty($request->end_date)) {
            $params = [
                'start_date' => Carbon::now()->subDays(7)->format('d/m/Y H:i'),
                'end_date' => Carbon::now()->format('d/m/Y H:i'),
            ];
        }
        if ($request->type) {
            $params['not_in_status'] = [0, OrderConstant::STATUS_HUY_DON, OrderConstant::STATUS_HOAN_HUY,OrderConstant::STATUS_DANG_HOAN];
        } else {
            $params['not_in_status'] = [0, OrderConstant::STATUS_CHOT_DON, OrderConstant::STATUS_HUY_DON, OrderConstant::STATUS_HOAN_HUY, OrderConstant::STATUS_DANG_HOAN];
        }
        $data = Order::searchGroupBy($params, 'all_total')->with('sale')->get();
        $me = Auth::user()->id ?: 0;
        $response = [];
        if (count($data)) {
            foreach ($data as $item) {
                $response[] = [
                    'sale_id' => $item->sale_id,
                    'all_total' => $item->all_total + $item->all_advance_price,
                    'name' => @$item->sale->name,
                    'avatar' => @$item->sale->avatar,
                ];
            }
            usort($response, function ($a, $b) {
                return $b['all_total'] <=> $a['all_total'];
            });
            $my_key = array_keys(array_column((array)$response, 'sale_id'), $me);
        } else {
            $my_key = [];
        }
        if ($request->ajax()) {
            return view('backend.sale.ranking.ajax', compact('response', 'my_key'));
        }
        return view('backend.sale.ranking.index', compact('response', 'my_key'));
    }
}
