<?php

namespace App\Http\Controllers\Backend\Sale;

use App\Constants\DepartmentConstant;
use App\Constants\HistoryConstant;
use App\Constants\Setting;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\Customer;
use App\Models\CustomerStatus;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\OrderStatus;
use App\Models\Product;
use App\Models\ProductDepot;
use App\Models\Source;
use App\Models\Team;
use App\Models\TeamMember;
use App\Services\CustomerService;
use App\User;
use Excel;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CustomerController extends Controller
{
    private $customer;

    public function __construct(CustomerService $customer)
    {
        $this->customer = $customer;
    }

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $user = Auth::user();
        if ($user->department_id == DepartmentConstant::SALE && $user->is_leader != DepartmentConstant::IS_LEADER) {
            $sales = User::where('department_id', DepartmentConstant::SALE)->get();
        } else {
            $sales = User::whereIn('department_id', [DepartmentConstant::CSKH, DepartmentConstant::SALE])->get();
        }
        $is_teamlead = count(Auth::user()->teams) > 0 ? true : false;
        if ($user->department_id == DepartmentConstant::CSKH){
            $request->merge(['is_cskh' => true]);
        }


        if ($user->department_id == DepartmentConstant::SALE || ($user->department_id == DepartmentConstant::CSKH && !$is_teamlead)) {

            if ($is_teamlead || ($user->department_id == DepartmentConstant::CSKH) ) {
                $cskh_team = Team::where('cskh_id',Auth::user()->id)->first();
                if ($cskh_team){
                    $input['teamMember'] =$cskh_team->id;
                }else{
                    $input['teamMember'] = $user->teams[0]->id;
                }
                $member = TeamMember::search($input)->pluck('user_id')->toArray();
                $request->merge(['arr_sale_id' => $member]);
                $sales = $user->department_id == DepartmentConstant::CSKH ? $sales : User::whereIn('id', $member)->get();
            } else {
                if ($user->is_leader != DepartmentConstant::IS_LEADER) {
                    $request->merge(['sale_id' => $user->id]);
                    $sales = [];
                }
            }
        } else {
            if ($user->department_id == DepartmentConstant::MARKETING && $user->is_leader != DepartmentConstant::IS_LEADER && !$is_teamlead) {
                $request->merge(['marketing' => $user->id]);

            } else {
                if ($user->department_id == DepartmentConstant::MARKETING && $user->is_leader == DepartmentConstant::IS_LEADER) {

                    $input['department_id'] = DepartmentConstant::MARKETING;
                    $member = TeamMember::search($input)->pluck('user_id')->toArray();
                    $request->merge(['arr_mkt_id' => $member]);

                } else {
                    if ($user->department_id == DepartmentConstant::MARKETING && $user->is_leader != DepartmentConstant::IS_LEADER && $is_teamlead) {

                        $team = Team::where('leader_id', $user->id)->first();
                        $member = TeamMember::where('team_id', $team->id)->pluck('user_id')->toArray();
                        $request->merge(['arr_mkt_id' => $member]);
                    }
                }
            }
        }

        if ($request->expired_time_boolean != null) {
            $request->merge(['expired_time_boolean' => [$request->expired_time_boolean]]);
        } else {
            $request->except('expired_time_boolean');
        }

        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }

        $marketing = User::where('department_id', DepartmentConstant::MARKETING)->get();
        $products = ProductDepot::groupBy('product_id')->orderByDesc('id')->get();
        $customer_status = CustomerStatus::orderByDesc('position')->get();
        $customer_action = OrderStatus::all();
        $sources = Source::select('id', 'name', 'user_id')->where('accept', 1)->get();

        $paginate = $request->customPage ?: StatusCode::PAGINATE_20;

        $search = $request->all();
        if ($request->search) {
            $search = $request->except('marketing', 'start_date', 'end_date');
        }
        $data = $this->customer->index($search)->paginate($paginate);
        if ($request->ajax()) {
            return view('backend.sale.customer.ajax',
                compact('data', 'sales', 'marketing', 'products', 'customer_action', 'customer_status', 'paginate'));
        }

        return view('backend.sale.customer.index',
            compact('data', 'sales', 'marketing', 'products', 'customer_action', 'customer_status', 'sources'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    /**
     * Thay đổi source
     *
     * @param Request $request
     *
     * @return int
     */
    public function phanBoSource(Request $request)
    {
        if ($request->source_id) {
            $source = Source::find($request->source_id);
            Customer::whereIn('id', $request->arr_id_kh)->update([
                'source_id' => $request->source_id,
                'mkt_id'    => $source->user_id,
            ]);
        }
        return 1;
    }

    public function depotNumber(Request $request)
    {
        $search['searchDepartment'] = DepartmentConstant::SALE;
        $customers = Customer::whereNull('user_id')->when(isset($request->name), function ($q) use ($request) {
            $q->where('name', 'like', '%' . $request->name . '%');
        })->when(isset($request->phone), function ($q) use ($request) {
            $q->where('phone', $request->phone);
        })->orderByDesc('id')->paginate(StatusCode::PAGINATE_20);
        $sales = User::search($search)->get();
        if ($request->ajax()) {
            return view('backend.sale.customer.ajax_depot_number', compact('customers', 'sales'));
        }
        return view('backend.sale.customer.depot_number_float', compact('customers', 'sales'));
    }

    public function importExcelCustomers(Request $request)
    {
        if ($request->hasFile('file') && ($request->file('file')->getClientMimeType() == Setting::ExcelType || $request->file('file')->getClientMimeType() == Setting::ExcelTypeV2)) {

            Excel::load($request->file('file')->getRealPath(), function ($render) {
                $result = $render->toArray();;

                foreach ($result as $k => $row) {
                    if (empty($row['ngay_data_ve'])) {
                        break;
                    }
                    $date = Carbon::createFromFormat('d/m/Y H:i', trim($row['ngay_data_ve']))->format('Y-m-d H:i');
                    if (empty($row['sale_ngay_tac_nghiep'])) {
                        $updated = $date;
                    } else {
                        $updated = Carbon::createFromFormat('d/m/Y H:i',
                            trim($row['sale_ngay_tac_nghiep']))->format('Y-m-d H:i');
                    }
                    $source = Source::where('name', $row['nguon_data'])->first();
                    $input['name'] = $row['mkt_ten'];
                    $mkt = User::search($input)->first();

                    $input['name'] = $row['sale_ten'];
                    $sale = User::search($input)->first();
//                    $row['sale_tac_nghiep'] = $row['sale_tac_nghiep'] == "Hiệu quả tốt" ? "Khách đã mua hàng" : "Đại sứ thương hiệu";
                    $status = CustomerStatus::where('name', $row['sale_tac_nghiep'])->first();

                    $duplicate = Customer::where('phone', $row['kh_so_dt'])->first();

                    if (!empty($duplicate) && $duplicate->customer_old == 0) {
                        $orders = Order::where('customer_id', $duplicate->id)->count();
                        if ($duplicate->customer_old == 0 && $orders < 1) {
                            $data = [
                                'source_id'           => !empty($source) ? $source->id : 1,
                                'name'                => $row['kh_ho_ten'],
                                'phone'               => $row['kh_so_dt'],
                                'message'             => $row['kh_tin_nhan'],
                                'duplicate'           => !empty($duplicate) ? 1 : 0,
                                'customer_old'        => 1,
                                'page_id'             => 0,
                                'mkt_id'              => !empty($mkt) ? $mkt->id : 0,
                                'user_id'             => !empty($sale) ? $sale->id : 0,
                                'sale_note'           => $row['sale_ghi_chu'],
                                'status'              => !empty($status) ? $status->id : 0,
                                'date_sale_nhan_data' => $date . ':00',
                                'created_at'          => $date . ':00',
                                'updated_at'          => $updated . ':00',
                            ];
                            Customer::create($data);
                        }
                    } elseif (empty($duplicate)) {
                        $data = [
                            'source_id'           => !empty($source) ? $source->id : 1,
                            'name'                => $row['kh_ho_ten'],
                            'phone'               => $row['kh_so_dt'],
                            'message'             => $row['kh_tin_nhan'],
                            'duplicate'           => !empty($duplicate) ? 1 : 0,
                            'customer_old'        => 1,
                            'page_id'             => 0,
                            'mkt_id'              => !empty($mkt) ? $mkt->id : 0,
                            'user_id'             => !empty($sale) ? $sale->id : 0,
                            'sale_note'           => $row['sale_ghi_chu'],
                            'status'              => !empty($status) ? $status->id : 0,
                            'date_sale_nhan_data' => $date . ':00',
                            'created_at'          => $date . ':00',
                            'updated_at'          => $updated . ':00',
                        ];
                        Customer::create($data);

//                        if (!empty($row['ma_don'])) {
//                            $row['dh_ma_sp'] = explode(' ; ', trim($row['dh_ma_sp']));
//                            $row['dh_thanh_tien'] = explode(';', trim($row['dh_thanh_tien']));
//                            $row['sp_so_luong'] = explode(';', trim($row['sp_so_luong']));
//                            $order_status = OrderStatus::where('name', $row['gh_trang_thai'])->first();
//                            $value = [
//                                'code' => $row['ma_don'],
//                                'customer_id' => @$customer->id,
//                                'sale_id' => !empty($sale) ? $sale->id : 0,
//                                'mkt_id' => !empty($mkt) ? $mkt->id : 0,
//                                'total' => $row['dh_tong_tien'],
//                                'discount' => $row['dh_chiet_khau'],
//                                'advance_price' => $row['dh_dat_coc'],
//                                'status' => !empty($order_status) ? $order_status->id : 0,
//                            ];
//                            $order = Order::create($value);
//                            foreach ($row['dh_ma_sp'] as $key => $item) {
//                                $product = Product::where('code', $item)->first();
//                                if(!empty($product)){
//                                    OrderDetail::create([
//                                        'order_id' => $order->id,
//                                        'product_id' => $product->id,
//                                        'price' => @$row['dh_thanh_tien'][$key],
//                                        'quantity' => @$row['sp_so_luong'][$key],
//                                        'total_price' => @($row['dh_thanh_tien'][$key] * $row['sp_so_luong'][$key]),
//                                        'created_at' => $date . ':00',
//                                        'updated_at' => $date . ':00',
//                                    ]);
//                                }
//                            }
//                        }
//                    }
                    }
                }


            });
            $type = HistoryConstant::TYPE_IMPORT;
            $data = HistoryConstant::DATA_CUSTOMER;
            Functions::createHistory($type, $data);
            return redirect()->back()->with('success', 'Tải khách hàng thành công');
        }
        return redirect()->back()->with('danger', 'File không đúng định dạng *xlsx');
    }
}
