<?php

namespace App\Http\Controllers\Backend;

use App\Constants\HistoryConstant;
use App\Constants\Setting;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\ProductCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\ProductService;
use App\Models\Product;
use Excel;

class ProductController extends Controller
{

    private $productService;

    /**
     * TaskController constructor.
     *
     * @param TaskService $taskService
     */
    public function __construct(ProductService $productService)
    {
        $this->productService = $productService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $dataSearch = $request->all();
        $category = ProductCategory::pluck('name', 'id')->toArray();
        $docs = Product::search($dataSearch)->paginate(StatusCode::PAGINATE_20);
        if ($request->ajax()) {
            return view('backend.products.ajax', compact('docs', 'dataSearch'));
        }

        return view('backend.products.index', compact('docs', 'dataSearch', 'category'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->merge([
            'weight' => $request->weight ? str_replace(',', '', $request->weight) : 0,
            'price' => $request->price ? str_replace(',', '', $request->price) : 0,
        ]);
        $input = $request->all();
        $this->productService->create($input);
        return redirect(route('san-pham.index'))->with('success', 'Thêm sản phẩm thành công');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        return $this->productService->find($id);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->merge([
            'weight' => $request->weight ? str_replace(',', '', $request->weight) : 0,
            'price' => $request->price ? str_replace(',', '', $request->price) : 0,
        ]);
        $this->productService->update($id, $request->all());
        return redirect(route('san-pham.index'))->with('success', 'Cập nhật sản phẩm thành công');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->productService->delete($id);

        return 1;

    }

    /**
     * import excel
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function import(Request $request)
    {
        if ($request->hasFile('file') && ($request->file('file')->getClientMimeType() == Setting::ExcelType || $request->file('file')->getClientMimeType() == Setting::ExcelTypeV2)) {
            Excel::load($request->file('file')->getRealPath(), function ($render) {
                $result = $render->toArray();
                foreach ($result as $k => $row) {
                    if ($row['ma_san_pham'] && $row['ten_san_pham']) {
                        $input = [
                            'code' => $row['ma_san_pham'],
                            'name' => $row['ten_san_pham'],
                            'weight' => $row['khoi_luong'],
                            'price' => $row['gia_ban'],
                        ];

                        $product = $this->productService->findCode($row['ma_san_pham']);
                        if (isset($product) && $product) {
                            $this->productService->update($product->id, $input);
                        } else {
                            $this->productService->create($input);
                        }
                    }
                }
            });
            $type = HistoryConstant::TYPE_IMPORT;
            $data = HistoryConstant::DATA_PRODUCT;
            Functions::createHistory($type, $data);
            return redirect()->back()->with('success', 'Tải sản phẩm thành công');
        }
        return redirect()->back()->with('danger', 'File không đúng định dạng *xlsx');
    }
}
