<?php

namespace App\Http\Controllers\Backend\Order;

use App\Constants\CustomerConstant;
use App\Constants\DepartmentConstant;
use App\Constants\OrderConstant;
use App\Helpers\Functions;
use App\Models\Customer;
use App\Models\Depot;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\ProductDepot;
use App\Models\Source;
use App\Models\Team;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Date;
use Excel;
use Illuminate\Support\Facades\Validator;


class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($request->quantity && in_array(null, $request->quantity)) {
            return response()->json([
                'success' => false,
                'message' => 'Vui lòng nhập số lượng',
            ]);
        }

        $user = Auth::user();

        if (!empty($request->customer_id)) {
            $customer1 = Customer::find($request->customer_id);
            $team = Team::where('leader_id',$user->id)->first();
            $check = $user->department_id == DepartmentConstant::SALE && $user->is_leader == 0 && !$team ? true : false;
            if($check && $user->id != $customer1->user_id){
                return response()->json([
                    'success' => false,
                    'message' => 'Bạn không phụ trách khách này !'
                ]);
            }
        }

        $data = $request->only('customer_id', 'sale_id', 'mkt_id', 'messages', 'city_id', 'district_id', 'ward_id',
            'address', 'description', 'depot_id', 'discount', 'advance_price', 'total','ship_price');
        if($request->is_upsale && $request->is_upsale == 'on'){
            $data['is_upsale'] = 1;
        } else {
            $data['is_upsale'] = 0;
        }

        $data['status'] = OrderConstant::STATUS_CHOT_DON;
        $data['discount'] = $data['discount'] ?: 0;
        $data['advance_price'] = $data['advance_price'] ?: 0;
        $data['customer_name'] = $request->name;

        if ($request->input('gioi_thieu')) {
            $request->merge(['customer_id'=>null]);
            $customer = Customer::where('phone', $request->phone)->orderByDesc('updated_at')->first();
            $source = Source::find($request->source_id);
            $date = date('Y-m-d H:i:s');

            if (!empty($customer)) {
                $data_insert['duplicate'] = 1;

                $date_check = date('Y-m-d H:i:s', strtotime('+30day', strtotime($customer->updated_at)));
                if ($date <= $date_check && $request->source_id == $customer->source_id) {
                    return response()->json([
                        'success' => false,
                        'message' => 'Trùng số, trùng source trong 30 ngày !',
                    ]);
                }
            }

            $data_insert['source_id'] = $request->source_id;
            $data_insert['name'] = $request->name;
            $data_insert['phone'] = $request->phone;
            $data_insert['message'] = $request->message;
            $data_insert['user_id'] = $user->id;
            $data_insert['mkt_id'] = $source->user_id;
            $data_insert['gioi_thieu'] = 1;
            $data_insert['status'] = CustomerConstant::CUSTOMER_CHOT_DON;
            $customer = Customer::create($data_insert);

            $data['customer_id'] = $customer->id;
            $data['sale_id'] = $user->id;
            $data['mkt_id'] = $source->user_id;
            $data['warehouse_id'] = Functions::checkWareHouse($data['sale_id']);
        }
        $data['ngay_chot_don'] = date('Y-m-d H:i:s');

        if ($request->has('order_id')) {
            $order = Order::find($request->order_id);
            $order->update($data);
            OrderDetail::where('order_id', $order->id)->delete();
        } else {
            $data['code'] = 'AD' . ($user->id) . strtotime(Date::now()) . 'AD';
            $data['warehouse_id'] = Functions::checkWareHouse($data['sale_id']);
            $order = Order::create($data);
        }
        if (isset($request->product) && count($request->product)) {
            foreach ($request->product as $key => $item) {
                $orderDetail['product_id'] = $item;
                $orderDetail['order_id'] = $order->id;
                $orderDetail['price'] = $request->price[$key];
                $orderDetail['quantity'] = $request->quantity[$key];
                $orderDetail['total_price'] = $request->total_item[$key];
                OrderDetail::create($orderDetail);
            }
        }

        if (!empty($request->customer_id)) {
            $count_order = Order::where('customer_id', $request->customer_id)->where('status', '>', 0)
                ->where('status','<>',OrderConstant::STATUS_HUY_DON)->get()->count();

            $customer = Customer::find($request->customer_id);
            if ($count_order > 1) {
                $customer->update(['name'         => $request->name,
                                   'phone'        => $request->phone,
                                   'message'      => $request->message,
                                   'customer_old' => CustomerConstant::IS_KHACH_CU,
                                   'status'  => CustomerConstant::CUSTOMER_CHOT_DON
                ]);
            } else {
                $customer->update(['name'    => $request->name,
                                   'phone'   => $request->phone,
                                   'message' => $request->message,
                                   'status'  => CustomerConstant::CUSTOMER_CHOT_DON
                ]);
            }
        }
        Functions::updateQuantityDepot($request->depot_id, OrderConstant::TYPE_TRU_SL_KHO, $order->id);
        return response()->json([
            'success'    => true,
            'message'    => 'Chốt đơn thành công',
            'save_order' => true,
            'order_id'   => $order->id,
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        Order::find($request->order_id)->update(['status' => OrderConstant::STATUS_CHOT_DON]);
        Functions::updateQuantityDepot($request->depot_id, OrderConstant::TYPE_TRU_SL_KHO, $request->order_id);
        return response()->json([
            'success' => true,
            'message' => 'Chốt đơn thành công',
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getOrder($phoneNumber)
    {
        $customers = Customer::where('phone', $phoneNumber)->with('orders.orderStatus','orders.orderDetails.product', 'source', 'sale',
            'customerStatus')->get();
        return $customers;
    }

    public function updateStatusOrder(Request $request, $id)
    {
        $order = Order::find($id);
        $status_order = $order->status;
        if ($request->data_status == OrderConstant::STATUS_HUY_DON) { //hủy đơn
            if ($status_order == OrderConstant::STATUS_CHOT_DON) {
                $message = 'Cập nhật thành công !';
                $data_success = true;
                $order->update(['status' => $request->data_status]);
                Functions::updateQuantityDepot($order->depot_id, OrderConstant::TYPE_CONG_SL_KHO, $order->id);
            } else {
                $data_success = false;
                $message = 'Không được hủy đơn !';
            }
        } else {
            $data_success = true;
            $message = 'Cập nhật thành công !';
            $order->update(['status' => $request->data_status]);
            if ($request->data_status == OrderConstant::STATUS_HOAN_HUY) {
                Functions::updateQuantityDepot($order->depot_id, OrderConstant::TYPE_CONG_SL_KHO, $order->id);
            }
        }
        return response()->json([
            'success' => $data_success,
            'message' => $message,
        ]);
    }

    public function exportExcel(Request $request)
    {
        $data = Order::with('orderDetails', 'customer')->get();
        Excel::create('Đơn hàng (' . Date::now()->format('d-m-y') . ')', function ($excel) use ($data) {
            $excel->sheet('Data', function ($sheet) use ($data) {
                $sheet->cell('A1:U1', function ($row) {
                    $row->setBackground('#008686');
                    $row->setFontColor('#ffffff');
                });
                $sheet->freezeFirstRow();
                $sheet->row(1, [
                    'STT',
                    'Nguồn data',
                    'Mã đơn',
                    'ĐH Tên SP',
                    'ĐH Mã SP',
                    'KH Họ tên',
                    'KH Số ĐT',
                    'SP Số lượng',
                    'ĐH Đặt cọc',
                    'ĐH Chiết khấu',
                    'ĐH COD thu của khách',
                    'ĐH Tổng tiền',
                    'GH Ghi chú',
                    'GH Địa chỉ tổng hợp',
                    'GH Trạng thái',
                    'Đối soát',
                    'Sale Ngày chốt đơn',
                    'Sale Tên',
                    'Sale TK',
                    'Sale ghi chú',
                    'MKT Tên',
                ]);

                $i = 0;
                if ($data) {
                    foreach ($data as $k => $ex) {
                        $i++;
//                        foreach ($ex->categories as $category) {
//                            $categoryName .= $category->name . ', ';
//                        }
                        $sheet->row($i, [
                            @$i,
                            @$ex->customer->source->name,
                            @$ex->code,
                            @$ex->product_space,
                            @$ex->product_code,
                            @$ex->customer->name,
                            @$ex->customer->phone,
                            @$ex->quantity_text,
                            @$ex->advance_price,
                            @$ex->discount,
                            0,
                            @$ex->total,
                            @$ex->description,
                            @$ex->address,
                            @$ex->status . '/ghep trang thai',
                            '',
                            @Functions::dayMonthYear($ex->created_at),
                            @$ex->sale->name,
                            @$ex->sale->user_name,
                            @$ex->sale_note,
                            @$ex->marketing->name,
                            // (@$ex->type == 0) ? 'Tài khoản thường' : 'Tài khoản VIP',
                        ]);
                    }
                }
            });
        })->export('xlsx');

    }

    public function searchOrder(Request $request)
    {
        $orders = Order::whereIn('id', $request->arrId)->with('orderDetails.product', 'customer', 'city', 'district',
            'ward')->get();
        return $orders;
    }

    /**
     * Thay đổi trạng thái khi sale hủy đơn
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function saleHuyDon(Request $request)
    {
        $order = Order::find($request->order_id);
        if ($order->status == OrderConstant::STATUS_CHOT_DON) {
            Functions::updateQuantityDepot($order->depot_id, OrderConstant::TYPE_CONG_SL_KHO, $order->id);
            $order->update(['status' => OrderConstant::STATUS_DON_LUU]);
            $success = true;
            $mess = 'Cập nhật thành công !';

//            Functions::checkCustomerOld($order->customer_id);
        } else {
            $success = false;
            $mess = 'Không được hủy đơn !';
        }

        return response()->json([
            'success' => $success,
            'message' => $mess,
        ]);
    }

    public function getOrderId($id){
        $data['order'] = Order::where('id',$id)->with('customer','orderDetails.product')->first();
        $data['depots'] = Depot::all();
        return $data;
    }

    public function updateOrderDepot(Request $request){
        $order = Order::where('id',$request->order_id)->with('orderDetails')->first();
        $arr_err = [];
        if($order){
            $product = $order->orderDetails;
            foreach ($product as $item){
                $product_depot = ProductDepot::where('product_id',$item->product_id)->where('depot_id',$request->depot_id)->with('product')->first();
                if($product_depot && $product_depot->quantity < $item->quantity || !$product_depot){
                    $arr_err[] = $product_depot;
                }
            }
        }
        if($arr_err != []){ // số lượng không đủ
           return $arr_err;
        } else {
            $order->update(['depot_id'=>$request->depot_id]);
            return 1;
        }

    }

}
