<?php

namespace App\Http\Controllers\Backend\Marketing;

use App\Constants\DepartmentConstant;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\Customer;
use App\Models\ProductDepot;
use App\Models\Source;
use App\Models\Team;
use App\Models\TeamMember;
use App\Services\Marketing\SourceService;
use App\Services\UserService;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class SourceController extends Controller
{
    private $source, $user;

    public function __construct(SourceService $source, UserService $userService)
    {
        $this->source = $source;
        $this->user = $userService;

        $search['searchDepartment'] = DepartmentConstant::MARKETING;
        $product = ProductDepot::search(null)->get();
        $user_mkt = $this->user->getAll($search)->get();
        view()->share([
            'products' => $product,
            'user_mkt' => $user_mkt,
        ]);
    }

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        $search['searchUser'] = $request->searchUser;
//        $search['searchProduct'] = $request->searchProduct;
//        $search['searchName'] = $request->searchName;
//        $source = $this->source->index($search);
//
//        $page = 1;
//        $source = Functions::customPaginate($source,$page);
        return view('backend.marketing.setting_connect.index');
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['product_id'] = json_encode($request->product_id);
        $data['sale_id'] = json_encode($request->sale_id);
        $data['user_id'] = Auth::user()->id;
        Source::create($data);
        return back()->with('success', 'Thêm mới source thành công');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        if ($request->has('accept')) {
            $data['accept'] = $request->accept == 'true' ? 1 : 0;
        }
        if ($request->has('product_id')) {
            $data['product_id'] = json_encode($request->product_id);
        }
        if ($request->has('sale_id')) {
            $data['sale_id'] = json_encode($request->sale_id);
        }

        $this->source->update($data, $id);

        //update ajax
        if ($request->has('accept')) {
            return 1;
        }

        return back()->with('success', 'Cập nhật sản phẩm thành công');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $source = $this->source->delete($id);
        if ($source) {
            $message = 'Đã xóa thành công !';
        } else {
            $message = 'Source đã được sử dụng không được xóa';
        }
        return response()->json([
            'success' => $source,
            'message' => $message,
        ]);
    }

    /**
     * Hiển thị source form
     *
     * @param $id
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function getForm($id)
    {
        $source = Source::find($id);
        return view('form_test', compact('source'));
    }

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     *
     * @return void
     */
    public function getAllSource(Request $request)
    {
        $user = Auth::user();
        $search['searchUser'] = $request->searchUser;
        $search['searchProduct'] = $request->searchProduct;
        $search['searchName'] = $request->searchName;
        $search['searchType'] = $request->searchType;
        $search['searchAccept'] = $request->searchAccept;
        if (!in_array($user->department_id, [
                DepartmentConstant::CEO,
                DepartmentConstant::ADMIN,
            ]) || ($user->department_id == DepartmentConstant::MARKETING && $user->is_leader == DepartmentConstant::IS_LEADER)) {
            if ($user->department_id == DepartmentConstant::MARKETING) {
                if (isset($user->teams) && count($user->teams)) {
                    $input['teamMember'] = $user->teams[0]->id;
                    $member = TeamMember::search($input)->pluck('user_id')->toArray();
                    $search['searchArrayUser'] = $member;

                } else {
                    $search['searchUser'] = $user->id;
                }
            }
        }
        $source = $this->source->index($search);

        $page = $request->page;
        $source = Functions::customPaginate($source, $page);
        return response()->json([
            'statusCode' => StatusCode::OK,
            'data'       => $source,
        ]);
    }


    public function updateAcceptSource(Request $request)
    {
        $user = Auth::user();
        $data['accept'] = $request->value;
        $id = $request->id;
        $team = Team::where('leader_id',$user->id)->first();
        if ($user->department_id == DepartmentConstant::ADMIN || $user->department_id == DepartmentConstant::CEO || $user->is_leader == DepartmentConstant::IS_LEADER || $team) {
            $this->source->update($data, $id);
            $status_code = StatusCode::OK;
        } else {
            $status_code = StatusCode::WARNING;
        }
        return response()->json([
            'statusCode' => $status_code,
        ]);
    }


    public function saleGetSource(Request $request)
    {
        if($request->term){
            $search['searchName'] = $request->term['term'];
        }
        $search['searchAccept'] = 1;
        $source = Source::search($search)->get()->take(StatusCode::PAGINATE_20);
        return $source;
    }
}
