<?php

namespace App\Http\Controllers\Backend\Marketing;

use App\Constants\StatusCode;
use App\Helpers\Functions;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Constants\OrderConstant;
use App\Models\Order;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class RankingController extends Controller
{
    public function marketing(Request $request)
    {
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }
        $params = $request->all();
        $params['not_in_status'] = [OrderConstant::STATUS_DON_LUU];
        $params['role_filter'] = 'mkt';
        $data = Order::searchGroupBy($params, 'all_total', 'mkt_id')->with('marketing')
            ->when(isset($request->type_customer), function ($q) use ($request) {
                $q->whereHas('customer', function ($qw) use ($request) {
                    $qw->where('customer_old', $request->type_customer);
                });
            })->whereHas('customer', function ($qr) {
                $qr->where('gioi_thieu', StatusCode::INACTIVE);
            })->get();
        $me = Auth::user()->id ?: 0;
        $response = [];
        if (count($data)) {
            foreach ($data as $item) {
                if (isset($item->marketing)) {
                    $response[] = [
                        'mkt_id' => $item->mkt_id,
                        'all_total' => $item->all_total + $item->all_advance_price + $item->all_ship_price,
                        'name' => @$item->marketing->name,
                        'avatar' => @$item->marketing->avatar,
                    ];
                }
            }
            usort($response, function ($a, $b) {
                return $b['all_total'] <=> $a['all_total'];
            });
            $my_key = array_keys(array_column((array)$response, 'mkt_id'), $me);
        } else {
            $my_key = [];
        }
        if ($request->ajax()) {
            return view('backend.marketing.ranking.ajax', compact('response', 'my_key'));
        }
        return view('backend.marketing.ranking.index', compact('response', 'my_key'));
    }
}
