<?php

namespace App\Http\Controllers\Backend\Marketing;

use App\Constants\CustomerConstant;
use App\Constants\DepartmentConstant;
use App\Constants\OrderConstant;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\Customer;
use App\Models\Order;
use App\Models\OrderStatus;
use App\Models\PriceMarketing;
use App\Models\Product;
use App\Models\Team;
use App\Models\TeamMember;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class LeaderController extends Controller
{
    /**
     * thống kê trưởng nhóm
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }
        $input = $request->all();
        $user = Auth::user();
        $products = Product::all();
        $status_orders = OrderStatus::all();

        if ($request->sau_hoan_huy == 1) {
            $input['not_in_status'] = [
                OrderConstant::STATUS_DON_LUU,
                OrderConstant::STATUS_HOAN_HUY,
                OrderConstant::STATUS_HUY_DON,
            ];
        } else {
            $input['not_in_status'] = [OrderConstant::STATUS_DON_LUU];
        }
        $team_members = [];
        $is_not_leader_admin = false;
        if ($user->department_id == DepartmentConstant::CEO || $user->department_id == DepartmentConstant::ADMIN || $user->is_leader == DepartmentConstant::IS_LEADER) { // trưởng phòng
            $search_source['searchUser'] = $request->marketing_id;
            $teams = Team::select('id', 'name')->where('department_id', DepartmentConstant::MARKETING)->get();
            if (count($teams)) {
                $team_members = TeamMember::whereIn('team_id', !empty($input['team_id']) ? $input['team_id'] : [$teams[0]->id])->has('user')->with('user')->get()->map(function ($item) use ($input) {
                    $input['marketing'] = $item->user_id;
                    $input['gioi_thieu'] = StatusCode::INACTIVE;
                    $all_customer = Customer::search1($input, 'created_at')->where('customer_old', 0)->where('gioi_thieu', 0)->select('id', 'status');

                    $input['user_id'] = $item->user_id;
                    $item->budget = PriceMarketing::search($input)->sum('budget');
                    unset($input['budget'], $input['user_id'], $input['source_id']);
                    //Tỷ lệ tiêp cận
                    $all_customer1 = clone $all_customer;
                    $all_customer2 = clone $all_customer;
                    $item->customers = $all_customer->count();
                    $item->customer_new = $all_customer1->where('status', CustomerConstant::CUSTOMER_NEW)->count();
                    $item->customer_abc = $all_customer2->whereIn('status', [
                        CustomerConstant::CUSTOMER_CHUA_TIEP_CAN,
                        CustomerConstant::CUSTOMER_NEW,
                        CustomerConstant::CUSTOMER_BO_QUA,
                    ])->count();

                    if ($item->customers - $item->customer_new > 0) {
                        $item->ti_le_tiep_can = ($item->customers - $item->customer_abc) / ($item->customers - $item->customer_new);
                    } else {
                        $item->ti_le_tiep_can = 0;
                    }
                    //end tỷ lệ tiếp cận

                    $input['is_upsale'] = 0;
                    $orders = Order::search($input, 'ngay_chot_don')->select('total', 'advance_price', 'discount'); //order khách mới

                    unset($input['source_id']);
                    $not_in = $input['not_in_status'];
                    unset($input['not_in_status'], $input['is_upsale']);

                    $ordersAllPrice = Order::search($input)->select('total', 'advance_price', 'discount');
                    $ordersAll = clone $ordersAllPrice;
                    $ordersAll = $ordersAll->whereNotIn('status', $not_in);

                    $item->all_order = $ordersAll;
                    $item->orders = $orders->count();
                    $item->total = $orders->sum('total') + $orders->sum('advance_price'); //tổng tiền khách mới
                    $item->totalOld = $ordersAll->sum('total') + $ordersAll->sum('advance_price') - $item->total; //tổng tiền khách cũ
                    $item->totalAll = $ordersAll->sum('total') + $ordersAll->sum('advance_price'); //tổng tiền khách cũ + khách mới;
                    $item->allDiscount = $ordersAll->sum('discount');
                    $item->all_order = $ordersAll->count();
                    $item->doanh_so_huy = $ordersAllPrice->sum('total') + $ordersAllPrice->sum('advance_price') - $item->totalAll;
                    return $item;
                })->sortByDesc('total');
            }
        } else { //team lead
            $teams = Team::select('id', 'name')->where('leader_id', $user->id)->first();
            if (!empty($teams)) {
                $team_members = TeamMember::where('team_id', $teams->id)->has('user')->with('user')->get()->map(function ($item) use ($input) {
                    $input['user_id'] = $item->user_id;
                    $item->budget = PriceMarketing::search($input)->select('budget')->sum('budget');
                    unset($input['budget'], $input['user_id']);
                    $input['marketing'] = $item->user_id;
                    $input['gioi_thieu'] = StatusCode::INACTIVE;
                    $all_customer = Customer::search1($input, 'created_at')->where('customer_old', 0)->select('id', 'status');
                    $all_customer1 = clone $all_customer;
                    $all_customer2 = clone $all_customer;
                    $item->customers = $all_customer->count();
                    $item->customer_new = $all_customer1->where('status', CustomerConstant::CUSTOMER_NEW)->count();
                    $item->customer_abc = $all_customer2->whereIn('status', [
                        CustomerConstant::CUSTOMER_CHUA_TIEP_CAN,
                        CustomerConstant::CUSTOMER_NEW,
                        CustomerConstant::CUSTOMER_BO_QUA,
                    ])->count();

                    if ($item->customers - $item->customer_new > 0) {
                        $item->ti_le_tiep_can = ($item->customers - $item->customer_abc) / ($item->customers - $item->customer_new);
                    } else {
                        $item->ti_le_tiep_can = 0;
                    }

                    $input['is_upsale'] = 0;
                    $orders = Order::search($input, 'ngay_chot_don')->select('total', 'advance_price', 'discount'); //order khách mới
                    unset($input['source_id'], $input['customer_old']);
                    $not_in = $input['not_in_status'];
                    unset($input['not_in_status'], $input['is_upsale']);
                    $ordersAllPrice = Order::search($input)->select('total', 'advance_price', 'discount');
                    $ordersAll = clone $ordersAllPrice;
                    $ordersAll = $ordersAll->whereNotIn('status', $not_in);

                    $item->all_order = $ordersAll;
                    $item->orders = $orders->count();
                    $item->total = $orders->sum('total') + $orders->sum('advance_price'); //tổng tiền khách mới
                    $item->totalOld = $ordersAll->sum('total') + $ordersAll->sum('advance_price') - $item->total; //tổng tiền khách cũ
                    $item->totalAll = $ordersAll->sum('total') + $ordersAll->sum('advance_price'); //tổng tiền khách cũ + khách mới;
                    $item->allDiscount = $ordersAll->sum('discount');
                    $item->all_order = $ordersAll->count();
                    $item->doanh_so_huy = $ordersAllPrice->sum('total') + $ordersAllPrice->sum('advance_price') - $item->totalAll;
                    return $item;
                })->sortByDesc('customers');
            } else { // user
                $user = Auth::user();
                $input['marketing'] = $user->id;
                $input['gioi_thieu'] = StatusCode::INACTIVE;

                $all_customer = Customer::search1($input, 'created_at')->where('customer_old', 0)->select('id', 'status');

                $input['user_id'] = $user->id;
                $budget = PriceMarketing::search($input)->select('budget')->sum('budget');

                $all_customer1 = clone $all_customer;
                $all_customer2 = clone $all_customer;

                $customers = $all_customer->count();

                $customer_new = $all_customer1->where('status', CustomerConstant::CUSTOMER_NEW)->count();
                $customer_abc = $all_customer2->whereIn('status', [
                    CustomerConstant::CUSTOMER_CHUA_TIEP_CAN,
                    CustomerConstant::CUSTOMER_NEW,
                    CustomerConstant::CUSTOMER_BO_QUA,
                ])->count();

                if ($customers - $customer_new > 0) {
                    $ti_le_tiep_can = ($customers - $customer_abc) / ($customers - $customer_new);
                } else {
                    $ti_le_tiep_can = 0;
                }

                $input['is_upsale'] = 0;
                $orders = Order::search($input, 'ngay_chot_don')->select('total', 'advance_price', 'discount'); //order khách mới
                unset($input['source_id'], $input['customer_old'], $input['is_upsale']);

                $not_in = $input['not_in_status'];
                unset($input['not_in_status']);
                $ordersAllPrice = Order::search($input)->select('total', 'advance_price', 'discount');
                $ordersAll = clone $ordersAllPrice;
                $ordersAll = $ordersAll->whereNotIn('status', $not_in);

                $total = $orders->sum('total') + $orders->sum('advance_price'); //tổng tiền khách mới
                $totalOld = $ordersAll->sum('total') + $ordersAll->sum('advance_price') - $total; //tổng tiền khách cũ
                $totalAll = $ordersAll->sum('total') + $ordersAll->sum('advance_price'); //tổng tiền khách cũ + khách mới;
                $allDiscount = $ordersAll->sum('discount');

                $team_members[] = (object)[
                    'budget' => $budget,
                    'customers' => $customers,
                    'customer_new' => $customer_new,
                    'customer_abc' => $customer_abc,
                    'ti_le_tiep_can' => $ti_le_tiep_can,
                    'all_order' => $ordersAll->count(),
                    'orders' => $orders->count(),
                    'total' => $total,
                    'totalOld' => $totalOld,
                    'totalAll' => $totalAll,
                    'allDiscount' => $allDiscount,
                    'user' => $user,
                    'doanh_so_huy' => $ordersAllPrice->sum('total') + $ordersAllPrice->sum('advance_price') - $totalAll,
                ];
                $is_not_leader_admin = true;
            }
            $teams = [];
        }
        if ($request->ajax()) {
            return view('backend.marketing.leader.ajax', compact('teams', 'team_members', 'is_not_leader_admin'));
        }
        return view('backend.marketing.leader.index', compact('teams', 'products', 'status_orders', 'team_members', 'is_not_leader_admin'));
    }

    public function teamSale(Request $request)
    {
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }

        $is_teamlead = count(Auth::user()->teams) > 0 ? true : false;
        $user = Auth::user();
        $team_mkt = [];
        if ($user->department_id == DepartmentConstant::ADMIN || $user->department_id == DepartmentConstant::CEO || $user->is_leader == DepartmentConstant::IS_LEADER) {
            $team_mkt = Team::where('department_id', DepartmentConstant::MARKETING)->get();
        } else if ($is_teamlead) {
            $team_mkt = Team::where('leader_id', $user->id)->get();
            $request->merge(['team_id' => $team_mkt[0]->id]);
        }

        $teams = [];
        if ($request->team_id) {

            $arr_user_mkt = TeamMember::where('team_id', $request->team_id)->pluck('user_id')->toArray();
            $teams = Team::where('department_id', DepartmentConstant::SALE)->orderBy('created_at','asc')->get()->map(function ($team) use ($request, $arr_user_mkt) {

                $search = $request->all();
                $team_members = TeamMember::where('team_id', $team->id)->pluck('user_id')->toArray();

                $search['arr_sale_id'] = $team_members;
                if ($request->team_id != 9999) {
                    $search['arr_mkt_id'] = $arr_user_mkt;
                }
                $search['gioi_thieu'] = StatusCode::INACTIVE;
                $customers = Customer::search1($search, 'created_at')->select('id', 'created_at', 'status');
                $customers1 = clone $customers;
                $customers2 = clone $customers;
                $customers_new = $customers1->where('status', CustomerConstant::CUSTOMER_NEW);
                $customers_abc = $customers2->whereIn('status', [CustomerConstant::CUSTOMER_NEW, CustomerConstant::CUSTOMER_CHUA_TIEP_CAN, CustomerConstant::CUSTOMER_BO_QUA]);

                $team['total_contact'] = $customers->count();
                if ($customers->count() - $customers_new->count() > 0) {
                    $team['ti_le_tiep_can'] = ($customers->count() - $customers_abc->count()) / ($customers->count() - $customers_new->count());
                } else {
                    $team['ti_le_tiep_can'] = 0;
                }

                $team['count_customers_new'] = $customers_new->count();
                $team['count_customers_abc'] = $customers_abc->count();

                $search['not_in_status'] = [OrderConstant::STATUS_DON_LUU];

                $search['all_sale_id'] = $team_members;
                $orders = Order::search($search)->select('total', 'advance_price');
                $orders1 = clone $orders;
                $orders_new = $orders1->where('is_upsale', StatusCode::INACTIVE);
                $team['count_order_all'] = $orders->count();
                $team['count_order_new'] = $orders_new->count();
                $team['total_all'] = $orders->sum('total') + $orders->sum('advance_price');
                $team['total_new'] = $orders_new->sum('total') + $orders_new->sum('advance_price');
                return $team;
            });
        }
        if ($request->ajax()) {
            return view('backend.marketing.leader.team_sale_ajax', compact('teams'));
        }
        return view('backend.marketing.leader.team_sale', compact('team_mkt', 'teams'));
    }

    /**
     * Báo cáo doanh số theo tỉnh thành phố
     */
    public function doanhSoCity(Request $request)
    {
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }
        $search_order = $request->all();
        $search_order['not_in_status'] = [OrderConstant::STATUS_DON_LUU];
        $teams = Team::where('department_id',DepartmentConstant::MARKETING)->get();

        if($request->team_id){
            $team_members = TeamMember::where('team_id',$request->team_id);
            $team_members1 = clone $team_members;
            $arr_mkt_id = $team_members1->pluck('user_id')->toArray();
            $search_order['arr_mkt_id'] = $arr_mkt_id;
            $team_members = $team_members->get();
        } else {
            if(count($teams)){
                $team_members = TeamMember::where('team_id',$teams[0]->id)->get();
            }else {
                $team_members = [];
            }
        }

        $orders = Order::search($search_order)->withCount('orderDetails');
        $orders1 = clone $orders;
        $orders2 = clone $orders;
        $orders3 = clone $orders;

        //order trừ hoàn
        $order_hoan = $orders1->whereNotIn('status',[OrderConstant::STATUS_HOAN_HUY,OrderConstant::STATUS_DANG_HOAN])->select('id','total','discount','advance_price','city_id',
            DB::raw('count(*) as count_hoan'),
            DB::raw('sum(total) as total_hoan'),
            DB::raw('sum(discount) as discount_hoan'),
            DB::raw('sum(advance_price) as advance_price_hoan')
        )->groupBy('city_id');

        //order trừ hoàn hủy
        $order_hoan_huy = $orders2->whereNotIn('status',[OrderConstant::STATUS_HUY_DON,OrderConstant::STATUS_HOAN_HUY,OrderConstant::STATUS_DANG_HOAN])
            ->select('id','total','discount','advance_price','city_id',
                DB::raw('count(*) as count_hoan_huy'),
                DB::raw('sum(total) as total_hoan_huy'),
                DB::raw('sum(discount) as discount_hoan_huy'),
                DB::raw('sum(advance_price) as advance_price_hoan_huy')
            )->groupBy('city_id');

        //order chiết khấu
        $order_discout = $orders3->where('discount','>',0)
            ->select('id','total','discount','advance_price','city_id',
                DB::raw('count(*) as count_discount'),
                DB::raw('sum(total) as total_discount'),
                DB::raw('sum(discount) as discount_discount'),
                DB::raw('sum(advance_price) as advance_price_discount')
            )->groupBy('city_id');

//        if($request->ajax()){
//            dd($order_discout->get());
//        }

        //order all
        $order_all = $orders->select('id','total','discount','advance_price','city_id',
            DB::raw('count(*) as count_all_total'),
            DB::raw('sum(total) as all_total'),
            DB::raw('sum(discount) as all_discount'),
            DB::raw('sum(advance_price) as all_advance_price')
        )->groupBy('city_id')->orderBy('city_id','asc')->get()->map(function ($order) use ($order_hoan,$order_hoan_huy,$order_discout){
            $order_hoan1 = clone $order_hoan;
            $order_hoan_huy1 = clone $order_hoan_huy;
            $order_discout1 = clone $order_discout;

            $hoan = $order_hoan1->where('city_id',$order->city_id)->first();
            $hoan_huy = $order_hoan_huy1->where('city_id',$order->city_id)->first();
            $discout = $order_discout1->where('city_id',$order->city_id)->first();

            if($hoan){
                $order['count_order_hoan'] = $hoan->count_hoan;
                $order['order_hoan_doanh_so'] = $hoan->total_hoan + $hoan->advance_price_hoan ;
            } else {
                $order['count_order_hoan'] = 0;
                $order['order_hoan_doanh_so'] = 0;
            }

            if($hoan_huy){
                $order['count_order_hoan_huy'] = $hoan_huy->count_hoan_huy;
                $order['order_hoan_huy_doanh_so'] = $hoan_huy->total_hoan_huy + $hoan_huy->advance_price_hoan_huy;
            } else {
                $order['count_order_hoan_huy'] = 0;
                $order['order_hoan_huy_doanh_so'] = 0;
            }

            if($discout){
                $order['count_order_discount'] = $discout->count_discount;
                $order['order_discount_doanh_so'] = $discout->total_discount + $discout->advance_price_discount;
            } else {
                $order['count_order_discount'] = 0;
                $order['order_discount_doanh_so'] = 0;
            }
            return $order;
        })->sortByDesc('all_total');



        if($request->ajax()){
//            dd($order_all);
//            dd($search_order);
            return view('backend.marketing.leader.doanh_so_city_ajax',compact('teams','team_members','order_all'));
        }
        return view('backend.marketing.leader.doanh_so_city',compact('teams','team_members','order_all'));
    }


}
