<?php

namespace App\Http\Controllers\Backend\Marketing;

use App\Constants\DepartmentConstant;
use App\Constants\OrderConstant;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\Customer;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\PriceMarketing;
use App\Models\Product;
use App\Models\Source;
use App\Models\Team;
use App\Models\UserFilerGrid;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();
        $search_source['searchType'] = $request->source_type;
        $search_source['searchChanel'] = $request->chanel;
        $search_source['searchIsContact'] = $request->is_contact;
        $search_source['searchProduct'] = $request->product_id;
        $search_source['searchName'] = $request->source_name;

        $search['department_id'] = DepartmentConstant::MARKETING;
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }
        if ($user->is_leader || $user->department_id == DepartmentConstant::CEO || $user->department_id == DepartmentConstant::ADMIN) { // trưởng phòng
            $search['team_member'] = [];
            $search_source['searchUser'] = $request->marketing_id;
            $isShowName = true;
        } else {
            $team = Team::select('id')->where('leader_id', $user->id)->with('teamMembers')->first();
            if ($team) { // team lead
                $isShowName = true;
                $search_source['searchArrayUser'] = $team->arrayIdTeamMember();
                $search_source['searchUser'] = $request->marketing_id;
                $search['team_member'] = $team->arrayIdTeamMember();
            } else { // user
                $isShowName = false;
                $search['team_member'] = [0];
                $search_source['searchUser'] = $user->id;
            }
        }
        $products = Product::select('id','name')->get();
        $marketings = User::search($search)->get();
        $source = Source::search($search_source)->select('id','name','product_id','user_id')->paginate(StatusCode::PAGINATE_20);

        $source->setCollection($source->getCollection()->map(function ($item) use ($request) {
            $search['source_id'] = $item->id;
            $search['customer_old'] = $request->type_customer;
            $search['gioi_thieu'] = StatusCode::INACTIVE;
            $search['start_date'] = $request->start_date;
            $search['end_date'] = $request->end_date;

            $price = PriceMarketing::search($search)->select('budget', 'number_click',
                DB::raw('sum(budget) as total_budget'), DB::raw('sum(number_click) as total_number_click'))->first();

            $item->customer = Customer::search1($search,'created_at')->count(); //customer theo ngày
            $search_order['source_id'] = $item->id;
            $search_order['not_in_status'] = [OrderConstant::STATUS_DON_LUU];
            $search_order['is_upsale'] = $request->type_customer;
            $search_order['start_date'] = $request->start_date;
            $search_order['end_date'] = $request->end_date;
            $search_order['gioi_thieu'] = StatusCode::INACTIVE;


            $order = Order::search($search_order,'ngay_chot_don')->select('id','total', 'advance_price', 'discount')->withCount('orderDetails');

            $item->sum_total_order = $order->sum('total') + $order->sum('advance_price') ; //tổng tiền

            $item->sum_discount = $order->sum('discount');
            $item->count_order = $order->count(); //tổng orders

            $item->price_mkt = $price->total_budget; //ngân sách
            $item->number_click = $price->total_number_click;

            $item->product = $order->get()->sum('order_details_count');

            if (!empty($item->customer) || !empty($item->product)) {
                return $item;
            }
        }));

        $all_customer = $source->sum('customer');
        $all_click = $source->sum('number_click');
        $all_total_price = $source->sum('price_mkt');
        $count_all_order_chot = $source->sum('count_order');
        $all_product = $source->sum('product');
        $sum_order_chot_total = $source->sum('sum_total_order');
        $sum_order_chot_discount = $source->sum('sum_discount');

        $url = '/marketing/dashboard';
        $user_filter_grid = UserFilerGrid::where('user_id', $user->id)->where('url', $url)->first();
        if ($user_filter_grid) {
            $user_filter_grid = json_decode($user_filter_grid->fields);
        } else {
            $user_filter_grid = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"];
        }

        if ($request->ajax()) {
            return view('backend.marketing.dashboard.ajax',
                compact('source', 'products', 'all_customer', 'all_total_price', 'count_all_order_chot', 'all_product',
                    'sum_order_chot_total', 'sum_order_chot_discount', 'user_filter_grid', 'all_click'));
        }
        return view('backend.marketing.dashboard.index',
            compact('source', 'marketings', 'products', 'isShowName', 'all_customer', 'all_total_price',
                'count_all_order_chot', 'all_product', 'sum_order_chot_total', 'sum_order_chot_discount',
                'user_filter_grid', 'all_click'));
    }

    public function addLanding(Request $request)
    {
        $input['start_date'] = $request->start_date;
        $input['end_date'] = $request->end_date;
        $input['source_id'] = $request->source_id;
        $dates = PriceMarketing::search($input)->with('source')->orderByDesc('date')->get()->map(function ($m) {
            $m->productName = $m->getProductName();
            $m->date = Carbon::parse($m->date)->format('d/m/Y');
            $m->username = $m->user ? $m->user->name : '';
            return $m;
        });
        return $dates;
    }

    public function getPriceMarketing(Request $request)
    {
//        $input = [];
//        if (empty($request->start_date) && empty($request->end_date)) {
//            $input = [
//                'start_date' => Carbon::now()->startOfWeek()->format('d/m/Y'),
//                'end_date' => Carbon::now()->endOfWeek()->format('d/m/Y'),
//            ];
//        }
//        $input['source_id'] = $request->source_id;
//
//        $data = PriceMarketing::search($input)->orderByDesc('date')->get()->map(function ($m){
//            $m->date = Carbon::createFromFormat('d/m/Y', $m->date);
//            return $m;
//        });
//        dd($data);
//        return $data;
    }

    public function updatePriceMarketing(Request $request)
    {
        $user = Auth::user();
        if ($request->id && count($request->id)) {
            foreach ($request->id as $key => $item) {
                PriceMarketing::find($item)->update([
                    'source_id'    => $request->source_id,
                    'budget'       => str_replace(",", "", $request->budget[$key]),
                    'number_click' => $request->number_click[$key],
                    'date'         => Carbon::createFromFormat('d/m/Y', $request->date[$key])->format('Y-m-d'),
                    'user_id'      => $user->id,
                ]);
            }
        }
        return 1;
    }

    public function addLinePriceMarketing(Request $request)
    {
        $user = Auth::user();
        $data = PriceMarketing::create([
            'source_id' => $request->source_id,
            'user_id'   => $user->id,
        ]);
        return $data;
    }

    public function deleteLinePriceMarketing($id)
    {
        PriceMarketing::find($id)->delete();
        return 1;
    }

    public function sumTotal($array, $sum_item)
    {
        $total = 0;
        foreach ($array as $item) {
            $total += $item->$sum_item;
        }
        return $total;
    }
}
