<?php

namespace App\Http\Controllers\Backend;

use App\Models\Customer;
use App\Models\CustomerStatus;
use App\Models\Source;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class InsertDataCustomController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $sources = Source::where('user_id', Auth::user()->id)->orderByDesc('id')->get();
        $status = CustomerStatus::all();
        return view('backend.marketing.custom_data.index', compact('sources', 'status'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!$request->source_id) {
            return back()->with('error', 'Source không được bỏ trống');
        };
        $source = Source::find($request->source_id);
        $data = $request->all();
        $data['mkt_id'] = $source->user_id;

        $customer = Customer::where('phone', $request->phone)->orderByDesc('updated_at')->first();

        $date = date('Y-m-d H:i:s');

        if (!empty($customer)) {
            $data['duplicate'] = 1;
            $date_check = date('Y-m-d H:i:s', strtotime('+30day', strtotime($customer->updated_at)));
            if ($date <= $date_check && $request->source_id == $customer->source_id) {
                return back()->with('error', 'Trùng số, trùng source trong 30 ngày !');
            } else {
                $data['user_id'] = $customer->user_id;
            }
        }
        $arr_sale = json_decode($source->sale_id);
        $position = $source->position < count($arr_sale) - 1 ? $source->position + 1 : 0;
        if (!$customer) {
            $source->update(['position' => $position]);
        }
        $data['user_id'] = $customer ? $customer->user_id : $arr_sale[$position];
        $data['date_sale_nhan_data'] = $date;
        Customer::create($data);

        return back()->with('success', 'Thêm mới thành công');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
