<?php

namespace App\Http\Controllers\Backend;

use App\Constants\DepartmentConstant;
use App\Constants\FanpageConstant;
use App\Constants\StatusCode;
use App\Models\Fanpage;
use App\Models\FanpagePost;
use App\Models\Source;
use App\Models\TeamMember;
use App\Services\FanpagePostService;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Date;

class FanpagePostController extends Controller
{
    private $fanpage_post, $fanpage;

    public function __construct(FanpagePostService $fanpage_post, Fanpage $fanpage)
    {
        $this->fanpage_post = $fanpage_post;
        $this->fanpage = $fanpage;
        $source = Source::pluck('name', 'id')->toArray();
        view()->share([
            'source' => $source,
        ]);
    }

    /**
     * Hiển thị list
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $user = Auth::user();
        $data = [];
        if (in_array($user->department_id, [DepartmentConstant::CEO, DepartmentConstant::ADMIN]) || ($user->department_id == DepartmentConstant::MARKETING && $user->is_leader == DepartmentConstant::IS_LEADER)) {
            $my_page = Fanpage::pluck('name', 'id')->toArray();

        } else {
            $my_page = Fanpage::where('user_id', $user->id)->pluck('name', 'id')->toArray();

            if ($user->department_id == DepartmentConstant::MARKETING) {
                if (isset($user->teams) && count($user->teams)) {
                    $input['teamMember'] = $user->teams[0]->id;
                    $member = TeamMember::search($input)->pluck('user_id')->toArray();
                    $request->merge(['arr_sale_id' => $member]);
                    $search_user['team_member'] = $member;
                    $search_user['user_active'] = DepartmentConstant::USER_ACTIVE;

                    $mkt = User::search($search_user)->pluck('name', 'id');
                    $data['searchArrayUser'] = $mkt;
                } else {
                    $data['searchUser'] = $user->id;
                }
            }
        }

        $arr_fanpage_id = $this->fanpage->search($data)->pluck('page_id')->toArray();

        if (count($arr_fanpage_id)) {
            $search['searchPage_Post'] = $arr_fanpage_id;
            $search['searchUseSource'] = $request->searchUseSource == '1' ? true : false; //search có source hay k;
            $search['searchCustom'] = $request->searchCustom;
            $posts = $this->fanpage_post->index($search);
        } else {
            $posts = [];
        }


        if ($request->ajax()) {
            return view('backend.marketing.fanpage_post.ajax', compact('posts'));
        }
        return view('backend.marketing.fanpage_post.index', compact('posts', 'my_page'));
    }

    /**
     * Create source
     *
     * @param Request $request
     * @return int
     */
    public function store(Request $request)
    {
        $this->fanpage_post->create($request->all());
        return 1;
    }

    /**
     * Update source
     *
     * @param Request $request
     * @param $id
     * @return int
     */
    public function update(Request $request, $id)
    {
        $this->fanpage_post->update($request->all(), $id);
        return 1;
    }

    public function storeCustom(Request $request)
    {
        $page = Fanpage::where('id', $request->page_id)->where('used', StatusCode::ACTIVE)->first();
        if (isset($page)) {
            FanpagePost::create([
                'access_token' => $page->access_token,
                'page_id' => $page->page_id,
                'post_id' => $request->post_id,
                'title' => $request->title,
                'post_created' => Date::now()->format('Y-m-d H:i'),
                'used' => FanpageConstant::FANPAGE_POST_USED,
                'source_id' => $page->source_id
            ]);
            return back()->with('success', 'Thêm bài viết thành công !!!');
        } else {
            return back()->with('error', 'Fanpage chưa được sử dụng !!!');
        }

    }

}
