<?php

namespace App\Http\Controllers\backend;

use App\Constants\DepartmentConstant;
use App\Models\Fanpage;
use App\Models\Source;
use App\Models\TeamMember;
use App\Services\FanpageService;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FanpageController extends Controller
{
    private $fanpage;

    public function __construct(FanpageService $fanpage)
    {
        $this->fanpage = $fanpage;
        $source = Source::pluck('name', 'id')->toArray();
        view()->share([
            'source' => $source,
        ]);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function index(Request $request)
    {
        $data = $request;
        if ($request->searchPageId) {
            $data['searchPageId'] = $request->searchPageId;
        }
        if ($request->searchName) {
            $data['searchName'] = $request->searchName;
        }

        $user = Auth::user();
        if (in_array($user->department_id, [
                DepartmentConstant::CEO,
                DepartmentConstant::ADMIN,
            ]) || ($user->department_id == DepartmentConstant::MARKETING && $user->is_leader == DepartmentConstant::IS_LEADER)) {
        } else {
            if ($user->department_id == DepartmentConstant::MARKETING) {
                if (isset($user->teams) && count($user->teams)) {
                    $input['teamMember'] = $user->teams[0]->id;

                    $member = TeamMember::search($input)->pluck('user_id')->toArray();

                    $search_user['team_member'] = $member;
                    $search_user['user_active'] = DepartmentConstant::USER_ACTIVE;

                    $mkt = User::search($search_user)->pluck('id');

                    $data['arr_mkt_id'] = $mkt;
                } else {
                    $data['searchUser'] = $user->id;
                }
            }
        }

        $fanpages = $this->fanpage->index($data);

        if ($request->session()->has('login-facebook')) {
            $data_login_fb = $request->session()->get('login-facebook');
        } else {
            $data_login_fb = null;
        }
        if ($request->ajax()) {
            return view('backend.marketing.fanpage.ajax', compact('fanpages', 'data_login_fb'));
        }
        return view('backend.marketing.fanpage.index', compact('fanpages', 'data_login_fb'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $fanpage = $this->fanpage->update($request->all(), $id);
        return $fanpage;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function unsubscibedFanpage(){
        $arr_error = [];
        $fanpage = Fanpage::where('used',0)->get();
        foreach ($fanpage as $item){
            $page_id = $item->page_id;
            $token = $item->access_token;
            $result = self::unsub($page_id,$token);
            if($result != 1){
                $arr_error[] = $result;
            }
        }
        return 1;
    }

    public function unsub($page_id,$token){
        try {
            $client = new \GuzzleHttp\Client();
            $url = 'https://graph.facebook.com/v13.0/' . $page_id  . '/subscribed_apps?&access_token=' . $token;
            $client->request("DELETE", $url);
            return 1;
        } catch (Exception $e) {
            return $page_id;
        } finally {
            return $page_id;
        }
    }
}
