<?php

namespace App\Http\Controllers\Backend\Depot;

use App\Constants\OrderConstant;
use App\Constants\StatusConstant;
use App\Helpers\Functions;
use App\Models\Depot;
use App\Models\HistoryDepot;
use App\Models\HistoryTonkho;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\ProductCategory;
use App\Models\ProductDepot;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class StatisticalTonKhoController extends Controller
{
    public function index(Request $request)
    {
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }

        $date_now = date('Y/m/d H:i');
        $date_start = Functions::yearMonthDayTime($request->start_date);
        $date_end = Functions::yearMonthDayTime($request->end_date);

        $depots = Depot::select('name', 'id')->get();
        $search_depot = $request->depot_id;

        // Nếu ngày search không phải là ngày hiện tại thì tồn cuối là tồn đầu của ngày hôm sau
        if (strtotime($date_end) < strtotime($date_now)) {
            $date_ton_cuoi = date('Y-m-d', strtotime('+1day', strtotime($date_end)));
            $product_ton_cuoi = HistoryTonkho::whereDate('created_at', $date_ton_cuoi)->when(isset($search_depot),
                function ($q) use ($search_depot) {
                    $q->where('depot_id', $search_depot);
                })->select('current_quantity','product_id', DB::raw('sum(current_quantity) as total_current_quantity'))->groupBy('product_id');;
//            dd($product_ton_cuoi->get());
        } else { //tồn cuối là sản phẩm kho
            $product_ton_cuoi = ProductDepot::select('product_id', 'depot_id', 'quantity')->when(isset($search_depot),
                function ($q) use ($search_depot) {
                    $q->where('depot_id', $search_depot);
                });
        }


        $category = [];
        if ($product_ton_cuoi) {

            $history_depot = HistoryDepot::whereBetween('created_at', [$date_start, $date_end])->when(isset($search_depot), function ($q) use ($search_depot) {
                $q->where('depot_id', $search_depot);
            });

            $history_depot1 = clone $history_depot;
            $history_depot2 = clone $history_depot;
            $history_depot3 = clone $history_depot;

            $nhap_kho = $history_depot1->where('status', StatusConstant::NHAP_KHO)->select('quantity','product_id', DB::raw('sum(quantity) as total_quantity'))->groupBy('product_id');
            $xuat_kho = $history_depot2->where('status', StatusConstant::XUAT_KHO)->select('quantity','product_id', DB::raw('sum(quantity) as total_quantity'))->groupBy('product_id');
            $hang_hong = $history_depot3->where('status', StatusConstant::HONG_ROI)->select('quantity','product_id', DB::raw('sum(quantity) as total_quantity'))->groupBy('product_id');
//            dd($hang_hong->get());

            $hoan = Order::whereBetween('updated_at', [$date_start, $date_end])->where('status',
                OrderConstant::STATUS_HOAN_HUY)->when(isset($search_depot), function ($q) use ($search_depot) {
                $q->where('depot_id', $search_depot);
            })->pluck('id')->toArray();

            $hoan_detail = OrderDetail::select('order_id', 'product_id', 'quantity')->whereIn('order_id',
                $hoan)->get()->map(function ($detail) {
                $detail['depot_id'] = Order::find($detail->order_id)->depot_id;
                return $detail;
            });


            $history = HistoryTonkho::whereBetween('created_at', [$date_start, $date_end])
                ->when(isset($search_depot), function ($q) use ($search_depot) {
                    $q->where('depot_id', $search_depot);
                })->with('product')
                ->select('current_quantity','product_id', DB::raw('sum(current_quantity) as total_current_quantity'))->groupBy('product_id')
                ->get()->map(function ($his
                ) use ($product_ton_cuoi, $nhap_kho, $xuat_kho, $hang_hong, $hoan_detail) {
                    $his['category_id'] = $his->product->category_id;
                    $his['product'] = $his->product;
                    if (count($nhap_kho->get())) {
                        $nhap_kho_clone = clone $nhap_kho;
                        $nk = $nhap_kho_clone->where('product_id', $his->product_id)->get();
                        if ($nk) {
                            $his['nhap_kho'] = $nk->sum('total_quantity');
                        }
                    }
                    if (count($xuat_kho->get())) {
                        $xuat_kho_clone = clone $xuat_kho;
                        $xk = $xuat_kho_clone->where('product_id', $his->product_id)->get();
                        if ($xk) {
                            $his['xuat_kho'] = $xk->sum('total_quantity');
                        }
                    }
                    if (count($hang_hong->get())) {
                        $hang_hong_clone = clone $hang_hong;
                        $hh = $hang_hong_clone->where('product_id', $his->product_id)->get();
                        if ($hh) {
                            $his['hang_hong'] = $hh->sum('total_quantity');
                        }
                    }
                    if (count($hoan_detail)) {
                        $hoan_clone = clone $hoan_detail;
                        $his['hoan'] = $hoan_clone->where('product_id', $his->product_id)->sum('quantity');
                    }

                    $product_ton_cuoi_clone = clone $product_ton_cuoi;

                    $his['ton_cuoi'] = $product_ton_cuoi_clone->where('product_id',$his->product_id)->first()->total_current_quantity;
                    return $his;
                });
            $category = ProductCategory::orderBy('position', 'asc')->get()->map(function ($cate) use ($history) {
                $history_clone = clone $history;
                $cate['history'] = $history_clone->where('category_id', $cate->id);
                return $cate;
            });
        }
        if ($request->ajax()) {
            return view('backend.depot.ton_kho.ajax', compact('category'));
        }
        return view('backend.depot.ton_kho.index', compact('category', 'depots'));

    }
}
