<?php

namespace App\Http\Controllers\Backend\Depot;

use App\Constants\DepartmentConstant;
use App\Constants\HistoryConstant;
use App\Constants\OrderConstant;
use App\Constants\StatusCode;
use App\Constants\StatusConstant;
use App\Helpers\Functions;
use App\Models\Depot;
use App\Models\ExportImport;
use App\Models\HistoryDepot;
use App\Models\HistoryOperationDepot;
use App\Models\HistoryTonkho;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\OrderStatus;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\ProductDepot;
use App\Models\UserFilerGrid;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Date;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;

class DangDonController extends Controller
{
    public function __construct()
    {
        $depotUser = User::select('id', 'name')->where('department_id', DepartmentConstant::WAREHOUSE)->pluck('name', 'id')->toArray();
        View::share([
            'depotUser' => $depotUser
        ]);
    }

    /**
     * Đăng đơn
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $user = Auth::user();
        $order_status = OrderStatus::orderBy('position', 'asc')->get();
        $depots = Depot::select('id', 'name')->get();
        $sales = User::select('id', 'name', 'username')->where('department_id', DepartmentConstant::SALE)->get();
        $products = Product::all();

        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }

        $input = $request->all();
        $input2 = $request->except('order_status');
        $myDepartment = $user->department_id;
        if ($myDepartment == DepartmentConstant::WAREHOUSE) {
            if ($user->is_leader == DepartmentConstant::INACTIVE && $user->doi_soat == DepartmentConstant::INACTIVE) {
                $input['warehouse_id'] = $user->id;
                $input2['warehouse_id'] = $user->id;
            }
        }

        if ($request->phone) {
            if (isset($input['warehouse_id'])) {
                unset($input['warehouse_id'],$input2['warehouse_id']);
            }
            unset($input['start_date'], $input['end_date']);
        }

        if (empty($request->start_date) && empty($request->end_date)) {
            $input = [
                'start_date' => Carbon::now()->subDays(7)->format('d/m/Y H:i'),
                'end_date' => Carbon::now()->format('d/m/Y H:i'),
            ];
        }

        $input['orderDepot'] = true;
        $order_group = Order::search($input2)->select('id', 'status',
            DB::raw('count(*) as total'))->groupBy('status')->get()->pluck('total', 'status');

        $paginate = $request->customPage ?: StatusCode::PAGINATE_20;
        $orders = Order::search($input)->with('customer', 'orderStatus')->paginate($paginate);
        $active = !empty($input['order_status']) ? $input['order_status'] : 0;


        $url = '/depot/depot-tac-nghiep';
        $user_filter_grid = UserFilerGrid::select('fields')->where('user_id', $user->id)->where('url', $url)->first();
        if ($user_filter_grid) {
            $user_filter_grid = json_decode($user_filter_grid->fields);
        } else {
            $user_filter_grid = [
                "1",
                "2",
                "3",
                "4",
                "5",
                "6",
                "7",
                "8",
                "9",
                "10",
                "11",
                "12",
                "13",
                "14",
                "15",
                "16",
                "17",
                "18",
            ];
        }

        if ($request->ajax()) {
            return view('backend.depot.dang_don.ajax',
                compact('user_filter_grid', 'active', 'order_status', 'depots', 'sales', 'orders', 'products',
                    'order_group', 'paginate'));
        }
        return view('backend.depot.dang_don.index',
            compact('active', 'order_status', 'depots', 'sales', 'orders', 'products', 'order_group',
                'user_filter_grid'));
    }

    public function updateOrder(Request $request)
    {
        if ($request->has('data_update', 'data_status')) {
            $orders =  Order::whereIn('id', $request->data_update);
            $orders1 = clone $orders;
            $orders->update([
                'status' => $request->data_status,
            ]);
            $orders2 = $orders1->select('customer_id','warehouse_id','id')->get();
            $user= Auth::user();
            if(count($orders2)){
                foreach ($orders2 as $item){
                    $data1['warehouse_id'] = $item->warehouse_id;
                    $data1['order_id'] = $item->id;
                    $data1['user_id'] = $user->id;
                    $data1['status'] = $request->data_status;
                    HistoryOperationDepot::create($data1);
                }
            }


            return 1;
        }
        return 0;
    }

    public function updateOrderListCode(Request $request)
    {
        $abc = explode("\n", $request->data_status);

        $bcd = array_unique($abc);
        $data['count_order'] = count($bcd);
        if (count($bcd)) {
            $order = Order::whereIn('code', $bcd);

            $order1 = clone $order;
            $order2 = clone $order;
//            $order1 = $order1->pluck('customer_id')->toArray();

            $arr_code_done = $order2->pluck('code')->toArray();

            $arr_fail = [];
            foreach ($bcd as $item) {
                if (!in_array($item, $arr_code_done)) {
                    $arr_fail[] = $item;
                }
            }

            $data['count_order_done'] = count($arr_code_done);
            $data['count_order_fail'] = count($arr_fail);
            $data['order_fail'] = $arr_fail;

            $order->update([
                'status' => $request->data_update,
            ]);

//            Functions::checkCustomerOld($order1);
            $order2 = $order1->select('customer_id','warehouse_id','id')->get();
            $user = Auth::user();
            if(count($order2)){
                foreach ($order2 as $item){
                    $data1['warehouse_id'] = $item->warehouse_id;
                    $data1['order_id'] = $item->id;
                    $data1['user_id'] = $user->id;
                    $data1['status'] = $request->data_update;
                    HistoryOperationDepot::create($data1);
                }
            }

            return $data;
        }
        return 0;
    }

    public function updateOrderHoaHong(Request $request)
    {
        $abc = explode("\n", $request->data_code);

        $bcd = array_unique($abc);
        $data['count_order'] = count($bcd);
        if (count($bcd)) {
            $order = Order::whereIn('code', $bcd);
            $order2 = clone $order;
//            $order1 = $order1->pluck('customer_id')->toArray();

            $arr_code_done = $order2->pluck('code')->toArray();

            $arr_fail = [];
            foreach ($bcd as $item) {
                if (!in_array($item, $arr_code_done)) {
                    $arr_fail[] = $item;
                }
            }

            $data['count_order_done'] = count($arr_code_done);
            $data['count_order_fail'] = count($arr_fail);
            $data['order_fail'] = $arr_fail;

            $order->update([
                'hoa_hong' => $request->data_hoa_hong,
            ]);
            return $data;
        }
        return 0;
    }

    public function exportExcel(Request $request)
    {
        $input = $request->except('ids');
        $input['arr_ids'] = json_decode($request->ids);
        $type = HistoryConstant::TYPE_EXPORT;
        $data = HistoryConstant::DATA_DEPOT;

        $detail = json_encode(['arr_order_id' => $request->ids]);
        Functions::createHistory($type, $data, $detail);
        $data = Order::search($input)->with('orderDetails', 'customer', 'warehouse')->get();
        Excel::create('Đơn hàng (' . Date::now()->format('d-m-y') . ')', function ($excel) use ($data) {
            $excel->sheet('Data', function ($sheet) use ($data) {
                $sheet->cell('A1:V1', function ($row) {
                    $row->setBackground('#008686');
                    $row->setFontColor('#ffffff');
                });
                $sheet->freezeFirstRow();
                $sheet->row(1, [
                    'STT',
                    'Nguồn data',
                    'Mã đơn',
                    'ĐH Tên SP',
                    'ĐH Mã SP',
                    'KH Họ tên',
                    'KH Số ĐT',
                    'SP Số lượng',
                    'ĐH Đặt cọc',
                    'ĐH Chiết khấu',
                    'ĐH COD thu của khách',
                    'ĐH Tổng tiền',
                    'Kho Ghi chú',
                    'GH Ghi chú',
                    'GH Địa chỉ tổng hợp',
                    'GH Trạng thái',
                    'Đối soát',
                    'Kho phụ trách',
                    'Sale Ngày chốt đơn',
                    'Sale Tên',
                    'Sale ghi chú',
                    'MKT Tên',
                    'Vận chuyển'
                ]);

                $i = 1;
                if ($data) {
                    foreach ($data as $k => $ex) {
                        $i++;
//                        foreach ($ex->categories as $category) {
//                            $categoryName .= $category->name . ', ';
//                        }
                        $sheet->row($i, [
                            @$i,
                            @$ex->customer->source->name,
                            @$ex->code,
                            @$ex->product_space,
                            @$ex->product_code,
                            @$ex->customer_name . ($ex->is_upsale ? ' (Upsale)' : ''),
                            @$ex->customer->phone,
                            @$ex->quantity_text,
                            @$ex->advance_price,
                            @$ex->discount,
                            @$ex->ship_price,
                            @$ex->total,
                            @$ex->depot_note,
                            @$ex->description,
                            @$ex->address_text,
//                            @$ex->status . '/ghep trang thai',
                            @$ex->orderStatus->name,
                            @$ex->doi_soat == 1 ? 'Đã đối soát' : 'Chưa đối soát',
                            @$ex->warehouse->name,
                            @Functions::dayMonthYear($ex->ngay_chot_don),
                            @$ex->sale->name,
                            @$ex->sale_note,
                            @$ex->marketing->name,
                            @Order::getTextShip($ex->type_ship),
                            // (@$ex->type == 0) ? 'Tài khoản thường' : 'Tài khoản VIP',
                        ]);
                    }
                }
            });
        })->export('xlsx');
    }

    public function updateStatusGiaoHang(Request $request)
    {
        $order = Order::find($request->order_id);
        $order1 = clone $order;
        $input['status_new'] = !empty($request->status_new) ? $request->status_new : $order->status;
        $input['depot_note'] = !empty($request->note) ? $request->note : $order->depot_note;
        $input['type_ship'] = !empty($request->type_ship) ? $request->type_ship : $order->type_ship;
        $hoa_hong = $request->hoa_hong ? $request->hoa_hong : 0;
        $goi_dau = $request->goi_dau == 'true' ? 1 : 0;
        $order->update(['status' => $input['status_new'], 'depot_note' => $input['depot_note'], 'type_ship' => $input['type_ship'], 'hoa_hong' => $hoa_hong, 'goi_dau' => $goi_dau]);

        $user = Auth::user();

        $data['status'] = $input['status_new'];
        $data['note'] = $input['depot_note'];
        $data['type_ship'] = $input['type_ship'];
        $data['hoa_hong'] = $hoa_hong;

        $data['order_id'] = $request->order_id;
        $data['warehouse_id'] = $order->warehouse_id;
        $data['user_id'] = $user->id;

        if($data['status'] != $order1->status || $request->note != ''){
            HistoryOperationDepot::create($data);
        }
        return 1;

    }

    /**
     * @param Request $request ids (array order_id)
     * @return int
     */
    public function phanBoDonKho(Request $request)
    {
        $input['arr_ids'] = $request->ids;
        $user = Auth::user();
        $wh = User::find($request->warehouse_id)->username;
        if(count($request->ids)){
            foreach ($request->ids as $item){
                $order = Order::find($item);
                $user1 = User::find($order->warehouse_id);
                $data['warehouse_id'] = $request->warehouse_id;
                $data['order_id'] = $item;
                $data['user_id'] = $user->id;
                $data['type'] = 1;
                $data['note'] = $user1 ? $user1->username . ' -> ' . $wh : " ->". $wh;
                $data['status'] = $order->status;
                HistoryOperationDepot::create($data);
            }

            Order::whereIn('id', $input['arr_ids'])->update(['warehouse_id' => $request->warehouse_id]);
        }
        return 1;

    }

    /**
     * @param Request $request (order_id)
     * @return int
     */
    public function updateNote(Request $request)
    {
        $order = Order::find($request->order_id)->update(['depot_note'=>$request->note]);
        if($order){
            return 1;
        } return 0;
    }

    /**
     * @param $orders (array order_id)
     */
    public function createHistoryOperationDepot($orders,$data){
        if(count($orders)){
            foreach ($orders as $item){

            }
        }
    }


    public function tonKho(Request $request)
    {
        if (!$request->start_date) {
            Functions::addSearchDate($request);
        }

        $date_now = date('Y/m/d H:i');
        $date_start = Functions::yearMonthDayTime($request->start_date);
        $date_end = Functions::yearMonthDayTime($request->end_date);

        $depots = Depot::select('name', 'id')->get();
        $search_depot = $request->depot_id;

        // Nếu ngày search không phải là ngày hiện tại thì tồn cuối là tồn đầu của ngày hôm sau
        if (strtotime($date_end) < strtotime($date_now)) {
            $date_ton_cuoi = date('Y-m-d', strtotime('+1day', strtotime($date_end)));
            $product_ton_cuoi = HistoryTonkho::whereDate('created_at', $date_ton_cuoi)->when(isset($search_depot),
                function ($q) use ($search_depot) {
                    $q->where('depot_id', $search_depot);
                })->select('current_quantity','product_id', DB::raw('sum(current_quantity) as total_current_quantity'))->groupBy('product_id');

        } else { //tồn cuối là sản phẩm kho
            $product_ton_cuoi = ProductDepot::when(isset($search_depot),
                function ($q) use ($search_depot) {
                    $q->where('depot_id', $search_depot);
                })->select('product_id', 'depot_id', 'quantity',DB::raw('sum(quantity) as total_current_quantity'))->groupBy('product_id');
        }


        $category = [];
        if ($product_ton_cuoi) {

            $history_depot = HistoryDepot::whereBetween('created_at', [$date_start, $date_end])->when(isset($search_depot), function ($q) use ($search_depot) {
                $q->where('depot_id', $search_depot);
            });

            $history_depot1 = clone $history_depot;
            $history_depot2 = clone $history_depot;
            $history_depot3 = clone $history_depot;

            $nhap_kho = $history_depot1->where('status', StatusConstant::NHAP_KHO)->select('quantity','product_id', DB::raw('sum(quantity) as total_quantity'))->groupBy('product_id');
            $xuat_kho = $history_depot2->where('status', StatusConstant::XUAT_KHO)->select('quantity','product_id', DB::raw('sum(quantity) as total_quantity'))->groupBy('product_id');
            $hang_hong = $history_depot3->where('status', StatusConstant::HONG_ROI)->select('quantity','product_id', DB::raw('sum(quantity) as total_quantity'))->groupBy('product_id');

            $hoan = Order::whereBetween('updated_at', [$date_start, $date_end])->where('status',
                OrderConstant::STATUS_HOAN_HUY)->when(isset($search_depot), function ($q) use ($search_depot) {
                $q->where('depot_id', $search_depot);
            })->pluck('id')->toArray();

            $hoan_detail = OrderDetail::select('order_id', 'product_id', 'quantity')->whereIn('order_id',
                $hoan)->get()->map(function ($detail) {
                $detail['depot_id'] = Order::find($detail->order_id)->depot_id;
                return $detail;
            });


            $history = HistoryTonkho::whereDate('created_at', $date_start)
                ->when(isset($search_depot), function ($q) use ($search_depot) {
                    $q->where('depot_id', $search_depot);
                })->with('product')
                ->select('current_quantity','product_id', DB::raw('sum(current_quantity) as total_current_quantity'))->groupBy('product_id')
                ->get()->map(function ($his
                ) use ($product_ton_cuoi, $nhap_kho, $xuat_kho, $hang_hong, $hoan_detail) {
                    $his['category_id'] = $his->product->category_id;
                    $his['product'] = $his->product;
                    if (count($nhap_kho->get())) {
                        $nhap_kho_clone = clone $nhap_kho;
                        $nk = $nhap_kho_clone->where('product_id', $his->product_id)->get();
                        if ($nk) {
                            $his['nhap_kho'] = $nk->sum('total_quantity');
                        }
                    }
                    if (count($xuat_kho->get())) {
                        $xuat_kho_clone = clone $xuat_kho;
                        $xk = $xuat_kho_clone->where('product_id', $his->product_id)->get();
                        if ($xk) {
                            $his['xuat_kho'] = $xk->sum('total_quantity');
                        }
                    }
                    if (count($hang_hong->get())) {
                        $hang_hong_clone = clone $hang_hong;
                        $hh = $hang_hong_clone->where('product_id', $his->product_id)->get();
                        if ($hh) {
                            $his['hang_hong'] = $hh->sum('total_quantity');
                        }
                    }
                    if (count($hoan_detail)) {
                        $hoan_clone = clone $hoan_detail;
                        $his['hoan'] = $hoan_clone->where('product_id', $his->product_id)->sum('quantity');
                    }

                    $product_ton_cuoi_clone = clone $product_ton_cuoi;

                    $his['ton_cuoi'] = $product_ton_cuoi_clone->where('product_id',$his->product_id)->first()->total_current_quantity;
                    return $his;
                });
            $category = ProductCategory::orderBy('position', 'asc')->get()->map(function ($cate) use ($history) {
                $history_clone = clone $history;
                $cate['history'] = $history_clone->where('category_id', $cate->id);
                return $cate;
            });
        }
        if ($request->ajax()) {
            return view('backend.depot.ton_kho.ajax', compact('category'));
        }
        return view('backend.depot.ton_kho.index', compact('category', 'depots'));

    }
}
