<?php


namespace App\Http\Controllers\Backend;

use App\Constants\CustomerConstant;
use App\Constants\DepartmentConstant;
use App\Constants\OrderConstant;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\Customer;
use App\Models\CustomerStatus;
use App\Models\HistoryChangeStatus;
use App\Models\HistoryOperationDepot;
use App\Models\Order;
use App\Models\Source;
use App\Models\Team;
use App\Services\UserService;
use App\Http\Controllers\Controller;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CustomerController extends Controller
{

    public $user;

    public function __construct(UserService $user)
    {
        $this->user = $user;
    }

    /**
     * Store data customer to form
     *
     * @param Request $request
     * @param $id
     * @return string
     */
    public function clientData(Request $request, $id)
    {
        $input = $request->all();
        $source = Source::find($id);
        $accept = isset($source) && $source->accept ? $source->accept : 0;
        if (isset($source) && $accept == StatusCode::ACTIVE) {
            $arr_sale = json_decode($source->sale_id);

            $user_id = $arr_sale[$source->position];
            $new_position = 0;
            if ($source->position < count($arr_sale) - 1 && count($arr_sale) > 1) {
                $new_position = $source->position + 1;
            }
            $source->position = $new_position;
            $source->save();
            $input['source_id'] = $source->id;
            $input['user_id'] = $user_id;
            $input['status'] = StatusCode::ACTIVE;
            $input['mkt_id'] = $source->user_id;

            Customer::create($input);
        }
        $notify = json_decode($source->setting_form);
        $notify = $notify->notification ?: 'Đăng ký thành công !';
        return $notify;
    }

    public function changeStatus(Request $request)
    {
        $user = Auth::user();
        $customer = Customer::find($request->customer_id);
        $team = Team::where('leader_id',$user->id)->first();
        $check = $user->department_id == DepartmentConstant::SALE && $user->is_leader == 0 && !$team ? true : false;
        if($check && $user->id != $customer->user_id){
            return response()->json([
                'success' => false,
                'message' => 'Bạn không phụ trách khách này !'
            ]);
        }

        HistoryChangeStatus::create([
            'status_old' => $customer->status,
            'status_new' => $request->status_id,
            'note' => $customer->sale_note,
            'customer_id' => $customer->id,
            'user_id' => $user->id,
            'type' => 1
        ]);

        $data = Customer::timeExpired($request->status_id);
        $data['status'] = $request->status_id;
//        $data['expired_time_boolean'] = CustomerConstant::QUA_HAN;
        $customer->update($data);

        $arr = [];
        $child = CustomerStatus::find($request->status_id);
        array_push($arr,$child->id);
        if($child->customer_child){
            $arr_child = json_decode($child->customer_child);
            foreach ($arr_child as $item){
                $arr[] = $item;
            }
        }


        $arr = CustomerStatus::whereIn('id',$arr)->get();

        return response()->json([
            'success' => true,
            'arr_status_child' => $arr
        ]);
    }

    public function sendMessage(Request $request)
    {
        $user = Auth::user();

        if ($request->customer_id) {
            $customer = Customer::find($request->customer_id);
            $time = Carbon::now()->format('d-m-Y H:i:s');
            if ($customer->messages != "") {

                $arr = json_decode($customer->messages);

                $mess = ["username" => $user->username, "message" => $request->message, "time" => $time];

                array_unshift($arr, $mess);

            } else {
                $arr = [];
                $mess = ["username" => $user->username, "message" => $request->message, "time" => $time];
                array_push($arr, $mess);
            }

            $customer->update(['messages' => json_encode($arr)]);
            return $mess;
        } else {
            return 0;
        }
    }

    /**
     * Sale update note
     *
     * @param Request $request
     * @return int
     */
    public function saleNote(Request $request)
    {
        if ($request->customer_id != 0) {
            $customer = Customer::find($request->customer_id);
            $customer1 = clone  $customer;
            $data = Customer::timeExpired($customer->status);
            $data['expired_time_boolean'] = CustomerConstant::CHUA_QUA_HAN;
            $data['sale_note'] = $request->sale_note;
            $data['message'] = $request->message;
            $customer->update($data);

            $user = Auth::user();
            if($request->sale_note){
                $resp['expired_time_sale'] = Functions::getExpiredText($data['expired_time']);
                $resp['time_move_sale'] = Functions::getExpiredText($data['time_move_sale']);
                HistoryChangeStatus::create(['status_old'=>$customer1->status,'status_new'=>$customer1->status,'note'=>$request->sale_note,'customer_id'=>$request->customer_id,'user_id'=>$user->id]);
            };
            return isset($resp) ? $resp : 1;
        } else {
            return 0;
        }
    }

    /**
     * Sale update note not update tác nghiệp
     *
     * @param Request $request
     * @return int
     */
    public function saleNoteCustom(Request $request)
    {
        if ($request->customer_id) {
            $customer = Customer::find($request->customer_id);
            $data['sale_note'] = $request->sale_note;
            $customer->update($data);
            return 1;
        } else {
            return 0;
        }
    }

    /**
     * Sale update message
     *
     * @param Request $request
     * @return int
     */
    public function saveMessage(Request $request)
    {
        if ($request->customer_id != 0) {
            $customer = Customer::find($request->customer_id);
            $data['message'] = $request->message;
            $customer->update($data);
            return 1;
        } else {
            return 0;
        }
    }

    /**
     * get lịch sử trạng thái khách hàng
     *
     * @param Request $request
     * @return array
     */
    public function historyStatus(Request $request)
    {
        $customer = Customer::find($request->customer_id);
        $history_new = HistoryChangeStatus::where('customer_id',$request->customer_id)->with('status_old','status_new','user')->orderByDesc('created_at')->get();
        $arr_customer = Customer::where('phone',$customer->phone)->where('id','<>',$request->customer_id)->orderByDesc('id')->get();
        $data['history_new'] = $history_new;
        $data['arr_customer'] = $arr_customer;
        return $data;
    }


    public function getMessage($customer_id){
        $customer = Customer::find($customer_id);
        return $customer;
    }


    public function historyOperationDepot(Request $request)
    {
        $histories = HistoryOperationDepot::where('order_id',$request->order_id)->with('warehouse','customer','user','orderStatus')->orderByDesc('created_at')->get()
            ->map(function ($his){
                $his['type_ship_text'] = Order::getTextShip($his->type_ship);
                return $his;
            });
        return $histories;
    }
}
