<?php

namespace App\Http\Controllers\Backend\Accounting;

use App\Constants\DepartmentConstant;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Models\Depot;
use App\Models\Order;
use App\Models\OrderStatus;
use App\Models\Product;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class DoiSoatController extends Controller
{

//    private $depot;
//
//    public function __construct(ListDepotService $depot)
//    {
//        $this->depot = $depot;
//    }

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $order_status = OrderStatus::orderBy('position', 'asc')->get();
        $depots = Depot::all();
        $sales = User::where('department_id', DepartmentConstant::SALE)->get();
        $products = Product::all();
        if(!$request->start_date){
            Functions::addSearchDate($request);
        }
        $input = $request->all();
        if($request->phone){
            unset($input['start_date'],$input['end_date']);
        }
        if (empty($request->start_date) && empty($request->end_date)) {
            $input = [
                'start_date' => Carbon::now()->subDays(7)->format('d/m/Y H:i'),
                'end_date'   => Carbon::now()->format('d/m/Y H:i'),
            ];
        }

        $input['orderDepot'] = true; // get danh sách order kho, (status != 0, status != hủy );

        $active = !empty($input['status']) ? $input['status'] : 0;

        $input2 = $request->except('status');
        $order_group = Order::search($input2)->select('id', 'status',
            DB::raw('count(*) as total'))->groupBy('status')->get()->pluck('total', 'status');

        $paginate = $request->customPage ?: StatusCode::PAGINATE_20;
        $orders = Order::search($input)->paginate($paginate);


        if ($request->ajax()) {
//            view()->share([
//                'order_group' => $order_group,
//            ]);
            return view('backend.accounting.doi_soat.ajax',
                compact('orders', 'paginate', 'order_status','order_group','active'));
        }
        return view('backend.accounting.doi_soat.index',
            compact('order_status', 'depots', 'sales', 'orders', 'products', 'order_group','active'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int                      $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $abc = explode("\n", $request->data_update);
        if (count($abc)) {
            Order::whereIn('code', $abc)->update([
                'doi_soat' => $request->data_status,
            ]);
            return 1;
        }
        return 0;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
