<?php

namespace App\Http\Controllers\Auth;

use App\Constants\DepartmentConstant;
use App\Constants\StatusCode;
use App\Helpers\Functions;
use App\Http\Controllers\Controller;
use App\Models\HistoryLogin;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use Socialite;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/marketing/fanpage';

    protected function authenticated(Request $request, $user)
    {

        if ($user->status == StatusCode::ACTIVE) {
            $user = Auth::user();
            $value = isset($_COOKIE['user']) ? $_COOKIE['user'] : '';

            if ($user->pc_name == null) {
                if (!empty($value)) {
                    $user->update(['pc_name' => $value]);

                } else {
                    $value_has = $user->id . rand(10, 999);
                    setcookie("user", $value_has, 2147483647);
                    $user->update(['pc_name' => $value_has]);
                }
            } elseif ($user->pc_name && $user->pc_name != $value && $user->pc_name != '0') {
                self::logout($request);
                return redirect('/login')->with('message', 'Bạn đang đăng nhập ở trình duyệt khác !!!');
            }

            Auth::logoutOtherDevices($request->password);

            //history login
            try {
                if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                    $ip = $_SERVER['HTTP_CLIENT_IP'];
                } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                } else {
                    $ip = $_SERVER['REMOTE_ADDR'];
                }

                $data['user_id'] = $user->id;
                $data['ip_address'] = $ip;

                $details = json_decode(file_get_contents("https://ipinfo.io/{$ip}/json"));
                if (!empty($details)) {
                    $data['location'] = $details->city;
                } else {
                    $data['location'] = '';
                }
                HistoryLogin::create($data);
            } catch (Exception $e) {

            } finally {

                $password_default = Functions::getPasswordDefault();
                if ($request->password == $password_default) {
                    return redirect('/user-profile')->with('message', 'Vui lòng đổi mật khẩu mặc định !!!');
                }

                if (in_array($user->department_id, [DepartmentConstant::ADMIN, DepartmentConstant::CEO, DepartmentConstant::MARKETING])) {
                    return redirect()->route('marketing.fanpage.index');
                } elseif ($user->department_id == DepartmentConstant::SALE || $user->department_id == DepartmentConstant::CSKH) {
                    return redirect()->route('sale.operation.index');
                } elseif ($user->department_id == DepartmentConstant::WAREHOUSE) {
                    return redirect('/depot/depot-tac-nghiep');
                } elseif ($user->department_id == DepartmentConstant::WAREHOUSE) {
                    return redirect('/depot/depot-tac-nghiep');
                }
                else {
                    return redirect('accounting/doi-soat');
                }
            }

        } else {
            Auth::logout();
            return redirect('/login')->with('message', 'Tài khoản bị khóa. Vui lòng liên hệ ADMIN !!!');
        }


    }

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    /**
     * Get the login username to be used by the controller.
     *
     * @return string
     */
    public function username()
    {
        return 'username';
    }

    public function logout(Request $request)
    {
        $this->guard()->logout();
        $request->session()->invalidate();
        return 1;
    }
}
