<?php

namespace App\Http\Controllers\APIs;

use App\Constants\CustomerConstant;
use App\Constants\DepartmentConstant;
use App\Constants\SourceConstant;
use App\Constants\StatusCode;
use App\Models\Customer;
use App\Models\Source;
use App\Models\Team;
use App\Models\TeamMember;
use App\Services\Marketing\SourceService;
use App\Services\UserService;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Helpers\Functions;

class SourceController extends Controller
{
    private $source, $user;

    public function __construct(SourceService $source, UserService $user)
    {
        $this->source = $source;
        $this->user = $user;
    }

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     * @return void
     */
    public function index(Request $request)
    {
        $search['searchProduct'] = $request->searchProduct;
        $search['searchName'] = $request->searchName;
        $search['searchType'] = $request->searchType;
        $search['searchAccept'] = $request->searchAccept;

        $user = User::find($request->currentUser);
        $is_teamlead = count($user->teams) > 0 ? true : false;

        if ($user->department_id == DepartmentConstant::MARKETING && $user->is_leader != DepartmentConstant::IS_LEADER && !$is_teamlead) { //mkt thường
            $search['searchUser'] = $user->id;
        } else {
            if ($user->department_id == DepartmentConstant::ADMIN || $user->department_id == DepartmentConstant::CEO || ($user->department_id == DepartmentConstant::MARKETING && $user->is_leader == DepartmentConstant::IS_LEADER)) { // trưởng phòng,admin
                $search['searchUser'] = $request->searchUser;
            } else {
                if ($user->department_id == DepartmentConstant::MARKETING && $is_teamlead) { //team lead
                    $team = Team::where('leader_id', $user->id)->first();
                    $arr_user_team = TeamMember::where('team_id', $team->id)->pluck('user_id')->toArray();

                    $request->searchUser ? $search['searchUser'] = $request->searchUser : $search['searchArrayUser'] = $arr_user_team;
                }
            }
        }
        $source = $this->source->index($search);
        $page = $request->page;
        $source = Functions::customPaginate($source, $page);
        return response()->json([
            'statusCode' => StatusCode::OK,
            'data' => $source,
        ]);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $select_tat_ca_sale = "0";
        if (in_array($select_tat_ca_sale, $request->sale_id)) {
            $search['user_active'] = DepartmentConstant::USER_ACTIVE;
            $search['department_id'] = DepartmentConstant::SALE;
            $data['sale_id'] = User::search($search)->pluck('id')->map(function ($m) {
                return (string)$m;
            });
        } else {
            $data['sale_id'] = json_encode($request->sale_id);
        }

        $data['product_id'] = json_encode($request->product_id);

        $source = Source::create($data);
        if ($request->type == SourceConstant::TYPE_CONNECT_LADIPAGE) {
            $link = url('/api/Contact/ReceiveData/sc/' . $source->id);
            $source->update(['form_html' => $link]);
        }
        return response()->json(['statusCode' => StatusCode::OK]);

    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->except('user_id');
        $source = Source::find($id);

        $data['product_id'] = json_encode($request->product_id);

        $select_tat_ca_sale = "0";
        if (in_array($select_tat_ca_sale, $request->sale_id)) {
            $search['user_active'] = DepartmentConstant::USER_ACTIVE;
            $search['department_id'] = DepartmentConstant::SALE;
            $data['sale_id'] = User::search($search)->pluck('id')->map(function ($m) {
                return (string)$m;
            });
        } else {
            $data['sale_id'] = json_encode($request->sale_id);
        }
        $data['accept'] = 0;
        $source->update($data);
        return response()->json([
            'statusCode' => StatusCode::OK
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getAllMarketing(Request $request)
    {
        $search['searchDepartment'] = DepartmentConstant::MARKETING;
        $user = User::find($request->currentUser);
        $is_teamlead = count($user->teams) > 0 ? true : false;
        $user_mkt = [];

        if ($user->department_id == DepartmentConstant::MARKETING && $user->is_leader != DepartmentConstant::IS_LEADER && !$is_teamlead) { //mkt thường
            $user_mkt = [];
        } else {
            if ($user->department_id == DepartmentConstant::ADMIN || $user->department_id == DepartmentConstant::CEO || ($user->department_id == DepartmentConstant::MARKETING && $user->is_leader == DepartmentConstant::IS_LEADER)) { // trưởng phòng,admin
                $user_mkt = User::search($search)->get();
            } else {
                if ($user->department_id == DepartmentConstant::MARKETING && $is_teamlead) { //team lead
                    $team = Team::where('leader_id', $user->id)->first();
                    $arr_user_team = TeamMember::where('team_id', $team->id)->pluck('user_id')->toArray();
                    $search['team_member'] = $arr_user_team;
                    $user_mkt = User::search($search)->get();
                }
            }
        }


        return response()->json([
            'statusCode' => StatusCode::OK,
            'data' => $user_mkt
        ]);
    }

    public function updateAcceptSource(Request $request)
    {
        $data['accept'] = $request->value;
        $id = $request->id;
        $this->source->update($data, $id);
        return response()->json([
            'statusCode' => StatusCode::OK
        ]);
    }

    public function updateSettingSource(Request $request)
    {
        $data = $request->except('id');
        $this->source->update($data, $request->id);
        return response()->json([
            'statusCode' => StatusCode::OK
        ]);
    }

    public function storeCustomerLandipage(Request $request, $id)
    {
        try {
            $source = Source::find($id);
            $customer = Customer::where('phone', $request->phone)->orderByDesc('updated_at')->first();

            if (empty($source) || empty($source->accept)) {
                return response()->json([
                    'code' => 404,
                    'messages' => 'NOT FOUND SOURCE',
                ]);
            }
            if (empty($request->phone) || empty($request->name)) {
                return response()->json([
                    'code' => 400,
                    'messages' => 'NOT FOND PHONE OR NAME',
                ]);
            }
            $sales = json_decode($source->sale_id);

            $data = $request->only('name', 'phone', 'message');
            $data['mkt_id'] = $source->user_id;
            $data['source_id'] = $source->id;
            $data['status'] = 1;
            $data['user_id'] = $sales[$source->position];
            $data['expired_time_boolean'] = CustomerConstant::QUA_HAN;

            $date = date('Y-m-d H:i:s');
            if (!empty($customer)) {
                $data['duplicate'] = 1;
                $date_check = date('Y-m-d H:i:s', strtotime('+30day', strtotime($customer->updated_at)));
                if ($date <= $date_check && $id == $customer->source_id) {
                    return response()->json([
                        'code' => 401,
                        'messages' => 'Trùng số, trùng source trong 30 ngày !',
                    ]);

                } else {
                    $data['user_id'] = $customer->user_id;
                }
            } else {
                $position = $source->position < (count($sales) - 1) ? ($source->position + 1) : 0;
                $source->update(['position' => $position]);
            }

            Customer::create($data);
            return response()->json([
                'code' => 200,
                'messages' => 'SUCCESS',
            ]);

        } catch (\Exception $exception) {
            return response()->json([
                'code' => 401,
                'messages' => $exception->getMessage(),
            ]);
        }

    }
}
