<?php

namespace App\Helpers;

use App\Constants\CustomerConstant;
use App\Constants\OrderConstant;
use App\Constants\StatusCode;
use App\Models\Customer;
use App\Models\ExportImport;
use App\Models\HistoryPassword;
use App\Models\Order;
use App\Models\ProductDepot;
use App\Models\Team;
use App\Models\TeamMember;
use Exception;
use http\Env\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Date;
use nusoap_client;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Illuminate\Pagination\LengthAwarePaginator;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\Paginator;

class Functions
{
    /**
     * Random voucher
     *
     * @param length
     *
     * @return random String
     */
    public static function generateRandomString($length = 6)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    /**
     * check action trang thai khach hang in rules
     *
     * @param $config
     *
     * @return array
     */
    public static function checkRuleStatusCustomer($config)
    {
        return array_filter($config, function ($k) {
            return $k->type == 'actor' && $k->value == 'staff_customer';
        });
    }

    /**
     * replace variable to data
     *
     * @param $input
     * @param $text
     *
     * @return mixed
     */
    public static function replaceTextForUser($input, $text)
    {
        $text = str_replace('%full_name%', $input['full_name'], $text);
        $text = str_replace('%phone%', $input['phone'], $text);
        return $text;

    }


    /**
     * UploadImage
     *
     * @param UploadedFile $file
     * @param              $path
     * @param string $namevalidate
     *
     * @return null
     */
    public static function uploadImage(UploadedFile $file, $path, $namevalidate = 'img_file')
    {
        $destinationPath = public_path() . '/uploads/' . $path;
//        $thumbPath = public_path() . '/uploads/' . $path . '/thumb/';
        if (!is_dir($destinationPath)) {
            @mkdir($destinationPath, 0777, true);
            @copy(public_path() . '/uploads/index.html', $destinationPath . '/index.html');
            @copy(public_path() . '/uploads/.ignore', $destinationPath . ' /.gitignore');
        }
//        if (!is_dir($thumbPath)) {
//            @mkdir($thumbPath, 0777, true);
//            @copy(public_path() . '/uploads/index.html', $thumbPath . '/index.html');
//            @copy(public_path() . '/uploads/.ignore', $thumbPath . ' /.gitignore');
//        }
        $extension = $file->getClientOriginalExtension();
        if (in_array($extension, explode(',', 'jpg,jpeg,png,JPG,JPEG,PNG'))) {
            $filename = $file->getClientOriginalName();
            $picture = str_slug(substr($filename, 0, strrpos($filename, "."))) . '_' . time() . '.' . $extension;
            $image = $file->move($destinationPath, $picture);
            // if ($image) {
            //     $sourcePath = $image->getPath() . '/' . $image->getFilename();
            //     Thumbnail::generate_image_thumbnail($sourcePath, $thumbPath . $image->getFilename());
            //     return $image->getFileInfo()->getFilename();
            // }
            return $image->getFileInfo()->getFilename();
        } else {
            $error = \Illuminate\Validation\ValidationException::withMessages([
                $namevalidate => [
                    trans('validation . mimes',
                        ['attribute' => $namevalidate, 'values' => 'jpg,jpeg,png,JPG,JPEG,PNG']),
                ],
            ]);
            throw $error;
        }
    }

    public static function getImageModels($model, $path, $field = 'images', $index = 0)
    {
        $val = @$model->$field ?: null;
        if (is_array($val)) {
            $val = $val[$index];
        }
        if (empty($val) || !file_exists(public_path("uploads/$path/$val"))) {
            return asset('default/no-image.png');
        }
        $val = asset("uploads/$path/$val");
        return $val;
    }

    public static function unlinkUpload($path)
    {
        if (!empty($path)) {
            @unlink(public_path($path));
        }
    }


    public static function dayMonthYear($date)
    {
        return \Carbon\Carbon::parse($date)->format('d-m-Y H:i');
    }

    public static function yearMonthDay($date)
    {
        return Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d');
    }

    public static function yearMonthDayTime($date)
    {
        return Carbon::createFromFormat('d/m/Y H:i', $date)->format('Y-m-d H:i');
    }

    /**
     * SMS VMG BRANDNAME
     *
     * @param        $phone
     * @param        $sms_text
     * @param string $send_after
     *
     * @return int
     */
    public static function sendSmsV3($phone, $sms_text, $send_after = '')
    {
        $data = [
            'to' => $phone,
            'from' => "ROYAL SPA",
            'message' => $sms_text,
            'scheduled' => $send_after,//15-01-2019 16:05
            'requestId' => "",
            'useUnicode' => 0,//sử dụng có dấu hay k dấu
            'type' => 1 // CSKH hay QC
        ];
        $data = json_encode((object)$data);
        $base_url = 'http://api.brandsms.vn:8018/api/SMSBrandname/SendSMS';
        $token = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c24iOiJyb3lhbHNwYSIsInNpZCI6ImFmZTIxOWQ4LTdhM2UtNDA5MS05NjBmLThmZjViNGI4NzRhMiIsIm9idCI6IiIsIm9iaiI6IiIsIm5iZiI6MTU4OTM1NDE4MCwiZXhwIjoxNTg5MzU3NzgwLCJpYXQiOjE1ODkzNTQxODB9.Hx8r30IR1nqAkOClihx0n9upfvgOg1f-E3MwNEwWT-0';
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $base_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_HTTPHEADER => [
                "Content-Type: application/json",
                "token: $token",
            ],
        ]);
        $response = curl_exec($curl);
        curl_close($curl);
        $error_code = json_decode($response)->errorCode;
        if ($error_code == '000') {
            return 1;
        }
    }

    /**
     * SMS VIETTEL
     *
     * @param $phone
     * @param $sms_text
     *
     * @return int
     */
    public static function sendSmsBK($phone, $sms_text)
    {
        $client = new nusoap_client("http://203.190.170.43:9998/bulkapi?wsdl", 'wsdl', '', '', '', '');
        $client->soap_defencoding = 'UTF-8';
        $client->decode_utf8 = false;
        $err = $client->getError();
        if ($err) {
            echo '<h2>Test-Constructor error</h2><pre>' . $err . '</pre>';
        }
        $result = $client->call('wsCpMt',
            [
                'User' => 'smsbrand_royal_spa',
                'Password' => '123456a@',
                'CPCode' => 'ROYAL_SPA',
                'UserID' => $phone,
                'RequestID' => '1',
                'ReceiverID' => $phone,
                'ServiceID' => 'ROYAL-SPA',
                'CommandCode' => 'bulksms',
                'ContentType' => '0',
                'Content' => $sms_text,
            ], '', '', ''
        );

        $err = $client->getError();
        if (!$err) {
            return 1;
        }

    }

    /**
     * @param $token
     * @param $method
     * @param $uri
     * @param $field
     *
     * @return mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public static function getDataFaceBook($token, $method, $uri, $field)
    {
        $params = [
            'query' => [
                'access_token' => $token,
                'fields' => $field,
            ],
        ];

        try {
            $client = new \GuzzleHttp\Client();
            $res = $client->request($method, $uri, $params);

            if ($res->getStatusCode() == 200) { // 200 OK
                $response_data = $res->getBody()->getContents();
                $datas = json_decode($response_data)->data;
                return $datas;
            }
        } catch (Exception $e) {
            report($e);
            return [];
        }


    }

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     * @return LengthAwarePaginator
     */
    public static function customPaginate($items, $page = null, $perPage = StatusCode::PAGINATE_20, $options = [])
    {
        $page = $page ?: (Paginator::resolveCurrentPage() ?: 1);
        $items = $items instanceof Collection ? $items : Collection::make($items);
        return new LengthAwarePaginator($items->forPage($page, $perPage), $items->count(), $perPage, $page, $options);
    }

    /**
     * Update số lượng sp trong kho
     *
     * @param $depot_id
     * @param $type
     * @param $order_id
     */
    public static function updateQuantityDepot($depot_id, $type, $order_id)
    {
        $order = Order::where('id', $order_id)->with('orderDetails')->first();
        foreach ($order->orderDetails as $item) {
            $product_depot = ProductDepot::where('depot_id', $depot_id)->where('product_id',
                $item->product_id)->first();
            if ($type == OrderConstant::TYPE_TRU_SL_KHO) {
                $quantity = $product_depot->quantity - $item->quantity;
            } else {
                $quantity = $product_depot->quantity + $item->quantity;
            }
            $product_depot->update(['quantity' => $quantity]);
        }
    }

    public static function createHistory($type, $data, $detail = '')
    {
        $data_create['user_id'] = Auth::user()->id;
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $data_create['ip_address'] = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $data_create['ip_address'] = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $data_create['ip_address'] = $_SERVER['REMOTE_ADDR'];
        }
        $data_create['type'] = $type;
        $data_create['data'] = $data;
        $data_create['detail'] = $detail;
        ExportImport::create($data_create);
    }

    /**
     * Check update khách cũ mới
     * @param $customerId
     */
    public static function checkCustomerOld($customerId)
    {
        if (gettype($customerId) == 'array') {
            foreach ($customerId as $item) {
                $count_order = Order::where('customer_id', $item)->whereNotIn('status', OrderConstant::STATUS_DON_HOAN_HUY)->get()->count();
                if ($count_order > 1) {
                    Customer::find($item)->update(['customer_old' => CustomerConstant::IS_KHACH_CU]);
                } else {
                    Customer::find($item)->update(['customer_old' => CustomerConstant::IS_KHACH_MOI]);
                }
            }
        } else {
            $count_order = Order::where('customer_id', $customerId)->whereNotIn('status', OrderConstant::STATUS_DON_HOAN_HUY)->get()->count();
            if ($count_order > 1) {
                Customer::find($customerId)->update(['customer_old' => CustomerConstant::IS_KHACH_CU]);
            } else {
                Customer::find($customerId)->update(['customer_old' => CustomerConstant::IS_KHACH_MOI]);
            }
        };
    }

    public static function getExpiredText($date)
    {
        $now = Date::now()->format('Y-m-d H:i:s');

        if (!empty($date)) {
            $countdown = strtotime($date) - strtotime($now);
            $days = ($countdown / 86400) >= 1 ? floor($countdown / 86400) : 0;
            $hours = floor(($countdown % 86400) / 3600);
            $minutes = round((($countdown % 86400) % 3600) / 60);
            return ($days > 0 ? $days . ' ngày &nbsp;' : '') . ($hours > 0 ? $hours . ' giờ &nbsp;' : '') . ($minutes > 0 && $days < 1 ? $minutes . ' phút' : '');
        }
        return '';
    }

    public static function addSearchDate($request)
    {
//        $date = date('Y/m/d H:i');
//        $date_check = date('Y/m/d H:i', strtotime('-30day', strtotime($date)));
//        $date = Carbon::createFromFormat('Y/m/d H:i', $date)->format('d/m/Y H:i');
//        $date_check = Carbon::createFromFormat('Y/m/d H:i', $date_check)->format('d/m/Y H:i');
//        $date_check = Carbon::now()->startOfWeek()->format('d/m/Y H:i');
//        $date = Carbon::now()->endOfWeek()->format('d/m/Y H:i');
        $date_check = Carbon::now()->subDays(7)->format('d/m/Y');
        $date = Carbon::now()->format('d/m/Y');


        $request->merge(['end_date' => $date.' 23:59']);
        $request->merge(['start_date' => $date_check.' 00:00']);
    }

    public static function getPasswordDefault()
    {
        $history = HistoryPassword::orderByDesc('id')->first();
        return $history ? $history->password_new : 'Adam123456';
    }

    /**
     * lấy ra người phụ trách đơn
     *
     * @param $user_id
     * @return int
     */
    public static function checkWareHouse($user_id)
    {
        $team_member = TeamMember::select('team_id')->where('user_id', $user_id)->first();
        if (empty($team_member)) {
            return 0;
        }
        $team_id = $team_member->team_id;
        $team = Team::find($team_id);
        if (!empty($team)) {
            return $team->depot_id;
        } else {
            return 0;
        }

    }
}
