<?php

namespace App\Console\Commands;

use App\Constants\CustomerConstant;
use App\Constants\DepartmentConstant;
use App\Models\Customer;
use App\Models\Team;
use Illuminate\Console\Command;

class MoveCustomerToCSKH extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'move_customer_cskh:search';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $date = date('Y-m-d H:i:s');

        $customers = Customer::where('expired_time_boolean',CustomerConstant::MOVE_TRUONG_PHONG)->where('time_move_cskh', '<=', $date);

        $teamlead = Team::where('department_id',DepartmentConstant::CSKH)->first();
        if($teamlead){
            $leader_id = $teamlead->leader_id;
            $customers->update(['user_id'=>$leader_id,'time_move_cskh'=>NULL]);
        }

        return 2;
    }
}
