<?php

namespace App\Console\Commands;

use App\Constants\CustomerConstant;
use App\Constants\DepartmentConstant;
use App\Models\Customer;
use App\Models\CustomerStatus;
use App\Models\HistoryChangeStatus;
use App\Models\Team;
use App\User;
use Illuminate\Console\Command;

class MoveCustomer extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'move_customer:search';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $search['expired_time_boolean'] = [CustomerConstant::QUA_HAN];
        $search['date_check_move'] = date('Y-m-d H:i:s');
        $customers = Customer::search($search);
        $customers1 = clone $customers;

        $arr_customer = $customers1->pluck('id')->toArray();
        $arr_sale = $customers1->pluck('user_id')->toArray();
        $arr_status_customer = $customers1->pluck('status')->toArray();

//        $leader_id = Team::where('department_id',DepartmentConstant::CSKH)->first()->leader_id;
        $id_truong_phong = User::where('department_id',DepartmentConstant::SALE)->where('is_leader',DepartmentConstant::IS_LEADER)->first();
        $id_truong_phong = $id_truong_phong ? $id_truong_phong->id : 1;

        $date = date('Y-m-d H:i:s');

        foreach ($arr_customer as $key=>$item){
            $curent_user = User::where('id',$arr_sale[$key])->with('teamMember')->first();
            if(isset($curent_user->teamMember) && $curent_user->teamMember){
                $leader_id = Team::find($curent_user->teamMember->team_id)->leader_id;
            } else {
                $leader_id = $id_truong_phong;
            };

            HistoryChangeStatus::create([
                'status_old'=>$arr_status_customer[$key],
                'status_new'=>$arr_status_customer[$key],
                'note'=>'<span style="color:red">Quá hạn chuyển về trưởng phòng</span>',
                'customer_id'=> $arr_customer[$key],
                'user_id' => $arr_sale[$key],
                'type' => 1
            ]);

            $customer_update = Customer::find($item);
            $time = CustomerStatus::find($customer_update->status)->time_move_cskh;
            if($time>0){
                $customer_update->update([
                    'expired_time_boolean'=>CustomerConstant::MOVE_TRUONG_PHONG,
                    'time_move_sale'=>null,
                    'time_move_cskh' => date('Y-m-d H:i:s', strtotime('+'.$time.'minute', strtotime($date))),
                    'user_id'=> $leader_id
                ]);
            } else {
                $customer_update->update([
                    'expired_time_boolean'=>CustomerConstant::MOVE_TRUONG_PHONG,
                    'time_move_sale'=>null,
                    'user_id'=> $leader_id
                ]);
            }

        }

        return 2;
    }
}
