<?php

namespace App\Console\Commands;

use App\Constants\CustomerConstant;
use App\Constants\DepartmentConstant;
use App\Helpers\Functions;
use App\Models\Customer;
use App\Models\HistoryChangeStatus;
use App\Models\Order;
use App\Models\Team;
use App\User;
use Illuminate\Console\Command;

class FindDB extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'find:db';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
//        $arr95 = [12, 13, 14, 17, 18, 84, 85, 86, 87, 88, 94, 91, 99, 100, 116, 117, 139, 140, 141, 142, 160];
//        $arr96 = [143, 144, 145, 150, 154, 158, 166, 92, 103, 104, 108, 118, 128, 129, 130, 131, 168];
//        $arr97 = [90, 105, 106, 122, 123, 124, 125, 126, 127, 155, 156, 89, 101, 102, 132, 133, 134, 135, 136, 137, 162, 163];
//        Order::whereIn('sale_id', $arr95)->update(['warehouse_id' => 95]);
//        Order::whereIn('sale_id', $arr96)->update(['warehouse_id' => 96]);
//        Order::whereIn('sale_id', $arr97)->update(['warehouse_id' => 97]);

        $orders = Order::select('customer_id', \DB::raw('MAX(id) as max_id'), \DB::raw('COUNT(id) as count'))
            ->whereBetween('ngay_chot_don', [
                Functions::yearMonthDayTime('01/07/2021 00:00'),
                Functions::yearMonthDayTime('31/07/2021 23:59'),
            ])->groupBy('customer_id')->get()->toArray();
        foreach (array_chunk($orders, 300) as $item) {
            foreach ($item as $i) {
                if ($i['count'] > 1) {
                    Order::where('id', $i['max_id'])->update(['is_upsale' => 1]);
                }
            }

        }


    }
}
