<?php

namespace App\Console\Commands;

use App\Constants\CustomerConstant;
use App\Models\Customer;
use App\Models\HistoryTonkho;
use App\Models\ProductDepot;
use Carbon\Carbon;
use Illuminate\Console\Command;

class CheckTonKho extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'check:tonkho';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check tồn đầu';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $product = ProductDepot::select('depot_id', 'product_id', 'quantity')->groupBy('depot_id')->groupBy('product_id')->get()->map(function ($item) {
            $item->current_quantity = $item->quantity;
            $item->created_at = Carbon::now();
            unset($item->quantity);
            return $item;
        })->toArray();
        HistoryTonkho::insert($product);
        return 1;
    }
}
