<?php $__env->startSection('content'); ?>
    <div class="col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?php echo e($title); ?></h3></br>
            </div>

            <?php if(isset($doc)): ?>
                <?php echo Form::model($doc, array('url' => url('department/'.$doc->id), 'method' => 'put', 'files'=> true,'id'=>'fvalidate')); ?>

            <?php else: ?>
                <?php echo Form::open(array('url' => route('department.store'), 'method' => 'post', 'files'=> true,'id'=>'fvalidate')); ?>

            <?php endif; ?>
            <div class="col row">
                <div class="col-xs-12 col-md-6">
                    <div class="form-group required <?php echo e($errors->has('name') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('name', 'Tên phòng ban', array('class' => ' required')); ?>

                        <?php echo Form::text('name',null, array('class' => 'form-control', 'required' => true)); ?>

                        <span class="help-block"><?php echo e($errors->first('name', ':message')); ?></span>
                    </div>
                </div>
                    <div class="col-xs-12 col-md-6">
                        <div class="form-group <?php echo e($errors->has('parent_id') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('parent_id','Trực thuộc', array('class' => 'required')); ?>

                            <select class="form-control select2" name="parent_id" data-placeholder="Danh mục cấp cao nhất">
                                <option></option>
                                <?php echo $departments; ?>

                            </select>
                        </div>
                    </div>
            </div>
            <div class="col row">
                <div class="col-xs-12 col-md-6">
                    <div class="form-group <?php echo e($errors->has('parent_id') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('description','Mô tả', array('class' => 'required')); ?>

                        <?php echo Form::textArea('description',null, array('class' => 'form-control')); ?>

                        <span class="help-block"><?php echo e($errors->first('parent_id', ':message')); ?></span>
                    </div>
                </div>
            </div>
            <div class="col bot">
                <button type="submit" class="btn btn-success">Lưu</button>
                <a href="<?php echo e(route('department.index')); ?>" class="btn btn-danger">Về danh sách</a>
            </div>
            <?php echo e(Form::close()); ?>


        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('_script'); ?>
    <script>
        $(document).ready(function () {
            $('form#fvalidate').validate({
                rules: {
                    name: 'required',
                },
                messages: {
                    name: "vui lòng nhâp tên danh mục",
                }
            });
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Spa/resources/views/department/_form.blade.php ENDPATH**/ ?>