<div id="myKanban"></div>
<script src="<?php echo e(asset('assets/plugins/kanban-board/jkanban.min.js')); ?>"></script>
<script>
    var KanbanTest = new jKanban({
        element: '#myKanban',
        gutter: '10px',
        click: function (el) {
            // alert(el.innerHTML);
            // alert(el.dataset.eid)
            $.ajax({
                url: '/ajax/tasks/' + el.dataset.eid,
                method: 'GET',
                success: function (data) {
                    let abc = data.description.replaceAll("--", '\n');
                    let link = '/customers/'+data.customer.id;
                    console.log(link,'link');
                    $('#name').val(data.name).change();
                    $("a[href]").attr("href",link);
                    $('.name-customer').html(data.customer.full_name).change();
                    $('.phone-customer').val(data.customer.phone).change();
                    $('#user_id').val(data.user.full_name).change();
                    $('#date_from').val(data.date_from).change();
                    $('#time_from').val(data.time_from).change();
                    $('#time_to').val(data.time_to).change();
                    $('#description').html(abc).change();
                    $('#myModal').modal('show');
                }
            })
        },
        dropEl: function (el, target, source, sibling) {
            KanbanTest.options.boards.map(function (board) {
                if (board.id === $(source.parentElement).data("id")) {
                    let status = board.id == "_todo" ? 3 : (board.id == "_done" ? 2 : 3)
                    $.ajax({
                        url: '/ajax/tasks/' + el.dataset.eid,
                        method: 'PUT',
                        data: {task_status_id: status},
                        success: function (data) {
                        }
                    })
                }
                ;
            });

        },
        boards: [
            {
                'id': '_todo',
                'dragTo': ['_done'],
                'title': 'Công việc',
                'class': 'info',
                'item': [
                    <?php if(count($new)): ?>
                        <?php $__currentLoopData = $new; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        'id': '<?php echo e($item->id); ?>',
                        'title': '<img class="img-card" src="<?php echo e(isset($item->user)?@$item->user->avatar:"/assets/images/brand/logo.png"); ?>"> <?php echo e($item->name); ?>',

                    },
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                ]
            },
            {
                'id': '_done',
                'dragTo': ['_fail'],
                'title': 'Hoàn thành',
                'class': 'success',
                'item': [
                    <?php if(count($done)): ?>
                    <?php $__currentLoopData = $done; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        'id': '<?php echo e($item->id); ?>',
                        'title': '<img class="img-card" src="<?php echo e(isset($item->user)?@$item->user->avatar:"/assets/images/brand/logo.png"); ?>"> <?php echo e($item->name); ?>',

                    },
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php endif; ?>
                ]
            },
            {
                'id': '_fail',
                'dragTo': ['_done'],
                'title': 'Quá hạn',
                'class': 'error',
                'item': [
                    <?php if(count($fail)): ?>
                    <?php $__currentLoopData = $fail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        {
                            'id': '<?php echo e($item->id); ?>',
                            'title': '<img class="img-card" src="<?php echo e(isset($item->user)?@$item->user->avatar:"/assets/images/brand/logo.png"); ?>"> <?php echo e($item->name); ?>',

                        },
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php endif; ?>
                ]
            }
        ]
    });
</script>
<?php /**PATH /var/www/html/Spa/resources/views/kanban_board/ajax.blade.php ENDPATH**/ ?>