<?php $__env->startSection('content'); ?>
    <div class="col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?php echo e($title); ?></h3></br>
            </div>

            <?php if(isset($task)): ?>
                <?php echo Form::model($task, array('url' => url('tasks/'.$task->id), 'method' => 'put', 'files'=> true,'id'=>'fvalidate')); ?>

            <?php else: ?>
                <?php echo Form::open(array('url' => route('tasks.store'), 'method' => 'post', 'files'=> true,'id'=>'fvalidate')); ?>

            <?php endif; ?>
            <div class="modal-body">
                <div class="col row">
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('name') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('name', 'Tên công việc', array('class' => ' required')); ?>

                            <?php echo Form::text('name', null, array('class' => 'form-control', 'required' => true)); ?>

                            <span class="help-block"><?php echo e($errors->first('name', ':message')); ?></span>
                        </div>
                    </div>
                </div>
                <div class="col row">
                    <div class="col-xs-12 col-md-4">
                        <div class="form-group required <?php echo e($errors->has('type') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('type', 'Loại công việc', array('class' => ' required')); ?>

                            <?php echo Form::select('type', $type, null, array('class' => 'form-control select2','placeholder'=>'Loại công việc', 'required' => true)); ?>

                            <span class="help-block"><?php echo e($errors->first('type', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-4">
                        <div class="form-group required <?php echo e($errors->has('date_from') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('date_from', 'Ngày hẹn(Từ)', array('class' => ' required')); ?>

                            <?php echo Form::text('date_from', null, array('class' => 'form-control','id'=>'update_date', 'data-toggle' => 'datepicker')); ?>

                            <span class="help-block"><?php echo e($errors->first('date_from', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-md-2 col-xs-12 clockpicker" data-placement="left"
                         data-align="top"
                         data-autoclose="true">
                        <?php echo Form::label('time_from', 'Giờ hẹn ( Từ)', array('class' => ' required')); ?>

                        <?php echo Form::text('time_from', null, array('class' => 'form-control','id'=>'update_time1')); ?>

                    </div>
                    <div class="col-md-2 col-xs-12 clockpicker" data-placement="left"
                         data-align="top"
                         data-autoclose="true">
                        <?php echo Form::label('time_to', 'Giờ hẹn (Tới)', array('class' => ' required')); ?>

                        <?php echo Form::text('time_to', null, array('class' => 'form-control','id'=>'update_time2')); ?>

                    </div>
                </div>
                <div class="col row">

                </div>
                <div class="col row">
                    <div class="col-md-12 col-xs-12">
                        <?php echo Form::label('description', 'Nội dung', array('class' => ' required')); ?>

                        <?php echo Form::textarea('description', null, array('class' => 'form-control', 'rows' => 6)); ?>

                    </div>
                </div>
                
                
                
                
                
                <div class="col row">
                    <div class="col-xs-12 col-md-3">
                        <div class="form-group required <?php echo e($errors->has('user_id') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('user_id', 'Người thực hiện', array('class' => ' required')); ?>

                            <?php echo Form::select('user_id', $users2, null, array('class' => 'form-control select2', 'required' => true, 'placeholder'=>'Người thực hiện',)); ?>

                            <span class="help-block"><?php echo e($errors->first('user_id', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-6">
                        <div class="form-group required <?php echo e($errors->has('user_id2') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('users', 'Người tham gia', array('class' => ' required')); ?>

                            <?php if(isset($task)): ?>
                                <select class="form-control select2" name="user_id2[]" multiple="multiple"
                                        data-placeholder="Chọn người tham gia">
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e($item->id); ?>" <?php echo e(isset($task) && in_array($item->id, $user) ? 'selected' : ""); ?>><?php echo e($item->full_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            <?php endif; ?>
                            <span class="help-block"><?php echo e($errors->first('user_id2', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-3">
                        <div class="form-group required">
                            <?php echo Form::label('task_status_id', 'Trạng thái', array('class' => ' required')); ?>

                            
                            <?php echo Form::select('task_status_id',$status, null, array('class' => 'form-control select2','id'=>'update_status')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal footer -->
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">Lưu</button>
            </div>

        </div>
        <?php echo e(Form::close()); ?>


    </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('_script'); ?>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css"
          integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T"
          crossorigin="anonymous">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap-clockpicker.min.css')); ?>">
    <script src="<?php echo e(asset('assets/js/bootstrap-clockpicker.min.js')); ?>"></script>
    <script>
        $('document').ready(function () {
            $('.clockpicker').clockpicker();
        });
        $('[data-toggle="datepicker"]').datepicker({
            format: 'dd-mm-yyyy',
            autoHide: true,
            zIndex: 2048,
        });
        var status = $('#update_status').val();
        if (status != 1) {
            $('#update_status').attr('disabled', true)
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Spa/resources/views/tasks/_form-edit.blade.php ENDPATH**/ ?>