<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel='shortcut icon' type='image/x-icon' href='/laningpage/frontend/Icon/favicon.ico'/>
    <title>Royal Spa</title>
    <!-- Begin Builder -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        .error {
            color: #fff;
        }
    </style>

<!-- End Builder -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('laningpage/frontend/css/main.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('laningpage/frontend/css/drawer.min.css')); ?>">
    <style>
        @media (max-width: 768px) {

            .contents img {
                width: 100% !important;
            }

            .add {
                height: 30px;
            }
        }

        @media (min-width: 992px) {
            .news-events .list-news .news-item .image-news-container .image-news {
                width: 12em;
            }
        }

        button.btn.button-container.book-appointment-container:focus {
            outline: none;
        }

    </style>
</head>

<body>
<header class="header">
    <div class="container">
        <ul class="navigation-tool">
            <li class="navigation-item header-logo">
                <a href="#">
                    <h1><img class="navigation-logo" src="/laningpage/frontend/Icon/logo.png" alt="royal spa logo"></h1>
                </a>
            </li>
            <li class="navigation-item">
                <a class="navigation-link" href="#">
                    <img class="navigation-image" src="/laningpage/frontend/Icon/gioithieu.png"
                         alt="royal icon introduce"/>
                    <p>Giới thiệu</p>
                </a>
            </li>
            <li class="navigation-item dropdown">
                <button class="btn navigation-link" id="dLabel" type="button" data-toggle="dropdown"
                        aria-haspopup="true"
                        aria-expanded="false">
                    <img class="navigation-image" src="/laningpage/frontend/Icon/dichvu.png" alt="royal icon calendar"/>
                    Dịch vụ
                </button>
                
                
                
                
                
            </li>
            <li class="navigation-item">
                <a class="navigation-link" href="#">
                    <img class="navigation-image" src="/laningpage/frontend/Icon/datlich.png"
                         alt="royal icon calendar"/>
                    <p>Đặt lịch</p>
                </a>
            </li>
            <li class="navigation-item">
                <a class="navigation-link" href="#">
                    <img class="navigation-image" src="/laningpage/frontend/Icon/tintuc.png" alt="royal icon info"/>
                    <p>Tin Tức</p>
                </a>
            </li>
            <li class="navigation-item">
                <a class="navigation-link" href="#">
                    <img class="navigation-image edu" src="/laningpage/frontend/Icon/daotao.png"
                         alt="royal icon educate"/>
                    <p>Đào tạo</p>
                </a>
            </li>
            <li class="navigation-item-more">
                <a class="navigation-more-link" href="tel:<?php echo e($post->phone); ?>">Liên Hệ</a>
                <a class="navigation-button-container" href="#dang-ky">
                    <button class="navigation-button btn-royal">
                        <p class="navigation-button-content">Đăng ký tư vấn</p>
                    </button>
                </a>
            </li>
        </ul>
    </div>
</header>

<!-- header mobile, tablet -->

    
        
            
                
            
        
        
    
    
        
            
            
        
        
            
                
                    
                        
                             
                        
                    
                
                
                    
                            
                        
                             
                        
                    
                    
                        
                            
                            
                            
                        
                    
                
                
                    
                        
                             
                        
                    
                
                
                    
                        
                        
                    
                
                
                    
                        
                        
                    
                
            
        
    


<div class="container">
    <div class="row">
        <section class="contents col-md-12 col-sm-12">
            <h2 class="content-title"><?php echo e(@$post->title); ?></h2>
            <?php echo @$post->content; ?>

        </section>
    </div>
</div>
<section class="register">
    <div class="container">
        <div class="row register-container">
            
                
                    
                                     
                                     
                    
                        
                    
                        
                
            
            
                
                     
            
            <div class="col-12 col-md-5 register-form-container" id="dang-ky">
                <div class="add"></div>
                <form id="my_Form" class="register-form" method="post" action="">
                    <h2 class="register-title" data-key="customer-432">ĐĂNG KÝ NHẬN QUÀ</h2>
                    <input class="register-input" type="text" name="full_name" placeholder="Họ tên khách hàng"
                           required/>
                    <input class="register-input" type="text" name="phone" placeholder="Số điện thoại" required/>
                    <input class="register-input" type="text" name="note" placeholder="Dịch vụ cần tư vấn thêm"/>
                    <input class="register-input" type="hidden" name="slug" value="<?php echo e(request()->segment(2)); ?>"/>
                    <input id="js-register-button" class="register-button-submit btn-royal" type="submit"
                           value="NHẬN QUÀ NGAY"/>
                </form>
            </div>
        </div>
    </div>
</section>


<!-- modal -->

















<!-- contact buttons -->

    
        
        
        
            
            
        
    
    
        
        
    
    
        
             
        
    

<!-- modal register -->
<div class="modal fade" id="register" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-layout modal-register">
        <!--Modal content-->
        <div class="modal-content modal-container">
            <h3 class="home-modal-title" data-key="model-2">Nhập số điện thoại để được Viện thẩm mỹ Royal gọi lại
                ngay</h3>
            <input type="text" class="modal-input" name="phone" placeholder="Số điện thoại quý khách"/>
            <select class="form-control select-local" name="province">
                <option>Hà Nội</option>
                <option>Thành Phố Bắc Giang</option>
                <option>Thành Phố Bắc Ninh</option>
                <option>Hải Phòng</option>
                <option>Thành Phố Hồ Chí Minh</option>
                <option>Vĩnh Phúc</option>
                <option>Thành Phố Thái Nguyên</option>
            </select>
            <button id="js-register-popup-button" type="button" class="register-button-submit btn-royal"
                    data-dismiss="modal">Đăng ký tư vấn
            </button>
        </div>
    </div>
</div>

<script>
    function openMessenger() {
        document.getElementById('open-messenger').click();
    }
</script>

<footer>
    <div class="container">
        
            
                
                
                
                
                    
                         
                         
                         
                        
                                    
                            
                        
                    
                
            
            
                
                
                    
                    
                        
                             
                        
                    
                    
                        
                             
                        
                    
                
                
                    
                    
                        
                             
                        
                    
                    
                        
                             
                        
                    
                
                
                    
                    
                        
                             
                        
                    
                    
                        
                             
                        
                    
                
            
            
                
                    
                    
                        
                             
                        
                    
                    
                        
                             
                        
                    
                
                
                    
                    
                        
                             
                        
                    
                    
                        
                             
                        
                    
                
                
                    
                    
                        
                             
                        
                    
                    
                        
                             
                        
                    
                
            
            
                
                    
                    
                        
                             
                        
                    
                    
                        
                             
                        
                    
                
                
                    
                    
                        
                             
                        
                    
                    
                        
                             
                        
                    
                
                
                    
                    
                        
                             
                        
                    
                    
                        
                             
                        
                    
                
            
        
    </div>
    <p class="copyright">Viện Thẩm Mỹ Quốc Tế Royal - Copyright 2020</p>
</footer>



<script src="<?php echo e(asset('laningpage/frontend/js/jquery-3.4.1.min.js')); ?>"></script>
<!-- jquery -->
<script src="<?php echo e(asset('laningpage/frontend/js/bootstrap-3.4.1.min.js')); ?>"></script>
<!-- iScroll -->
<script src="<?php echo e(asset('laningpage/frontend/js/iscroll.min.js')); ?>"></script>
<!-- drawer.js -->
<script src="<?php echo e(asset('laningpage/frontend/js/drawer.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/plugins/jquery-validation/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/jquery-validation/js/additional-methods.min.js')); ?>"></script>
<script async defer
        src="https://connect.facebook.net/vi_VN/sdk.js#xfbml=1&version=v7.0&appId=1721885251448704&autoLogAppEvents=1"></script>

<script>
    $(document).ready(function () {
        $('.drawer').drawer();
        $('.drawer-hamburger').click(e => {
            var drawerOpen = $('.drawer-open');
            const imgBtn = $('.drawer-hamburger').children().find('img');
            if (drawerOpen.length) {
                imgBtn.replaceWith('<img src="/laningpage/frontend/Icon/icon-close.svg" alt="royal icon burger">')
            } else {
                imgBtn.replaceWith('<img src="/laningpage/frontend/Icon/icon-burger.png" alt="royal icon burger">')
            }
        });
        $('.drawer-overlay').click(e => {
            const imgBtn = $('.drawer-hamburger').children().find('img')
            imgBtn.replaceWith('<img src="/laningpage/frontend/Icon/icon-burger.png" alt="royal icon burger">')
        })

        jQuery.validator.addMethod("phone", function (phone_number, element) {
            phone_number = phone_number.replace(/\s+/g, "");
            return this.optional(element) || phone_number.length > 9 &&
                phone_number.match(/\(?([0-9]{3})\)?([ .-]?)([0-9]{3})\2([0-9]{4})/);
        }, "Số điện thoại không hợp lệ");

        $('form#my_Form').validate({
            rules: {
                phone: {
                    required: true,
                    phone: 'phone'
                },
                full_name: 'required',
            },
            messages: {
                full_name: "Vui lòng nhập tên quý khách !!!",
                phone: {
                    required: 'Vui lòng nhập số điện thoại !!!',
                    phone: 'Số điện thoại không hợp lệ !!!'
                },
            }
        });
    });
</script>

<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $("#my_Form").submit(function (event) {
        event.preventDefault();
        var $form = $(this);
        sendMail($form, $("#js-register-button"))
    });

    $('#js-customer-book-button').on('click', function () {
        sendMail($('#customer-book'), $(this));
    });

    $('#js-register-popup-button').on('click', function () {
        sendMail($('#register'), $(this));
    });

    function sendMail($form, $button) {
        var name = $form.find("input[name='full_name']").val();
        var phone = $form.find("input[name='phone']").val();
        if (!phone) {
            return;
        }
        var slug = $form.find("[name='slug']").val();
        var note = $form.find("[name='note']").val();
        $form.find("input[name='full_name']").attr('disabled', true);
        $form.find("input[name='phone']").attr('disabled', true);
        $form.find("[name='slug']").attr('disabled', true);
        $form.find("[name='note']").attr('disabled', true);
        $button.attr('disabled', true);
        var posting = $.post('/customer-post', {full_name: name, phone: phone, slug: slug, note: note});
        posting.done(function (data) {
            if ($button.prop('tagName').toLowerCase() === 'input') {
                $button.val(data);
            } else {
                $button.text(data);
            }
        });
    }
</script>
</body>
</html>
<?php /**PATH /var/www/html/Spa/resources/views/post/index.blade.php ENDPATH**/ ?>