<?php $__env->startSection('_style'); ?>
    <!-- Bootstrap fileupload css -->
    <link href="<?php echo e(asset(('assets/plugins/bootstrap-fileupload/bootstrap-fileupload.css'))); ?>" rel="stylesheet"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?php echo e($title); ?></h3></br>
            </div>
            <?php if(isset($user)): ?>
                <?php echo Form::model($user, array('url' => url('users/'.$user->id), 'method' => 'put', 'files'=> true,'id'=>'fvalidate')); ?>

            <?php else: ?>
                <?php echo Form::open(array('url' => route('users.store'), 'method' => 'post', 'files'=> true,'id'=>'fvalidate')); ?>

            <?php endif; ?>
            <div class="col row">
                <div class="col-xs-12 col-md-6">
                    <div class="form-group required <?php echo e($errors->has('full_name') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('full_name', 'Tên người dùng', array('class' => ' required')); ?>

                        <?php echo Form::text('full_name', null, array('class' => 'form-control')); ?>

                        <span class="help-block"><?php echo e($errors->first('full_name', ':message')); ?></span>
                    </div>
                </div>
                <div class="col-xs-12 col-md-6">
                    <div class="form-group required <?php echo e($errors->has('phone') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('phone', 'Số điện thoại', array('class' => ' required')); ?>

                        <?php echo Form::number('phone', null, array('id' => 'phone','class' => 'form-control')); ?>

                        <span class="help-block"><?php echo e($errors->first('phone', ':message')); ?></span>
                    </div>
                </div>
                
                    
                        
                        
                        
                    
                

                <div class="col-xs-12 col-md-6">
                    <div class="form-group required <?php echo e($errors->has('password') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('password', 'Mật khẩu', array('class' => ' required')); ?>

                        <input type="password" name="password" id="password" autocomplete="new-password"
                               class="form-control">
                        <span class="help-block"><?php echo e($errors->first('password', ':message')); ?></span>
                    </div>
                </div>
                <div class="col-xs-12 col-md-6">
                    <div class="form-group required <?php echo e($errors->has('confirm_password') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('confirm_password', 'Nhập lại mật khẩu', array('class' => ' required')); ?>

                        <input type="password" name="confirm_password" autocomplete="new-password" class="form-control">
                        <span class="help-block"><?php echo e($errors->first('confirm_password', ':message')); ?></span>
                    </div>
                </div>
                <div class="col-xs-12 col-md-6">
                    <div class="form-group required <?php echo e($errors->has('gender') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('gender', 'Giới tính', array('class' => ' required')); ?>

                        <?php echo Form::select('gender',[0 => 'Nữ', 1 => 'Nam'], null, array('class' => 'form-control select2', 'placeholder' => 'Chọn giới tính')); ?>

                        <span class="help-block"><?php echo e($errors->first('gender', ':message')); ?></span>
                    </div>
                </div>
                <div class="col-xs-12 col-md-6">
                    <div class="form-group required <?php echo e($errors->has('caller_number') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('', 'Mã máy tổng đài (nếu có)'); ?>

                        <input type="text" id="phone_center" class="form-control" value="<?php echo e(isset($user)?@$user->caller_number:''); ?>"
                        <?php echo e(\Illuminate\Support\Facades\Auth::user()->department_id!=\App\Constants\UserConstant::ADMIN ?'disabled':'name=caller_number'); ?> >
                        <span class="help-block"><?php echo e($errors->first('caller_number', ':message')); ?></span>
                    </div>
                </div>
                <?php if(\Illuminate\Support\Facades\Auth::user()->department_id==\App\Constants\UserConstant::ADMIN): ?>
                    <div class="col-xs-12 col-md-6">
                        <div class="form-group required <?php echo e($errors->has('department_id') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('department_id', 'Phòng ban', array('class' => ' required')); ?>

                            <?php echo Form::select('department_id', $departments, null, array('id'=>'departments','class' => 'form-control select2', 'placeholder' => 'Phòng ban')); ?>

                            <span class="help-block"><?php echo e($errors->first('branch_id', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-6">
                        <div class="form-group required <?php echo e($errors->has('role') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('role', 'Quyền', array('class' => ' required')); ?>

                            <select id="role" name="role" class="form-control select2">
                                <option value="">Chọn quyền</option>
                                <?php if(isset($user)): ?>
                                    <?php $__empty_1 = true; $__currentLoopData = $role; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <option
                                            <?php echo e($user->role==$item->id?'selected':''); ?> value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </select>
                            <span class="help-block"><?php echo e($errors->first('role', ':message')); ?></span>
                        </div>
                    </div>
                    <input type="hidden" name="is_leader" value="0">

                    <div class="col-xs-12 col-md-6">
                        <div class="form-group required <?php echo e($errors->has('branch_id') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('branch_id', 'Chi nhánh', array('class' => ' required')); ?>

                            <select id="role" name="branch_id" class="form-control select2">
                                <option value="">Tất cả chi nhánh</option>
                                <?php $__empty_1 = true; $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <option
                                        <?php echo e(@$user->branch_id==$k?'selected':''); ?> value="<?php echo e($k); ?>"><?php echo e($item); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>
                            </select>
                            <span class="help-block"><?php echo e($errors->first('branch_id', ':message')); ?></span>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="col-xs-12 col-md-6">
                    <div class="form-group required <?php echo e($errors->has('avatar') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('avatar', 'Ảnh đại diện', array('class' => ' required')); ?>

                        <div class="fileupload fileupload-<?php echo e(isset($user) ? 'exists' : 'new'); ?>"
                             data-provides="fileupload">
                            <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px">
                                <?php if(isset($user)): ?>
                                    <img src="<?php echo e($user->avatar); ?>" alt="image"/>
                                <?php endif; ?>
                            </div>
                            <div>
                                <button type="button" class="btn btn-default btn-file">
                                    <span class="fileupload-new"><i class="fa fa-paper-clip"></i> Chọn ảnh</span>
                                    <span class="fileupload-exists"><i class="fa fa-undo"></i> Thay đổi</span>
                                    <input type="file" name="image" accept="image/*" class="btn-default upload"/>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col" style="margin-bottom: 10px;">
                <button type="submit" class="btn btn-success">Lưu</button>
                <a href="<?php echo e(route('users.index')); ?>" class="btn btn-danger">Trở lại</a>
            </div>

            <?php echo e(Form::close()); ?>


        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('_script'); ?>
    <!-- Bootstrap fileupload js -->
    <script src="<?php echo e(asset('assets/plugins/bootstrap-fileupload/bootstrap-fileupload.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            // validate phone
            jQuery.validator.addMethod("phone_number", function (phone_number, element) {
                phone_number = phone_number.replace(/\s+/g, "");
                return this.optional(element) || phone_number.length > 9 &&
                    phone_number.match(/\(?([0-9]{3})\)?([ .-]?)([0-9]{3})\2([0-9]{4})/);
            }, "Số điện thoại không hợp lệ");

            $("#fvalidate").validate({
                rules: {
                    full_name: {
                        required: true,
                        normalizer: function (value) {
                            return $.trim(value);
                        }
                    },
                    phone: {
                        required: true,
                        remote: {
                            url: "<?php echo e(url('api/check-unique-users')); ?>",
                            type: "post",
                            data: {
                                phone: function () {
                                    return $("#phone").val();
                                },
                                id: <?php echo e(isset($user) ? $user->id : 0); ?>,
                            },
                        }
                    },
                    email: {
                        email: true,
                        remote: {
                            url: "<?php echo e(url('api/check-unique-users')); ?>",
                            type: "post",
                            data: {
                                email: function () {
                                    return $("#email").val();
                                },
                                table: 'teacher',
                                id: <?php echo e(isset($user) ? $user->id : 0); ?>,
                            },
                        }
                    },
                    gender: {
                        required: true
                    },
                    role: {
                        required: true
                    },
                    status_id: {
                        required: true
                    },
                    <?php if(empty($user)): ?>
                    password: {
                        required: true,
                        minlength: 6
                    },
                    confirm_password: {
                        required: true,
                        equalTo: "#password"
                    },
                    <?php endif; ?>
                    image: {
                        accept: "image/*"
                    }
                },
                messages: {
                    full_name: "Chưa nhập tên",
                    phone: {
                        required: "Chưa nhập số điện thoại",
                        remote: "Số điện thoại đã tồn tại trong hệ thống",
                    },
                    email: {
                        email: "Email không đúng định dạng",
                        remote: "Email đã tồn tại trong hệ thống",
                    },
                    gender: "Chưa chọn giới tính",
                    role: "Chưa nhập quyền",
                    status_id: "Chưa chọn trạng thái",
                    password: {
                        required: "Chưa nhập mật khẩu",
                        minlength: "Mật khẩu không được nhỏ hơn 6 ký tự"
                    },
                    confirm_password: {
                        required: "Chưa nhập xác nhận mật khẩu",
                        equalTo: "Mật khẩu nhập lại không chính xác"
                    }
                },
            });
        });

        $('#departments').change(function () {
            let department_id = $(this).val();
            let html = '';
            $.ajax({
                url: "/ajax/find-role/" + department_id,
                method: "get",
            }).done(function (data) {
                data.forEach(element => {
                    html += `<option value="` + element.id + `">` + element.name + `</option>`
                });
                $('#role').html(html);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Spa/resources/views/users/_form.blade.php ENDPATH**/ ?>