<?php
    $checkRole = checkRoleAlready();
?>
<?php $__env->startSection('_style'); ?>
    <!-- Bootstrap fileupload css -->
    <link href="<?php echo e(asset(('assets/plugins/bootstrap-fileupload/bootstrap-fileupload.css'))); ?>" rel="stylesheet"/>
    <style>
        strong.select2-results__group {
            font-weight: 600;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?php echo e($title); ?></h3></br>
            </div>

            <?php if(isset($customer)): ?>
                <?php echo Form::model($customer, array('url' => url('customers/'.$customer->id), 'method' => 'put', 'files'=> true, 'id'=>'fvalidate','autocomplete'=>'off')); ?>

            <?php else: ?>
                <?php echo Form::open(array('url' => route('customers.store'), 'method' => 'post', 'files'=> true, 'id'=>'fvalidate','autocomplete'=>'off')); ?>

            <?php endif; ?>
            <div class="row col-md-12">
                <div class="col-md-6">
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('full_name') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('full_name', 'Tên KH', array('class' => 'control-label')); ?>

                            <?php echo Form::text('full_name', null, array('class' => 'form-control')); ?>

                            <span class="help-block"><?php echo e($errors->first('full_name', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('phone') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('phone', 'Số điện thoại', array('class' => 'control-label')); ?>

                            <?php echo Form::text('phone', null, array('id' => 'phone','class' => 'form-control')); ?>

                            <span class="help-block"><?php echo e($errors->first('phone', ':message')); ?></span>
                        </div>
                    </div>

                    <?php if(isset($customer)): ?>
                        <div class="col-xs-12 col-md-12">
                            <div class="form-group required <?php echo e($errors->has('membership') ? 'has-error' : ''); ?>">
                                <?php echo Form::label('membership', 'Mã thành viên (MEMBERSHIP)'); ?>

                                <?php echo Form::text('membership', null, array('id' => 'membership','maxLength'=>9,'class' => 'form-control')); ?>

                                <span class="help-block"><?php echo e($errors->first('membership', ':message')); ?></span>
                            </div>
                        </div>
                        <div class="col-xs-12 col-md-12">
                            <div class="form-group required <?php echo e($errors->has('facebook') ? 'has-error' : ''); ?>">
                                <?php echo Form::label('fb_name', 'Tên Facebook'); ?>

                                <?php echo Form::text('fb_name', null, array('id' => 'fb_name','class' => 'form-control')); ?>

                                <span class="help-block"><?php echo e($errors->first('fb_name', ':message')); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('birthday') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('birthday', 'Ngày sinh'); ?>

                            <div class="wd-200 mg-b-30">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-calendar tx-16 lh-0 op-6"></i>
                                        </div>
                                    </div>
                                    <?php echo Form::text('birthday', null, array('class' => 'form-control fc-datepicker')); ?>

                                </div>
                            </div>
                        </div>
                        <span class="help-block"><?php echo e($errors->first('birthday', ':message')); ?></span>
                    </div>
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('description') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('description', 'Mô tả'); ?>

                            <?php echo Form::text('description', null, array('id' => 'description','class' => 'form-control')); ?>

                            <span class="help-block"><?php echo e($errors->first('description', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('gender') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('gender', 'Giới tính', array('class' => 'control-label')); ?>

                            <?php echo Form::select('gender',[0 => 'Nữ', 1 => 'Nam'], null, array('class' => 'form-control select2', 'placeholder' => 'Chọn giới tính')); ?>

                            <span class="help-block"><?php echo e($errors->first('gender', ':message')); ?></span>
                        </div>
                    </div>

                    
                    
                    
                    
                    
                    
                    
                    <?php if(empty($checkRole)): ?>
                        <div class="col-xs-12 col-md-12">
                            <div class="form-group required <?php echo e($errors->has('genitive_id') ? 'has-error' : ''); ?>">
                                <?php echo Form::label('branch_id', 'Chi nhánh',['class'=>'required']); ?>

                                <?php echo Form::select('branch_id',$branchs, null, array('class' => 'form-control select2', 'placeholder' => 'Tất cả chi nhánh')); ?>

                                <span class="help-block"><?php echo e($errors->first('branch_id', ':message')); ?></span>
                            </div>
                        </div>
                    <?php else: ?>
                        <input type="hidden" name="branch_id" value="<?php echo e($checkRole); ?>">
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('telesales_id') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('telesales_id', 'Người phụ trách', array('class' => 'control-label required')); ?>

                            <select name="telesales_id" id="telesales_id" class="form-control select2"
                                    <?php echo e(\Illuminate\Support\Facades\Auth::user()->department_id==\App\Constants\DepartmentConstant::TELESALES && isset($customer) ?'disabled':''); ?>

                                    data-placeholder="Chọn nhân viên">
                                <option value=""></option>
                                <?php $__currentLoopData = $telesales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <optgroup label="<?php echo e($k); ?>">
                                        <?php $__currentLoopData = $l; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kl => $vl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                <?php echo e(@$customer->telesales_id == $vl||\Illuminate\Support\Facades\Auth::user()->department_id==\App\Constants\DepartmentConstant::WAITER&&\Illuminate\Support\Facades\Auth::user()->id==$vl?'selected':''); ?> value="<?php echo e($vl); ?>"><?php echo e($kl); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </optgroup>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <span class="help-block"><?php echo e($errors->first('telesales_id', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('status_id') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('status_id', 'Trạng thái', array('class' => 'control-label')); ?>

                            <?php echo Form::select('status_id', $status, @$customer->status_id, array('class' => 'form-control select2')); ?>

                            <span class="help-block"><?php echo e($errors->first('status_id', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('facebook') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('facebook', 'Link Facebook'); ?>

                            <?php echo Form::text('facebook', null, array('id' => 'facebook','class' => 'form-control')); ?>

                            <span class="help-block"><?php echo e($errors->first('facebook', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('group_id') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('group_id', 'Nhóm khách hàng', array('class' => 'required control-label')); ?>

                            <?php if(isset($customer)): ?>
                                <select class="form-control select2" name="group_id[]" multiple="multiple"
                                        data-placeholder="Chọn nhóm khách hàng">
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e($item->id); ?>" <?php echo e(isset($customer) && in_array($item->id, $categoryId) ? 'selected' : ""); ?>><?php echo e($item->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            <?php else: ?>
                                <?php echo Form::select('group_id[]', $group, null, array('class' => 'form-control select2', 'multiple' => 'multiple', 'data-placeholder'=> "Chọn nhóm khách hàng" )); ?>

                                <span class="help-block"><?php echo e($errors->first('group_id', ':message')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('source_id') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('source_id', 'Nguồn khách hàng', array('class' => 'required control-label')); ?>

                            <?php echo Form::select('source_id', $source, @$customer->source_id, array('class' => 'form-control select2', 'placeholder' => 'Nguồn khách hàng')); ?>

                            <span class="help-block"><?php echo e($errors->first('source_id', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-12">
                        <div class="form-group required <?php echo e($errors->has('avatar') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('avatar', 'Ảnh đại diện'); ?>

                            <div class="fileupload fileupload-<?php echo e(isset($customer) ? 'exists' : 'new'); ?>"
                                 data-provides="fileupload">
                                <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px">
                                    <?php if(isset($customer)): ?>
                                        <img src="<?php echo e($customer->avatar); ?>" alt="image"/>
                                    <?php endif; ?>
                                </div>
                                <div>
                                    <button type="button" class="btn btn-default btn-file">
                                        <span class="fileupload-new"><i class="fa fa-paper-clip"></i> Chọn ảnh</span>
                                        <span class="fileupload-exists"><i class="fa fa-undo"></i> Thay đổi</span>
                                        <input type="file" name="image" accept="image/*" class="btn-default upload"/>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col" style="margin-bottom: 10px;">
                <button type="submit" class="btn btn-success">Lưu</button>
                <a href="<?php echo e(route('customers.index')); ?>" class="btn btn-danger">Trở lại</a>
            </div>
            <?php echo e(Form::close()); ?>


        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('_script'); ?>
    <script src="<?php echo e(asset('assets/plugins/bootstrap-fileupload/bootstrap-fileupload.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            // validate phone
            jQuery.validator.addMethod("phone_number", function (phone_number, element) {
                phone_number = phone_number.replace(/\s+/g, "");
                return this.optional(element) || phone_number.length > 9 &&
                    phone_number.match(/\(?([0-9]{3})\)?([ .-]?)([0-9]{3})\2([0-9]{4})/);
            }, "Số điện thoại không hợp lệ");

            $("#fvalidate").validate({
                rules: {
                    full_name: {
                        required: true,
                        normalizer: function (value) {
                            return $.trim(value);
                        }
                    },
                    phone: {
                        required: true,
                        remote: {
                            url: "<?php echo e(url('api/check-unique-customers')); ?>",
                            type: "post",
                            data: {
                                phone: function () {
                                    return $("#phone").val();
                                },
                                id: <?php echo e(isset($customer) ? $customer->id : 0); ?>,
                            },
                        }
                    },
                    gender: {
                        required: true
                    },
                    branch_id: {
                        required: true
                    },

                    role: {
                        required: true
                    },
                    status_id: {
                        required: true
                    },
                    'group_id[]': {
                        required: true
                    },
                    source_id: {
                        required: true
                    },
                    telesales_id: {
                        required: true
                    }
                },
                messages: {
                    full_name: "Chưa nhập tên",
                    branch_id: "Chưa chọn chi nhánh",
                    phone: {
                        required: "Chưa nhập số điện thoại",
                        remote: "Số điện thoại đã tồn tại trong hệ thống",
                    },
                    gender: "Chưa chọn giới tính",
                    status_id: "Chưa chọn trạng thái",
                    'group_id[]': "Chưa chọn nhóm khách hàng",
                    source_id: "Chưa chọn nguồn khách hàng",
                    telesales_id: "Chưa chọn người phụ trách",
                },
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Spa/resources/views/customers/_form.blade.php ENDPATH**/ ?>