<?php $__env->startSection('content'); ?>
    <div class="col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?php echo e($title); ?></h3></br>
            </div>

            <?php if(isset($doc)): ?>
                <?php echo Form::model($doc, array('url' => url('status/'.$doc->id), 'method' => 'put', 'files'=> true,'id'=>'fvalidate')); ?>

            <?php else: ?>
                <?php echo Form::open(array('url' => route('status.store'), 'method' => 'post', 'files'=> true,'id'=>'fvalidate')); ?>

            <?php endif; ?>
            <div class="col row">
                <div class="col-xs-12 col-md-6">
                    <div class="form-group required <?php echo e($errors->has('name') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('name', 'Tên nhóm', array('class' => ' required')); ?>

                        <?php echo Form::text('name',null, array('class' => 'form-control', 'required' => true)); ?>

                        <span class="help-block"><?php echo e($errors->first('name', ':message')); ?></span>
                    </div>
                </div>
                <?php if(isset($doc)): ?>
                    <div class="col-xs-12 col-md-6">
                        <div class="form-group required <?php echo e($errors->has('name') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('code', 'Mã nhóm', array('class' => ' required')); ?>

                            <?php echo Form::text('code',null, array('class' => 'form-control', 'required' => true,'readonly'=>true)); ?>

                            <span class="help-block"><?php echo e($errors->first('name', ':message')); ?></span>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-6">
                        <div class="form-group required <?php echo e($errors->has('name') ? 'has-error' : ''); ?>">
                            <?php echo Form::label('position', 'Vị trí', array('class' => ' required')); ?>

                            <?php echo Form::text('position',null, array('class' => 'form-control', 'required' => true)); ?>

                            <span class="help-block"><?php echo e($errors->first('name', ':message')); ?></span>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="col-xs-12 col-md-6">
                    <div class="form-group <?php echo e($errors->has('type') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('type','Màu nền', array('class' => 'required')); ?>

                        <?php echo Form::select('type',$types_pluck, null, array('class' => 'form-control','data-placeholder'=>'Danh mục cha')); ?>

                        <span class="help-block"><?php echo e($errors->first('type', ':message')); ?></span>
                    </div>
                </div>
                
                <div class="col-xs-12 col-md-2">
                    <div class="form-group <?php echo e($errors->has('type') ? 'has-error' : ''); ?>">
                        <?php echo Form::label('color','Màu nền', array('class' => 'required')); ?>

                        
                        <input type="color" name="color" value="<?php echo e(isset($doc) && $doc->color ?$doc->color:''); ?>">
                        <span class="help-block"><?php echo e($errors->first('type', ':message')); ?></span>
                    </div>
                </div>
            </div>
            <div class="col" style="margin-bottom: 10px;">
                <button type="submit" class="btn btn-success">Lưu</button>
                <a href="<?php echo e(route('status.index')); ?>" class="btn btn-danger">Về danh sách</a>
            </div>

            <?php echo e(Form::close()); ?>


        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('_script'); ?>
    <script>
        $(document).ready(function () {
            $('form#fvalidate').validate({
                rules: {
                    name: 'required',
                    type: 'required',
                },
                messages: {
                    name: "vui lòng nhâp tên danh mục",
                    type: "vui lòng chọn thể loại",
                }
            });
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Spa/resources/views/status/_form.blade.php ENDPATH**/ ?>