<?php
// This file was auto-generated from sdk-root/src/data/codedeploy/2014-10-06/api-2.json
return [
    'version' => '2.0',
    'metadata' => [
        'apiVersion' => '2014-10-06',
        'endpointPrefix' => 'codedeploy',
        'jsonVersion' => '1.1',
        'protocol' => 'json',
        'serviceAbbreviation' => 'CodeDeploy',
        'serviceFullName' => 'AWS CodeDeploy',
        'signatureVersion' => 'v4',
        'targetPrefix' => 'CodeDeploy_20141006',
        'timestampFormat' => 'unixTimestamp',
        'uid' => 'codedeploy-2014-10-06',
    ],
    'operations' => [
        'AddTagsToOnPremisesInstances' => [
            'name' => 'AddTagsToOnPremisesInstances',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'AddTagsToOnPremisesInstancesInput',],
            'errors' => [
                ['shape' => 'InstanceNameRequiredException',],
                ['shape' => 'TagRequiredException',],
                ['shape' => 'InvalidTagException',],
                ['shape' => 'TagLimitExceededException',],
                ['shape' => 'InstanceLimitExceededException',],
                ['shape' => 'InstanceNotRegisteredException',],
            ],
        ],
        'BatchGetApplicationRevisions' => [
            'name' => 'BatchGetApplicationRevisions',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'BatchGetApplicationRevisionsInput',],
            'output' => ['shape' => 'BatchGetApplicationRevisionsOutput',],
            'errors' => [
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'RevisionRequiredException',],
                ['shape' => 'InvalidRevisionException',],
                ['shape' => 'BatchLimitExceededException',],
            ],
        ],
        'BatchGetApplications' => [
            'name' => 'BatchGetApplications',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'BatchGetApplicationsInput',],
            'output' => ['shape' => 'BatchGetApplicationsOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'BatchLimitExceededException',],
            ],
        ],
        'BatchGetDeploymentGroups' => [
            'name' => 'BatchGetDeploymentGroups',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'BatchGetDeploymentGroupsInput',],
            'output' => ['shape' => 'BatchGetDeploymentGroupsOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'DeploymentGroupNameRequiredException',],
                ['shape' => 'InvalidDeploymentGroupNameException',],
                ['shape' => 'BatchLimitExceededException',],
            ],
        ],
        'BatchGetDeploymentInstances' => [
            'name' => 'BatchGetDeploymentInstances',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'BatchGetDeploymentInstancesInput',],
            'output' => ['shape' => 'BatchGetDeploymentInstancesOutput',],
            'errors' => [
                ['shape' => 'DeploymentIdRequiredException',],
                ['shape' => 'DeploymentDoesNotExistException',],
                ['shape' => 'InstanceIdRequiredException',],
                ['shape' => 'InvalidDeploymentIdException',],
                ['shape' => 'InvalidInstanceNameException',],
                ['shape' => 'BatchLimitExceededException',],
            ],
        ],
        'BatchGetDeployments' => [
            'name' => 'BatchGetDeployments',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'BatchGetDeploymentsInput',],
            'output' => ['shape' => 'BatchGetDeploymentsOutput',],
            'errors' => [
                ['shape' => 'DeploymentIdRequiredException',],
                ['shape' => 'InvalidDeploymentIdException',],
                ['shape' => 'BatchLimitExceededException',],
            ],
        ],
        'BatchGetOnPremisesInstances' => [
            'name' => 'BatchGetOnPremisesInstances',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'BatchGetOnPremisesInstancesInput',],
            'output' => ['shape' => 'BatchGetOnPremisesInstancesOutput',],
            'errors' => [
                ['shape' => 'InstanceNameRequiredException',],
                ['shape' => 'InvalidInstanceNameException',],
                ['shape' => 'BatchLimitExceededException',],
            ],
        ],
        'ContinueDeployment' => [
            'name' => 'ContinueDeployment',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'ContinueDeploymentInput',],
            'errors' => [
                ['shape' => 'DeploymentIdRequiredException',],
                ['shape' => 'DeploymentDoesNotExistException',],
                ['shape' => 'DeploymentAlreadyCompletedException',],
                ['shape' => 'InvalidDeploymentIdException',],
                ['shape' => 'DeploymentIsNotInReadyStateException',],
                ['shape' => 'UnsupportedActionForDeploymentTypeException',],
            ],
        ],
        'CreateApplication' => [
            'name' => 'CreateApplication',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'CreateApplicationInput',],
            'output' => ['shape' => 'CreateApplicationOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationAlreadyExistsException',],
                ['shape' => 'ApplicationLimitExceededException',],
            ],
        ],
        'CreateDeployment' => [
            'name' => 'CreateDeployment',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'CreateDeploymentInput',],
            'output' => ['shape' => 'CreateDeploymentOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'DeploymentGroupNameRequiredException',],
                ['shape' => 'InvalidDeploymentGroupNameException',],
                ['shape' => 'DeploymentGroupDoesNotExistException',],
                ['shape' => 'RevisionRequiredException',],
                ['shape' => 'RevisionDoesNotExistException',],
                ['shape' => 'InvalidRevisionException',],
                ['shape' => 'InvalidDeploymentConfigNameException',],
                ['shape' => 'DeploymentConfigDoesNotExistException',],
                ['shape' => 'DescriptionTooLongException',],
                ['shape' => 'DeploymentLimitExceededException',],
                ['shape' => 'InvalidTargetInstancesException',],
                ['shape' => 'InvalidAutoRollbackConfigException',],
                ['shape' => 'InvalidLoadBalancerInfoException',],
                ['shape' => 'InvalidFileExistsBehaviorException',],
            ],
        ],
        'CreateDeploymentConfig' => [
            'name' => 'CreateDeploymentConfig',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'CreateDeploymentConfigInput',],
            'output' => ['shape' => 'CreateDeploymentConfigOutput',],
            'errors' => [
                ['shape' => 'InvalidDeploymentConfigNameException',],
                ['shape' => 'DeploymentConfigNameRequiredException',],
                ['shape' => 'DeploymentConfigAlreadyExistsException',],
                ['shape' => 'InvalidMinimumHealthyHostValueException',],
                ['shape' => 'DeploymentConfigLimitExceededException',],
            ],
        ],
        'CreateDeploymentGroup' => [
            'name' => 'CreateDeploymentGroup',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'CreateDeploymentGroupInput',],
            'output' => ['shape' => 'CreateDeploymentGroupOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'DeploymentGroupNameRequiredException',],
                ['shape' => 'InvalidDeploymentGroupNameException',],
                ['shape' => 'DeploymentGroupAlreadyExistsException',],
                ['shape' => 'InvalidEC2TagException',],
                ['shape' => 'InvalidTagException',],
                ['shape' => 'InvalidAutoScalingGroupException',],
                ['shape' => 'InvalidDeploymentConfigNameException',],
                ['shape' => 'DeploymentConfigDoesNotExistException',],
                ['shape' => 'RoleRequiredException',],
                ['shape' => 'InvalidRoleException',],
                ['shape' => 'DeploymentGroupLimitExceededException',],
                ['shape' => 'LifecycleHookLimitExceededException',],
                ['shape' => 'InvalidTriggerConfigException',],
                ['shape' => 'TriggerTargetsLimitExceededException',],
                ['shape' => 'InvalidAlarmConfigException',],
                ['shape' => 'AlarmsLimitExceededException',],
                ['shape' => 'InvalidAutoRollbackConfigException',],
                ['shape' => 'InvalidLoadBalancerInfoException',],
                ['shape' => 'InvalidDeploymentStyleException',],
                ['shape' => 'InvalidBlueGreenDeploymentConfigurationException',],
            ],
        ],
        'DeleteApplication' => [
            'name' => 'DeleteApplication',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'DeleteApplicationInput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
            ],
        ],
        'DeleteDeploymentConfig' => [
            'name' => 'DeleteDeploymentConfig',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'DeleteDeploymentConfigInput',],
            'errors' => [
                ['shape' => 'InvalidDeploymentConfigNameException',],
                ['shape' => 'DeploymentConfigNameRequiredException',],
                ['shape' => 'DeploymentConfigInUseException',],
                ['shape' => 'InvalidOperationException',],
            ],
        ],
        'DeleteDeploymentGroup' => [
            'name' => 'DeleteDeploymentGroup',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'DeleteDeploymentGroupInput',],
            'output' => ['shape' => 'DeleteDeploymentGroupOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'DeploymentGroupNameRequiredException',],
                ['shape' => 'InvalidDeploymentGroupNameException',],
                ['shape' => 'InvalidRoleException',],
            ],
        ],
        'DeregisterOnPremisesInstance' => [
            'name' => 'DeregisterOnPremisesInstance',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'DeregisterOnPremisesInstanceInput',],
            'errors' => [['shape' => 'InstanceNameRequiredException',], ['shape' => 'InvalidInstanceNameException',],],
        ],
        'GetApplication' => [
            'name' => 'GetApplication',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'GetApplicationInput',],
            'output' => ['shape' => 'GetApplicationOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationDoesNotExistException',],
            ],
        ],
        'GetApplicationRevision' => [
            'name' => 'GetApplicationRevision',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'GetApplicationRevisionInput',],
            'output' => ['shape' => 'GetApplicationRevisionOutput',],
            'errors' => [
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'RevisionDoesNotExistException',],
                ['shape' => 'RevisionRequiredException',],
                ['shape' => 'InvalidRevisionException',],
            ],
        ],
        'GetDeployment' => [
            'name' => 'GetDeployment',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'GetDeploymentInput',],
            'output' => ['shape' => 'GetDeploymentOutput',],
            'errors' => [
                ['shape' => 'DeploymentIdRequiredException',],
                ['shape' => 'InvalidDeploymentIdException',],
                ['shape' => 'DeploymentDoesNotExistException',],
            ],
        ],
        'GetDeploymentConfig' => [
            'name' => 'GetDeploymentConfig',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'GetDeploymentConfigInput',],
            'output' => ['shape' => 'GetDeploymentConfigOutput',],
            'errors' => [
                ['shape' => 'InvalidDeploymentConfigNameException',],
                ['shape' => 'DeploymentConfigNameRequiredException',],
                ['shape' => 'DeploymentConfigDoesNotExistException',],
            ],
        ],
        'GetDeploymentGroup' => [
            'name' => 'GetDeploymentGroup',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'GetDeploymentGroupInput',],
            'output' => ['shape' => 'GetDeploymentGroupOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'DeploymentGroupNameRequiredException',],
                ['shape' => 'InvalidDeploymentGroupNameException',],
                ['shape' => 'DeploymentGroupDoesNotExistException',],
            ],
        ],
        'GetDeploymentInstance' => [
            'name' => 'GetDeploymentInstance',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'GetDeploymentInstanceInput',],
            'output' => ['shape' => 'GetDeploymentInstanceOutput',],
            'errors' => [
                ['shape' => 'DeploymentIdRequiredException',],
                ['shape' => 'DeploymentDoesNotExistException',],
                ['shape' => 'InstanceIdRequiredException',],
                ['shape' => 'InvalidDeploymentIdException',],
                ['shape' => 'InstanceDoesNotExistException',],
                ['shape' => 'InvalidInstanceNameException',],
            ],
        ],
        'GetOnPremisesInstance' => [
            'name' => 'GetOnPremisesInstance',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'GetOnPremisesInstanceInput',],
            'output' => ['shape' => 'GetOnPremisesInstanceOutput',],
            'errors' => [
                ['shape' => 'InstanceNameRequiredException',],
                ['shape' => 'InstanceNotRegisteredException',],
                ['shape' => 'InvalidInstanceNameException',],
            ],
        ],
        'ListApplicationRevisions' => [
            'name' => 'ListApplicationRevisions',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'ListApplicationRevisionsInput',],
            'output' => ['shape' => 'ListApplicationRevisionsOutput',],
            'errors' => [
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'InvalidSortByException',],
                ['shape' => 'InvalidSortOrderException',],
                ['shape' => 'InvalidBucketNameFilterException',],
                ['shape' => 'InvalidKeyPrefixFilterException',],
                ['shape' => 'BucketNameFilterRequiredException',],
                ['shape' => 'InvalidDeployedStateFilterException',],
                ['shape' => 'InvalidNextTokenException',],
            ],
        ],
        'ListApplications' => [
            'name' => 'ListApplications',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'ListApplicationsInput',],
            'output' => ['shape' => 'ListApplicationsOutput',],
            'errors' => [['shape' => 'InvalidNextTokenException',],],
        ],
        'ListDeploymentConfigs' => [
            'name' => 'ListDeploymentConfigs',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'ListDeploymentConfigsInput',],
            'output' => ['shape' => 'ListDeploymentConfigsOutput',],
            'errors' => [['shape' => 'InvalidNextTokenException',],],
        ],
        'ListDeploymentGroups' => [
            'name' => 'ListDeploymentGroups',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'ListDeploymentGroupsInput',],
            'output' => ['shape' => 'ListDeploymentGroupsOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'InvalidNextTokenException',],
            ],
        ],
        'ListDeploymentInstances' => [
            'name' => 'ListDeploymentInstances',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'ListDeploymentInstancesInput',],
            'output' => ['shape' => 'ListDeploymentInstancesOutput',],
            'errors' => [
                ['shape' => 'DeploymentIdRequiredException',],
                ['shape' => 'DeploymentDoesNotExistException',],
                ['shape' => 'DeploymentNotStartedException',],
                ['shape' => 'InvalidNextTokenException',],
                ['shape' => 'InvalidDeploymentIdException',],
                ['shape' => 'InvalidInstanceStatusException',],
                ['shape' => 'InvalidInstanceTypeException',],
                ['shape' => 'InvalidDeploymentInstanceTypeException',],
            ],
        ],
        'ListDeployments' => [
            'name' => 'ListDeployments',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'ListDeploymentsInput',],
            'output' => ['shape' => 'ListDeploymentsOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'InvalidDeploymentGroupNameException',],
                ['shape' => 'DeploymentGroupDoesNotExistException',],
                ['shape' => 'DeploymentGroupNameRequiredException',],
                ['shape' => 'InvalidTimeRangeException',],
                ['shape' => 'InvalidDeploymentStatusException',],
                ['shape' => 'InvalidNextTokenException',],
            ],
        ],
        'ListGitHubAccountTokenNames' => [
            'name' => 'ListGitHubAccountTokenNames',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'ListGitHubAccountTokenNamesInput',],
            'output' => ['shape' => 'ListGitHubAccountTokenNamesOutput',],
            'errors' => [['shape' => 'InvalidNextTokenException',], ['shape' => 'ResourceValidationException',],],
        ],
        'ListOnPremisesInstances' => [
            'name' => 'ListOnPremisesInstances',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'ListOnPremisesInstancesInput',],
            'output' => ['shape' => 'ListOnPremisesInstancesOutput',],
            'errors' => [
                ['shape' => 'InvalidRegistrationStatusException',],
                ['shape' => 'InvalidTagFilterException',],
                ['shape' => 'InvalidNextTokenException',],
            ],
        ],
        'RegisterApplicationRevision' => [
            'name' => 'RegisterApplicationRevision',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'RegisterApplicationRevisionInput',],
            'errors' => [
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'DescriptionTooLongException',],
                ['shape' => 'RevisionRequiredException',],
                ['shape' => 'InvalidRevisionException',],
            ],
        ],
        'RegisterOnPremisesInstance' => [
            'name' => 'RegisterOnPremisesInstance',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'RegisterOnPremisesInstanceInput',],
            'errors' => [
                ['shape' => 'InstanceNameAlreadyRegisteredException',],
                ['shape' => 'IamArnRequiredException',],
                ['shape' => 'IamSessionArnAlreadyRegisteredException',],
                ['shape' => 'IamUserArnAlreadyRegisteredException',],
                ['shape' => 'InstanceNameRequiredException',],
                ['shape' => 'IamUserArnRequiredException',],
                ['shape' => 'InvalidInstanceNameException',],
                ['shape' => 'InvalidIamSessionArnException',],
                ['shape' => 'InvalidIamUserArnException',],
                ['shape' => 'MultipleIamArnsProvidedException',],
            ],
        ],
        'RemoveTagsFromOnPremisesInstances' => [
            'name' => 'RemoveTagsFromOnPremisesInstances',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'RemoveTagsFromOnPremisesInstancesInput',],
            'errors' => [
                ['shape' => 'InstanceNameRequiredException',],
                ['shape' => 'TagRequiredException',],
                ['shape' => 'InvalidTagException',],
                ['shape' => 'TagLimitExceededException',],
                ['shape' => 'InstanceLimitExceededException',],
                ['shape' => 'InstanceNotRegisteredException',],
            ],
        ],
        'SkipWaitTimeForInstanceTermination' => [
            'name' => 'SkipWaitTimeForInstanceTermination',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'SkipWaitTimeForInstanceTerminationInput',],
            'errors' => [
                ['shape' => 'DeploymentIdRequiredException',],
                ['shape' => 'DeploymentDoesNotExistException',],
                ['shape' => 'DeploymentAlreadyCompletedException',],
                ['shape' => 'InvalidDeploymentIdException',],
                ['shape' => 'DeploymentNotStartedException',],
                ['shape' => 'UnsupportedActionForDeploymentTypeException',],
            ],
        ],
        'StopDeployment' => [
            'name' => 'StopDeployment',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'StopDeploymentInput',],
            'output' => ['shape' => 'StopDeploymentOutput',],
            'errors' => [
                ['shape' => 'DeploymentIdRequiredException',],
                ['shape' => 'DeploymentDoesNotExistException',],
                ['shape' => 'DeploymentAlreadyCompletedException',],
                ['shape' => 'InvalidDeploymentIdException',],
            ],
        ],
        'UpdateApplication' => [
            'name' => 'UpdateApplication',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'UpdateApplicationInput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationAlreadyExistsException',],
                ['shape' => 'ApplicationDoesNotExistException',],
            ],
        ],
        'UpdateDeploymentGroup' => [
            'name' => 'UpdateDeploymentGroup',
            'http' => ['method' => 'POST', 'requestUri' => '/',],
            'input' => ['shape' => 'UpdateDeploymentGroupInput',],
            'output' => ['shape' => 'UpdateDeploymentGroupOutput',],
            'errors' => [
                ['shape' => 'ApplicationNameRequiredException',],
                ['shape' => 'InvalidApplicationNameException',],
                ['shape' => 'ApplicationDoesNotExistException',],
                ['shape' => 'InvalidDeploymentGroupNameException',],
                ['shape' => 'DeploymentGroupAlreadyExistsException',],
                ['shape' => 'DeploymentGroupNameRequiredException',],
                ['shape' => 'DeploymentGroupDoesNotExistException',],
                ['shape' => 'InvalidEC2TagException',],
                ['shape' => 'InvalidTagException',],
                ['shape' => 'InvalidAutoScalingGroupException',],
                ['shape' => 'InvalidDeploymentConfigNameException',],
                ['shape' => 'DeploymentConfigDoesNotExistException',],
                ['shape' => 'InvalidRoleException',],
                ['shape' => 'LifecycleHookLimitExceededException',],
                ['shape' => 'InvalidTriggerConfigException',],
                ['shape' => 'TriggerTargetsLimitExceededException',],
                ['shape' => 'InvalidAlarmConfigException',],
                ['shape' => 'AlarmsLimitExceededException',],
                ['shape' => 'InvalidAutoRollbackConfigException',],
                ['shape' => 'InvalidLoadBalancerInfoException',],
                ['shape' => 'InvalidDeploymentStyleException',],
                ['shape' => 'InvalidBlueGreenDeploymentConfigurationException',],
            ],
        ],
    ],
    'shapes' => [
        'AddTagsToOnPremisesInstancesInput' => [
            'type' => 'structure',
            'required' => ['tags', 'instanceNames',],
            'members' => ['tags' => ['shape' => 'TagList',], 'instanceNames' => ['shape' => 'InstanceNameList',],],
        ],
        'AdditionalDeploymentStatusInfo' => ['type' => 'string',],
        'Alarm' => ['type' => 'structure', 'members' => ['name' => ['shape' => 'AlarmName',],],],
        'AlarmConfiguration' => [
            'type' => 'structure',
            'members' => [
                'enabled' => ['shape' => 'Boolean',],
                'ignorePollAlarmFailure' => ['shape' => 'Boolean',],
                'alarms' => ['shape' => 'AlarmList',],
            ],
        ],
        'AlarmList' => ['type' => 'list', 'member' => ['shape' => 'Alarm',],],
        'AlarmName' => ['type' => 'string',],
        'AlarmsLimitExceededException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'ApplicationAlreadyExistsException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'ApplicationDoesNotExistException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'ApplicationId' => ['type' => 'string',],
        'ApplicationInfo' => [
            'type' => 'structure',
            'members' => [
                'applicationId' => ['shape' => 'ApplicationId',],
                'applicationName' => ['shape' => 'ApplicationName',],
                'createTime' => ['shape' => 'Timestamp',],
                'linkedToGitHub' => ['shape' => 'Boolean',],
                'gitHubAccountName' => ['shape' => 'GitHubAccountTokenName',],
            ],
        ],
        'ApplicationLimitExceededException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'ApplicationName' => ['type' => 'string', 'max' => 100, 'min' => 1,],
        'ApplicationNameRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'ApplicationRevisionSortBy' => [
            'type' => 'string',
            'enum' => ['registerTime', 'firstUsedTime', 'lastUsedTime',],
        ],
        'ApplicationsInfoList' => ['type' => 'list', 'member' => ['shape' => 'ApplicationInfo',],],
        'ApplicationsList' => ['type' => 'list', 'member' => ['shape' => 'ApplicationName',],],
        'AutoRollbackConfiguration' => [
            'type' => 'structure',
            'members' => ['enabled' => ['shape' => 'Boolean',], 'events' => ['shape' => 'AutoRollbackEventsList',],],
        ],
        'AutoRollbackEvent' => [
            'type' => 'string',
            'enum' => ['DEPLOYMENT_FAILURE', 'DEPLOYMENT_STOP_ON_ALARM', 'DEPLOYMENT_STOP_ON_REQUEST',],
        ],
        'AutoRollbackEventsList' => ['type' => 'list', 'member' => ['shape' => 'AutoRollbackEvent',],],
        'AutoScalingGroup' => [
            'type' => 'structure',
            'members' => [
                'name' => ['shape' => 'AutoScalingGroupName',],
                'hook' => ['shape' => 'AutoScalingGroupHook',],
            ],
        ],
        'AutoScalingGroupHook' => ['type' => 'string',],
        'AutoScalingGroupList' => ['type' => 'list', 'member' => ['shape' => 'AutoScalingGroup',],],
        'AutoScalingGroupName' => ['type' => 'string',],
        'AutoScalingGroupNameList' => ['type' => 'list', 'member' => ['shape' => 'AutoScalingGroupName',],],
        'BatchGetApplicationRevisionsInput' => [
            'type' => 'structure',
            'required' => ['applicationName', 'revisions',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'revisions' => ['shape' => 'RevisionLocationList',],
            ],
        ],
        'BatchGetApplicationRevisionsOutput' => [
            'type' => 'structure',
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'errorMessage' => ['shape' => 'ErrorMessage',],
                'revisions' => ['shape' => 'RevisionInfoList',],
            ],
        ],
        'BatchGetApplicationsInput' => [
            'type' => 'structure',
            'members' => ['applicationNames' => ['shape' => 'ApplicationsList',],],
        ],
        'BatchGetApplicationsOutput' => [
            'type' => 'structure',
            'members' => ['applicationsInfo' => ['shape' => 'ApplicationsInfoList',],],
        ],
        'BatchGetDeploymentGroupsInput' => [
            'type' => 'structure',
            'required' => ['applicationName', 'deploymentGroupNames',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'deploymentGroupNames' => ['shape' => 'DeploymentGroupsList',],
            ],
        ],
        'BatchGetDeploymentGroupsOutput' => [
            'type' => 'structure',
            'members' => [
                'deploymentGroupsInfo' => ['shape' => 'DeploymentGroupInfoList',],
                'errorMessage' => ['shape' => 'ErrorMessage',],
            ],
        ],
        'BatchGetDeploymentInstancesInput' => [
            'type' => 'structure',
            'required' => ['deploymentId', 'instanceIds',],
            'members' => [
                'deploymentId' => ['shape' => 'DeploymentId',],
                'instanceIds' => ['shape' => 'InstancesList',],
            ],
        ],
        'BatchGetDeploymentInstancesOutput' => [
            'type' => 'structure',
            'members' => [
                'instancesSummary' => ['shape' => 'InstanceSummaryList',],
                'errorMessage' => ['shape' => 'ErrorMessage',],
            ],
        ],
        'BatchGetDeploymentsInput' => [
            'type' => 'structure',
            'members' => ['deploymentIds' => ['shape' => 'DeploymentsList',],],
        ],
        'BatchGetDeploymentsOutput' => [
            'type' => 'structure',
            'members' => ['deploymentsInfo' => ['shape' => 'DeploymentsInfoList',],],
        ],
        'BatchGetOnPremisesInstancesInput' => [
            'type' => 'structure',
            'members' => ['instanceNames' => ['shape' => 'InstanceNameList',],],
        ],
        'BatchGetOnPremisesInstancesOutput' => [
            'type' => 'structure',
            'members' => ['instanceInfos' => ['shape' => 'InstanceInfoList',],],
        ],
        'BatchLimitExceededException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'BlueGreenDeploymentConfiguration' => [
            'type' => 'structure',
            'members' => [
                'terminateBlueInstancesOnDeploymentSuccess' => ['shape' => 'BlueInstanceTerminationOption',],
                'deploymentReadyOption' => ['shape' => 'DeploymentReadyOption',],
                'greenFleetProvisioningOption' => ['shape' => 'GreenFleetProvisioningOption',],
            ],
        ],
        'BlueInstanceTerminationOption' => [
            'type' => 'structure',
            'members' => [
                'action' => ['shape' => 'InstanceAction',],
                'terminationWaitTimeInMinutes' => ['shape' => 'Duration',],
            ],
        ],
        'Boolean' => ['type' => 'boolean',],
        'BucketNameFilterRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'BundleType' => ['type' => 'string', 'enum' => ['tar', 'tgz', 'zip',],],
        'CommitId' => ['type' => 'string',],
        'ContinueDeploymentInput' => [
            'type' => 'structure',
            'members' => ['deploymentId' => ['shape' => 'DeploymentId',],],
        ],
        'CreateApplicationInput' => [
            'type' => 'structure',
            'required' => ['applicationName',],
            'members' => ['applicationName' => ['shape' => 'ApplicationName',],],
        ],
        'CreateApplicationOutput' => [
            'type' => 'structure',
            'members' => ['applicationId' => ['shape' => 'ApplicationId',],],
        ],
        'CreateDeploymentConfigInput' => [
            'type' => 'structure',
            'required' => ['deploymentConfigName',],
            'members' => [
                'deploymentConfigName' => ['shape' => 'DeploymentConfigName',],
                'minimumHealthyHosts' => ['shape' => 'MinimumHealthyHosts',],
            ],
        ],
        'CreateDeploymentConfigOutput' => [
            'type' => 'structure',
            'members' => ['deploymentConfigId' => ['shape' => 'DeploymentConfigId',],],
        ],
        'CreateDeploymentGroupInput' => [
            'type' => 'structure',
            'required' => ['applicationName', 'deploymentGroupName', 'serviceRoleArn',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'deploymentGroupName' => ['shape' => 'DeploymentGroupName',],
                'deploymentConfigName' => ['shape' => 'DeploymentConfigName',],
                'ec2TagFilters' => ['shape' => 'EC2TagFilterList',],
                'onPremisesInstanceTagFilters' => ['shape' => 'TagFilterList',],
                'autoScalingGroups' => ['shape' => 'AutoScalingGroupNameList',],
                'serviceRoleArn' => ['shape' => 'Role',],
                'triggerConfigurations' => ['shape' => 'TriggerConfigList',],
                'alarmConfiguration' => ['shape' => 'AlarmConfiguration',],
                'autoRollbackConfiguration' => ['shape' => 'AutoRollbackConfiguration',],
                'deploymentStyle' => ['shape' => 'DeploymentStyle',],
                'blueGreenDeploymentConfiguration' => ['shape' => 'BlueGreenDeploymentConfiguration',],
                'loadBalancerInfo' => ['shape' => 'LoadBalancerInfo',],
            ],
        ],
        'CreateDeploymentGroupOutput' => [
            'type' => 'structure',
            'members' => ['deploymentGroupId' => ['shape' => 'DeploymentGroupId',],],
        ],
        'CreateDeploymentInput' => [
            'type' => 'structure',
            'required' => ['applicationName',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'deploymentGroupName' => ['shape' => 'DeploymentGroupName',],
                'revision' => ['shape' => 'RevisionLocation',],
                'deploymentConfigName' => ['shape' => 'DeploymentConfigName',],
                'description' => ['shape' => 'Description',],
                'ignoreApplicationStopFailures' => ['shape' => 'Boolean',],
                'targetInstances' => ['shape' => 'TargetInstances',],
                'autoRollbackConfiguration' => ['shape' => 'AutoRollbackConfiguration',],
                'updateOutdatedInstancesOnly' => ['shape' => 'Boolean',],
                'fileExistsBehavior' => ['shape' => 'FileExistsBehavior',],
            ],
        ],
        'CreateDeploymentOutput' => [
            'type' => 'structure',
            'members' => ['deploymentId' => ['shape' => 'DeploymentId',],],
        ],
        'DeleteApplicationInput' => [
            'type' => 'structure',
            'required' => ['applicationName',],
            'members' => ['applicationName' => ['shape' => 'ApplicationName',],],
        ],
        'DeleteDeploymentConfigInput' => [
            'type' => 'structure',
            'required' => ['deploymentConfigName',],
            'members' => ['deploymentConfigName' => ['shape' => 'DeploymentConfigName',],],
        ],
        'DeleteDeploymentGroupInput' => [
            'type' => 'structure',
            'required' => ['applicationName', 'deploymentGroupName',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'deploymentGroupName' => ['shape' => 'DeploymentGroupName',],
            ],
        ],
        'DeleteDeploymentGroupOutput' => [
            'type' => 'structure',
            'members' => ['hooksNotCleanedUp' => ['shape' => 'AutoScalingGroupList',],],
        ],
        'DeploymentAlreadyCompletedException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentConfigAlreadyExistsException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentConfigDoesNotExistException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentConfigId' => ['type' => 'string',],
        'DeploymentConfigInUseException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentConfigInfo' => [
            'type' => 'structure',
            'members' => [
                'deploymentConfigId' => ['shape' => 'DeploymentConfigId',],
                'deploymentConfigName' => ['shape' => 'DeploymentConfigName',],
                'minimumHealthyHosts' => ['shape' => 'MinimumHealthyHosts',],
                'createTime' => ['shape' => 'Timestamp',],
            ],
        ],
        'DeploymentConfigLimitExceededException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentConfigName' => ['type' => 'string', 'max' => 100, 'min' => 1,],
        'DeploymentConfigNameRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentConfigsList' => ['type' => 'list', 'member' => ['shape' => 'DeploymentConfigName',],],
        'DeploymentCreator' => ['type' => 'string', 'enum' => ['user', 'autoscaling', 'codeDeployRollback',],],
        'DeploymentDoesNotExistException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentGroupAlreadyExistsException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentGroupDoesNotExistException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentGroupId' => ['type' => 'string',],
        'DeploymentGroupInfo' => [
            'type' => 'structure',
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'deploymentGroupId' => ['shape' => 'DeploymentGroupId',],
                'deploymentGroupName' => ['shape' => 'DeploymentGroupName',],
                'deploymentConfigName' => ['shape' => 'DeploymentConfigName',],
                'ec2TagFilters' => ['shape' => 'EC2TagFilterList',],
                'onPremisesInstanceTagFilters' => ['shape' => 'TagFilterList',],
                'autoScalingGroups' => ['shape' => 'AutoScalingGroupList',],
                'serviceRoleArn' => ['shape' => 'Role',],
                'targetRevision' => ['shape' => 'RevisionLocation',],
                'triggerConfigurations' => ['shape' => 'TriggerConfigList',],
                'alarmConfiguration' => ['shape' => 'AlarmConfiguration',],
                'autoRollbackConfiguration' => ['shape' => 'AutoRollbackConfiguration',],
                'deploymentStyle' => ['shape' => 'DeploymentStyle',],
                'blueGreenDeploymentConfiguration' => ['shape' => 'BlueGreenDeploymentConfiguration',],
                'loadBalancerInfo' => ['shape' => 'LoadBalancerInfo',],
                'lastSuccessfulDeployment' => ['shape' => 'LastDeploymentInfo',],
                'lastAttemptedDeployment' => ['shape' => 'LastDeploymentInfo',],
            ],
        ],
        'DeploymentGroupInfoList' => ['type' => 'list', 'member' => ['shape' => 'DeploymentGroupInfo',],],
        'DeploymentGroupLimitExceededException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentGroupName' => ['type' => 'string', 'max' => 100, 'min' => 1,],
        'DeploymentGroupNameRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentGroupsList' => ['type' => 'list', 'member' => ['shape' => 'DeploymentGroupName',],],
        'DeploymentId' => ['type' => 'string',],
        'DeploymentIdRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentInfo' => [
            'type' => 'structure',
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'deploymentGroupName' => ['shape' => 'DeploymentGroupName',],
                'deploymentConfigName' => ['shape' => 'DeploymentConfigName',],
                'deploymentId' => ['shape' => 'DeploymentId',],
                'previousRevision' => ['shape' => 'RevisionLocation',],
                'revision' => ['shape' => 'RevisionLocation',],
                'status' => ['shape' => 'DeploymentStatus',],
                'errorInformation' => ['shape' => 'ErrorInformation',],
                'createTime' => ['shape' => 'Timestamp',],
                'startTime' => ['shape' => 'Timestamp',],
                'completeTime' => ['shape' => 'Timestamp',],
                'deploymentOverview' => ['shape' => 'DeploymentOverview',],
                'description' => ['shape' => 'Description',],
                'creator' => ['shape' => 'DeploymentCreator',],
                'ignoreApplicationStopFailures' => ['shape' => 'Boolean',],
                'autoRollbackConfiguration' => ['shape' => 'AutoRollbackConfiguration',],
                'updateOutdatedInstancesOnly' => ['shape' => 'Boolean',],
                'rollbackInfo' => ['shape' => 'RollbackInfo',],
                'deploymentStyle' => ['shape' => 'DeploymentStyle',],
                'targetInstances' => ['shape' => 'TargetInstances',],
                'instanceTerminationWaitTimeStarted' => ['shape' => 'Boolean',],
                'blueGreenDeploymentConfiguration' => ['shape' => 'BlueGreenDeploymentConfiguration',],
                'loadBalancerInfo' => ['shape' => 'LoadBalancerInfo',],
                'additionalDeploymentStatusInfo' => ['shape' => 'AdditionalDeploymentStatusInfo',],
                'fileExistsBehavior' => ['shape' => 'FileExistsBehavior',],
            ],
        ],
        'DeploymentIsNotInReadyStateException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentLimitExceededException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentNotStartedException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'DeploymentOption' => ['type' => 'string', 'enum' => ['WITH_TRAFFIC_CONTROL', 'WITHOUT_TRAFFIC_CONTROL',],],
        'DeploymentOverview' => [
            'type' => 'structure',
            'members' => [
                'Pending' => ['shape' => 'InstanceCount',],
                'InProgress' => ['shape' => 'InstanceCount',],
                'Succeeded' => ['shape' => 'InstanceCount',],
                'Failed' => ['shape' => 'InstanceCount',],
                'Skipped' => ['shape' => 'InstanceCount',],
                'Ready' => ['shape' => 'InstanceCount',],
            ],
        ],
        'DeploymentReadyAction' => ['type' => 'string', 'enum' => ['CONTINUE_DEPLOYMENT', 'STOP_DEPLOYMENT',],],
        'DeploymentReadyOption' => [
            'type' => 'structure',
            'members' => [
                'actionOnTimeout' => ['shape' => 'DeploymentReadyAction',],
                'waitTimeInMinutes' => ['shape' => 'Duration',],
            ],
        ],
        'DeploymentStatus' => [
            'type' => 'string',
            'enum' => ['Created', 'Queued', 'InProgress', 'Succeeded', 'Failed', 'Stopped', 'Ready',],
        ],
        'DeploymentStatusList' => ['type' => 'list', 'member' => ['shape' => 'DeploymentStatus',],],
        'DeploymentStyle' => [
            'type' => 'structure',
            'members' => [
                'deploymentType' => ['shape' => 'DeploymentType',],
                'deploymentOption' => ['shape' => 'DeploymentOption',],
            ],
        ],
        'DeploymentType' => ['type' => 'string', 'enum' => ['IN_PLACE', 'BLUE_GREEN',],],
        'DeploymentsInfoList' => ['type' => 'list', 'member' => ['shape' => 'DeploymentInfo',],],
        'DeploymentsList' => ['type' => 'list', 'member' => ['shape' => 'DeploymentId',],],
        'DeregisterOnPremisesInstanceInput' => [
            'type' => 'structure',
            'required' => ['instanceName',],
            'members' => ['instanceName' => ['shape' => 'InstanceName',],],
        ],
        'Description' => ['type' => 'string',],
        'DescriptionTooLongException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'Diagnostics' => [
            'type' => 'structure',
            'members' => [
                'errorCode' => ['shape' => 'LifecycleErrorCode',],
                'scriptName' => ['shape' => 'ScriptName',],
                'message' => ['shape' => 'LifecycleMessage',],
                'logTail' => ['shape' => 'LogTail',],
            ],
        ],
        'Duration' => ['type' => 'integer',],
        'EC2TagFilter' => [
            'type' => 'structure',
            'members' => [
                'Key' => ['shape' => 'Key',],
                'Value' => ['shape' => 'Value',],
                'Type' => ['shape' => 'EC2TagFilterType',],
            ],
        ],
        'EC2TagFilterList' => ['type' => 'list', 'member' => ['shape' => 'EC2TagFilter',],],
        'EC2TagFilterType' => ['type' => 'string', 'enum' => ['KEY_ONLY', 'VALUE_ONLY', 'KEY_AND_VALUE',],],
        'ELBInfo' => ['type' => 'structure', 'members' => ['name' => ['shape' => 'ELBName',],],],
        'ELBInfoList' => ['type' => 'list', 'member' => ['shape' => 'ELBInfo',],],
        'ELBName' => ['type' => 'string',],
        'ETag' => ['type' => 'string',],
        'ErrorCode' => [
            'type' => 'string',
            'enum' => [
                'DEPLOYMENT_GROUP_MISSING',
                'APPLICATION_MISSING',
                'REVISION_MISSING',
                'IAM_ROLE_MISSING',
                'IAM_ROLE_PERMISSIONS',
                'NO_EC2_SUBSCRIPTION',
                'OVER_MAX_INSTANCES',
                'NO_INSTANCES',
                'TIMEOUT',
                'HEALTH_CONSTRAINTS_INVALID',
                'HEALTH_CONSTRAINTS',
                'INTERNAL_ERROR',
                'THROTTLED',
                'ALARM_ACTIVE',
                'AGENT_ISSUE',
                'AUTO_SCALING_IAM_ROLE_PERMISSIONS',
                'AUTO_SCALING_CONFIGURATION',
                'MANUAL_STOP',
            ],
        ],
        'ErrorInformation' => [
            'type' => 'structure',
            'members' => ['code' => ['shape' => 'ErrorCode',], 'message' => ['shape' => 'ErrorMessage',],],
        ],
        'ErrorMessage' => ['type' => 'string',],
        'FileExistsBehavior' => ['type' => 'string', 'enum' => ['DISALLOW', 'OVERWRITE', 'RETAIN',],],
        'GenericRevisionInfo' => [
            'type' => 'structure',
            'members' => [
                'description' => ['shape' => 'Description',],
                'deploymentGroups' => ['shape' => 'DeploymentGroupsList',],
                'firstUsedTime' => ['shape' => 'Timestamp',],
                'lastUsedTime' => ['shape' => 'Timestamp',],
                'registerTime' => ['shape' => 'Timestamp',],
            ],
        ],
        'GetApplicationInput' => [
            'type' => 'structure',
            'required' => ['applicationName',],
            'members' => ['applicationName' => ['shape' => 'ApplicationName',],],
        ],
        'GetApplicationOutput' => [
            'type' => 'structure',
            'members' => ['application' => ['shape' => 'ApplicationInfo',],],
        ],
        'GetApplicationRevisionInput' => [
            'type' => 'structure',
            'required' => ['applicationName', 'revision',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'revision' => ['shape' => 'RevisionLocation',],
            ],
        ],
        'GetApplicationRevisionOutput' => [
            'type' => 'structure',
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'revision' => ['shape' => 'RevisionLocation',],
                'revisionInfo' => ['shape' => 'GenericRevisionInfo',],
            ],
        ],
        'GetDeploymentConfigInput' => [
            'type' => 'structure',
            'required' => ['deploymentConfigName',],
            'members' => ['deploymentConfigName' => ['shape' => 'DeploymentConfigName',],],
        ],
        'GetDeploymentConfigOutput' => [
            'type' => 'structure',
            'members' => ['deploymentConfigInfo' => ['shape' => 'DeploymentConfigInfo',],],
        ],
        'GetDeploymentGroupInput' => [
            'type' => 'structure',
            'required' => ['applicationName', 'deploymentGroupName',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'deploymentGroupName' => ['shape' => 'DeploymentGroupName',],
            ],
        ],
        'GetDeploymentGroupOutput' => [
            'type' => 'structure',
            'members' => ['deploymentGroupInfo' => ['shape' => 'DeploymentGroupInfo',],],
        ],
        'GetDeploymentInput' => [
            'type' => 'structure',
            'required' => ['deploymentId',],
            'members' => ['deploymentId' => ['shape' => 'DeploymentId',],],
        ],
        'GetDeploymentInstanceInput' => [
            'type' => 'structure',
            'required' => ['deploymentId', 'instanceId',],
            'members' => ['deploymentId' => ['shape' => 'DeploymentId',], 'instanceId' => ['shape' => 'InstanceId',],],
        ],
        'GetDeploymentInstanceOutput' => [
            'type' => 'structure',
            'members' => ['instanceSummary' => ['shape' => 'InstanceSummary',],],
        ],
        'GetDeploymentOutput' => [
            'type' => 'structure',
            'members' => ['deploymentInfo' => ['shape' => 'DeploymentInfo',],],
        ],
        'GetOnPremisesInstanceInput' => [
            'type' => 'structure',
            'required' => ['instanceName',],
            'members' => ['instanceName' => ['shape' => 'InstanceName',],],
        ],
        'GetOnPremisesInstanceOutput' => [
            'type' => 'structure',
            'members' => ['instanceInfo' => ['shape' => 'InstanceInfo',],],
        ],
        'GitHubAccountTokenDoesNotExistException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'GitHubAccountTokenName' => ['type' => 'string',],
        'GitHubAccountTokenNameList' => ['type' => 'list', 'member' => ['shape' => 'GitHubAccountTokenName',],],
        'GitHubLocation' => [
            'type' => 'structure',
            'members' => ['repository' => ['shape' => 'Repository',], 'commitId' => ['shape' => 'CommitId',],],
        ],
        'GreenFleetProvisioningAction' => [
            'type' => 'string',
            'enum' => ['DISCOVER_EXISTING', 'COPY_AUTO_SCALING_GROUP',],
        ],
        'GreenFleetProvisioningOption' => [
            'type' => 'structure',
            'members' => ['action' => ['shape' => 'GreenFleetProvisioningAction',],],
        ],
        'IamArnRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'IamSessionArn' => ['type' => 'string',],
        'IamSessionArnAlreadyRegisteredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'IamUserArn' => ['type' => 'string',],
        'IamUserArnAlreadyRegisteredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'IamUserArnRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InstanceAction' => ['type' => 'string', 'enum' => ['TERMINATE', 'KEEP_ALIVE',],],
        'InstanceArn' => ['type' => 'string',],
        'InstanceCount' => ['type' => 'long',],
        'InstanceDoesNotExistException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InstanceId' => ['type' => 'string',],
        'InstanceIdRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InstanceInfo' => [
            'type' => 'structure',
            'members' => [
                'instanceName' => ['shape' => 'InstanceName',],
                'iamSessionArn' => ['shape' => 'IamSessionArn',],
                'iamUserArn' => ['shape' => 'IamUserArn',],
                'instanceArn' => ['shape' => 'InstanceArn',],
                'registerTime' => ['shape' => 'Timestamp',],
                'deregisterTime' => ['shape' => 'Timestamp',],
                'tags' => ['shape' => 'TagList',],
            ],
        ],
        'InstanceInfoList' => ['type' => 'list', 'member' => ['shape' => 'InstanceInfo',],],
        'InstanceLimitExceededException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InstanceName' => ['type' => 'string',],
        'InstanceNameAlreadyRegisteredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InstanceNameList' => ['type' => 'list', 'member' => ['shape' => 'InstanceName',],],
        'InstanceNameRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InstanceNotRegisteredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InstanceStatus' => [
            'type' => 'string',
            'enum' => ['Pending', 'InProgress', 'Succeeded', 'Failed', 'Skipped', 'Unknown', 'Ready',],
        ],
        'InstanceStatusList' => ['type' => 'list', 'member' => ['shape' => 'InstanceStatus',],],
        'InstanceSummary' => [
            'type' => 'structure',
            'members' => [
                'deploymentId' => ['shape' => 'DeploymentId',],
                'instanceId' => ['shape' => 'InstanceId',],
                'status' => ['shape' => 'InstanceStatus',],
                'lastUpdatedAt' => ['shape' => 'Timestamp',],
                'lifecycleEvents' => ['shape' => 'LifecycleEventList',],
                'instanceType' => ['shape' => 'InstanceType',],
            ],
        ],
        'InstanceSummaryList' => ['type' => 'list', 'member' => ['shape' => 'InstanceSummary',],],
        'InstanceType' => ['type' => 'string', 'enum' => ['Blue', 'Green',],],
        'InstanceTypeList' => ['type' => 'list', 'member' => ['shape' => 'InstanceType',],],
        'InstancesList' => ['type' => 'list', 'member' => ['shape' => 'InstanceId',],],
        'InvalidAlarmConfigException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidApplicationNameException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidAutoRollbackConfigException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidAutoScalingGroupException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidBlueGreenDeploymentConfigurationException' => [
            'type' => 'structure',
            'members' => [],
            'exception' => true,
        ],
        'InvalidBucketNameFilterException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidDeployedStateFilterException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidDeploymentConfigNameException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidDeploymentGroupNameException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidDeploymentIdException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidDeploymentInstanceTypeException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidDeploymentStatusException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidDeploymentStyleException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidEC2TagException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidFileExistsBehaviorException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidIamSessionArnException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidIamUserArnException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidInstanceNameException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidInstanceStatusException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidInstanceTypeException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidKeyPrefixFilterException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidLoadBalancerInfoException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidMinimumHealthyHostValueException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidNextTokenException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidOperationException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidRegistrationStatusException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidRevisionException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidRoleException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidSortByException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidSortOrderException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidTagException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidTagFilterException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidTargetInstancesException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidTimeRangeException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'InvalidTriggerConfigException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'Key' => ['type' => 'string',],
        'LastDeploymentInfo' => [
            'type' => 'structure',
            'members' => [
                'deploymentId' => ['shape' => 'DeploymentId',],
                'status' => ['shape' => 'DeploymentStatus',],
                'endTime' => ['shape' => 'Timestamp',],
                'createTime' => ['shape' => 'Timestamp',],
            ],
        ],
        'LifecycleErrorCode' => [
            'type' => 'string',
            'enum' => [
                'Success',
                'ScriptMissing',
                'ScriptNotExecutable',
                'ScriptTimedOut',
                'ScriptFailed',
                'UnknownError',
            ],
        ],
        'LifecycleEvent' => [
            'type' => 'structure',
            'members' => [
                'lifecycleEventName' => ['shape' => 'LifecycleEventName',],
                'diagnostics' => ['shape' => 'Diagnostics',],
                'startTime' => ['shape' => 'Timestamp',],
                'endTime' => ['shape' => 'Timestamp',],
                'status' => ['shape' => 'LifecycleEventStatus',],
            ],
        ],
        'LifecycleEventList' => ['type' => 'list', 'member' => ['shape' => 'LifecycleEvent',],],
        'LifecycleEventName' => ['type' => 'string',],
        'LifecycleEventStatus' => [
            'type' => 'string',
            'enum' => ['Pending', 'InProgress', 'Succeeded', 'Failed', 'Skipped', 'Unknown',],
        ],
        'LifecycleHookLimitExceededException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'LifecycleMessage' => ['type' => 'string',],
        'ListApplicationRevisionsInput' => [
            'type' => 'structure',
            'required' => ['applicationName',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'sortBy' => ['shape' => 'ApplicationRevisionSortBy',],
                'sortOrder' => ['shape' => 'SortOrder',],
                's3Bucket' => ['shape' => 'S3Bucket',],
                's3KeyPrefix' => ['shape' => 'S3Key',],
                'deployed' => ['shape' => 'ListStateFilterAction',],
                'nextToken' => ['shape' => 'NextToken',],
            ],
        ],
        'ListApplicationRevisionsOutput' => [
            'type' => 'structure',
            'members' => [
                'revisions' => ['shape' => 'RevisionLocationList',],
                'nextToken' => ['shape' => 'NextToken',],
            ],
        ],
        'ListApplicationsInput' => ['type' => 'structure', 'members' => ['nextToken' => ['shape' => 'NextToken',],],],
        'ListApplicationsOutput' => [
            'type' => 'structure',
            'members' => [
                'applications' => ['shape' => 'ApplicationsList',],
                'nextToken' => ['shape' => 'NextToken',],
            ],
        ],
        'ListDeploymentConfigsInput' => [
            'type' => 'structure',
            'members' => ['nextToken' => ['shape' => 'NextToken',],],
        ],
        'ListDeploymentConfigsOutput' => [
            'type' => 'structure',
            'members' => [
                'deploymentConfigsList' => ['shape' => 'DeploymentConfigsList',],
                'nextToken' => ['shape' => 'NextToken',],
            ],
        ],
        'ListDeploymentGroupsInput' => [
            'type' => 'structure',
            'required' => ['applicationName',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'nextToken' => ['shape' => 'NextToken',],
            ],
        ],
        'ListDeploymentGroupsOutput' => [
            'type' => 'structure',
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'deploymentGroups' => ['shape' => 'DeploymentGroupsList',],
                'nextToken' => ['shape' => 'NextToken',],
            ],
        ],
        'ListDeploymentInstancesInput' => [
            'type' => 'structure',
            'required' => ['deploymentId',],
            'members' => [
                'deploymentId' => ['shape' => 'DeploymentId',],
                'nextToken' => ['shape' => 'NextToken',],
                'instanceStatusFilter' => ['shape' => 'InstanceStatusList',],
                'instanceTypeFilter' => ['shape' => 'InstanceTypeList',],
            ],
        ],
        'ListDeploymentInstancesOutput' => [
            'type' => 'structure',
            'members' => ['instancesList' => ['shape' => 'InstancesList',], 'nextToken' => ['shape' => 'NextToken',],],
        ],
        'ListDeploymentsInput' => [
            'type' => 'structure',
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'deploymentGroupName' => ['shape' => 'DeploymentGroupName',],
                'includeOnlyStatuses' => ['shape' => 'DeploymentStatusList',],
                'createTimeRange' => ['shape' => 'TimeRange',],
                'nextToken' => ['shape' => 'NextToken',],
            ],
        ],
        'ListDeploymentsOutput' => [
            'type' => 'structure',
            'members' => ['deployments' => ['shape' => 'DeploymentsList',], 'nextToken' => ['shape' => 'NextToken',],],
        ],
        'ListGitHubAccountTokenNamesInput' => [
            'type' => 'structure',
            'members' => ['nextToken' => ['shape' => 'NextToken',],],
        ],
        'ListGitHubAccountTokenNamesOutput' => [
            'type' => 'structure',
            'members' => [
                'tokenNameList' => ['shape' => 'GitHubAccountTokenNameList',],
                'nextToken' => ['shape' => 'NextToken',],
            ],
        ],
        'ListOnPremisesInstancesInput' => [
            'type' => 'structure',
            'members' => [
                'registrationStatus' => ['shape' => 'RegistrationStatus',],
                'tagFilters' => ['shape' => 'TagFilterList',],
                'nextToken' => ['shape' => 'NextToken',],
            ],
        ],
        'ListOnPremisesInstancesOutput' => [
            'type' => 'structure',
            'members' => [
                'instanceNames' => ['shape' => 'InstanceNameList',],
                'nextToken' => ['shape' => 'NextToken',],
            ],
        ],
        'ListStateFilterAction' => ['type' => 'string', 'enum' => ['include', 'exclude', 'ignore',],],
        'LoadBalancerInfo' => ['type' => 'structure', 'members' => ['elbInfoList' => ['shape' => 'ELBInfoList',],],],
        'LogTail' => ['type' => 'string',],
        'Message' => ['type' => 'string',],
        'MinimumHealthyHosts' => [
            'type' => 'structure',
            'members' => [
                'value' => ['shape' => 'MinimumHealthyHostsValue',],
                'type' => ['shape' => 'MinimumHealthyHostsType',],
            ],
        ],
        'MinimumHealthyHostsType' => ['type' => 'string', 'enum' => ['HOST_COUNT', 'FLEET_PERCENT',],],
        'MinimumHealthyHostsValue' => ['type' => 'integer',],
        'MultipleIamArnsProvidedException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'NextToken' => ['type' => 'string',],
        'NullableBoolean' => ['type' => 'boolean',],
        'RegisterApplicationRevisionInput' => [
            'type' => 'structure',
            'required' => ['applicationName', 'revision',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'description' => ['shape' => 'Description',],
                'revision' => ['shape' => 'RevisionLocation',],
            ],
        ],
        'RegisterOnPremisesInstanceInput' => [
            'type' => 'structure',
            'required' => ['instanceName',],
            'members' => [
                'instanceName' => ['shape' => 'InstanceName',],
                'iamSessionArn' => ['shape' => 'IamSessionArn',],
                'iamUserArn' => ['shape' => 'IamUserArn',],
            ],
        ],
        'RegistrationStatus' => ['type' => 'string', 'enum' => ['Registered', 'Deregistered',],],
        'RemoveTagsFromOnPremisesInstancesInput' => [
            'type' => 'structure',
            'required' => ['tags', 'instanceNames',],
            'members' => ['tags' => ['shape' => 'TagList',], 'instanceNames' => ['shape' => 'InstanceNameList',],],
        ],
        'Repository' => ['type' => 'string',],
        'ResourceValidationException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'RevisionDoesNotExistException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'RevisionInfo' => [
            'type' => 'structure',
            'members' => [
                'revisionLocation' => ['shape' => 'RevisionLocation',],
                'genericRevisionInfo' => ['shape' => 'GenericRevisionInfo',],
            ],
        ],
        'RevisionInfoList' => ['type' => 'list', 'member' => ['shape' => 'RevisionInfo',],],
        'RevisionLocation' => [
            'type' => 'structure',
            'members' => [
                'revisionType' => ['shape' => 'RevisionLocationType',],
                's3Location' => ['shape' => 'S3Location',],
                'gitHubLocation' => ['shape' => 'GitHubLocation',],
            ],
        ],
        'RevisionLocationList' => ['type' => 'list', 'member' => ['shape' => 'RevisionLocation',],],
        'RevisionLocationType' => ['type' => 'string', 'enum' => ['S3', 'GitHub',],],
        'RevisionRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'Role' => ['type' => 'string',],
        'RoleRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'RollbackInfo' => [
            'type' => 'structure',
            'members' => [
                'rollbackDeploymentId' => ['shape' => 'DeploymentId',],
                'rollbackTriggeringDeploymentId' => ['shape' => 'DeploymentId',],
                'rollbackMessage' => ['shape' => 'Description',],
            ],
        ],
        'S3Bucket' => ['type' => 'string',],
        'S3Key' => ['type' => 'string',],
        'S3Location' => [
            'type' => 'structure',
            'members' => [
                'bucket' => ['shape' => 'S3Bucket',],
                'key' => ['shape' => 'S3Key',],
                'bundleType' => ['shape' => 'BundleType',],
                'version' => ['shape' => 'VersionId',],
                'eTag' => ['shape' => 'ETag',],
            ],
        ],
        'ScriptName' => ['type' => 'string',],
        'SkipWaitTimeForInstanceTerminationInput' => [
            'type' => 'structure',
            'members' => ['deploymentId' => ['shape' => 'DeploymentId',],],
        ],
        'SortOrder' => ['type' => 'string', 'enum' => ['ascending', 'descending',],],
        'StopDeploymentInput' => [
            'type' => 'structure',
            'required' => ['deploymentId',],
            'members' => [
                'deploymentId' => ['shape' => 'DeploymentId',],
                'autoRollbackEnabled' => ['shape' => 'NullableBoolean',],
            ],
        ],
        'StopDeploymentOutput' => [
            'type' => 'structure',
            'members' => ['status' => ['shape' => 'StopStatus',], 'statusMessage' => ['shape' => 'Message',],],
        ],
        'StopStatus' => ['type' => 'string', 'enum' => ['Pending', 'Succeeded',],],
        'Tag' => [
            'type' => 'structure',
            'members' => ['Key' => ['shape' => 'Key',], 'Value' => ['shape' => 'Value',],],
        ],
        'TagFilter' => [
            'type' => 'structure',
            'members' => [
                'Key' => ['shape' => 'Key',],
                'Value' => ['shape' => 'Value',],
                'Type' => ['shape' => 'TagFilterType',],
            ],
        ],
        'TagFilterList' => ['type' => 'list', 'member' => ['shape' => 'TagFilter',],],
        'TagFilterType' => ['type' => 'string', 'enum' => ['KEY_ONLY', 'VALUE_ONLY', 'KEY_AND_VALUE',],],
        'TagLimitExceededException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'TagList' => ['type' => 'list', 'member' => ['shape' => 'Tag',],],
        'TagRequiredException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'TargetInstances' => [
            'type' => 'structure',
            'members' => [
                'tagFilters' => ['shape' => 'EC2TagFilterList',],
                'autoScalingGroups' => ['shape' => 'AutoScalingGroupNameList',],
            ],
        ],
        'TimeRange' => [
            'type' => 'structure',
            'members' => ['start' => ['shape' => 'Timestamp',], 'end' => ['shape' => 'Timestamp',],],
        ],
        'Timestamp' => ['type' => 'timestamp',],
        'TriggerConfig' => [
            'type' => 'structure',
            'members' => [
                'triggerName' => ['shape' => 'TriggerName',],
                'triggerTargetArn' => ['shape' => 'TriggerTargetArn',],
                'triggerEvents' => ['shape' => 'TriggerEventTypeList',],
            ],
        ],
        'TriggerConfigList' => ['type' => 'list', 'member' => ['shape' => 'TriggerConfig',],],
        'TriggerEventType' => [
            'type' => 'string',
            'enum' => [
                'DeploymentStart',
                'DeploymentSuccess',
                'DeploymentFailure',
                'DeploymentStop',
                'DeploymentRollback',
                'DeploymentReady',
                'InstanceStart',
                'InstanceSuccess',
                'InstanceFailure',
                'InstanceReady',
            ],
        ],
        'TriggerEventTypeList' => ['type' => 'list', 'member' => ['shape' => 'TriggerEventType',],],
        'TriggerName' => ['type' => 'string',],
        'TriggerTargetArn' => ['type' => 'string',],
        'TriggerTargetsLimitExceededException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'UnsupportedActionForDeploymentTypeException' => ['type' => 'structure', 'members' => [], 'exception' => true,],
        'UpdateApplicationInput' => [
            'type' => 'structure',
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'newApplicationName' => ['shape' => 'ApplicationName',],
            ],
        ],
        'UpdateDeploymentGroupInput' => [
            'type' => 'structure',
            'required' => ['applicationName', 'currentDeploymentGroupName',],
            'members' => [
                'applicationName' => ['shape' => 'ApplicationName',],
                'currentDeploymentGroupName' => ['shape' => 'DeploymentGroupName',],
                'newDeploymentGroupName' => ['shape' => 'DeploymentGroupName',],
                'deploymentConfigName' => ['shape' => 'DeploymentConfigName',],
                'ec2TagFilters' => ['shape' => 'EC2TagFilterList',],
                'onPremisesInstanceTagFilters' => ['shape' => 'TagFilterList',],
                'autoScalingGroups' => ['shape' => 'AutoScalingGroupNameList',],
                'serviceRoleArn' => ['shape' => 'Role',],
                'triggerConfigurations' => ['shape' => 'TriggerConfigList',],
                'alarmConfiguration' => ['shape' => 'AlarmConfiguration',],
                'autoRollbackConfiguration' => ['shape' => 'AutoRollbackConfiguration',],
                'deploymentStyle' => ['shape' => 'DeploymentStyle',],
                'blueGreenDeploymentConfiguration' => ['shape' => 'BlueGreenDeploymentConfiguration',],
                'loadBalancerInfo' => ['shape' => 'LoadBalancerInfo',],
            ],
        ],
        'UpdateDeploymentGroupOutput' => [
            'type' => 'structure',
            'members' => ['hooksNotCleanedUp' => ['shape' => 'AutoScalingGroupList',],],
        ],
        'Value' => ['type' => 'string',],
        'VersionId' => ['type' => 'string',],
    ],
];
